/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xml.internal.serializer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xml.sax.ContentHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptorManager;
import org.xwiki.rendering.xml.internal.XMLConfiguration;
import org.xwiki.rendering.xml.internal.parameter.ParameterManager;
import org.xwiki.rendering.xml.internal.serializer.DefaultXMLSerializer;
import org.xwiki.rendering.xml.internal.serializer.XMLSerializerFactory;

@Component
@Singleton
public class DefaultXMLSerializerFactory
implements XMLSerializerFactory {
    @Inject
    private ParameterManager parameterManager;
    @Inject
    private ListenerDescriptorManager descriptorManager;
    @Inject
    private ConverterManager converter;

    @Override
    public <T> T createSerializer(Class<T> listenerClass, ContentHandler contentHandler, XMLConfiguration configuration) {
        DefaultXMLSerializer handler = new DefaultXMLSerializer(contentHandler, this.parameterManager, this.descriptorManager.getListenerDescriptor(listenerClass), this.converter, configuration);
        return (T)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)handler);
    }
}

