/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xml.internal.parser;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerElement;
import org.xwiki.rendering.xml.internal.XMLConfiguration;
import org.xwiki.rendering.xml.internal.XMLUtils;
import org.xwiki.rendering.xml.internal.parameter.ParameterManager;
import org.xwiki.rendering.xml.internal.parser.XMLParser;
import org.xwiki.xml.Sax2Dom;

public class DefaultXMLParser
extends DefaultHandler
implements XMLParser {
    private ParameterManager parameterManager;
    private ConverterManager stringConverter;
    private ListenerDescriptor listenerDescriptor;
    private Object listener;
    private Stack<Block> blockStack = new Stack();
    private int elementDepth = 0;
    private StringBuilder content;
    private XMLConfiguration configuration;

    public DefaultXMLParser(Object listener, ListenerDescriptor listenerDescriptor, ConverterManager stringConverter, ParameterManager parameterManager, XMLConfiguration configuration) {
        this.listener = listener;
        this.listenerDescriptor = listenerDescriptor;
        this.stringConverter = stringConverter;
        this.parameterManager = parameterManager;
        this.configuration = configuration != null ? configuration : new XMLConfiguration();
    }

    private boolean onBlockChild() {
        if (!this.blockStack.isEmpty()) {
            Block currentBlock = this.blockStack.peek();
            return currentBlock.elementDepth == this.elementDepth - 1;
        }
        boolean result = false;
        return result;
    }

    private boolean onBlockElement(String elementName) {
        boolean result;
        if (!this.blockStack.isEmpty()) {
            Block currentBlock = this.blockStack.peek();
            result = this.elementDepth - currentBlock.elementDepth <= 1 && !this.configuration.getElementParameterPattern().matcher(elementName).matches();
        } else {
            result = true;
        }
        return result;
    }

    private boolean onParameterElement(String elementName) {
        return this.onBlockChild() && this.configuration.getElementParameterPattern().matcher(elementName).matches();
    }

    private int extractParameterIndex(String elementName) {
        Matcher matcher = this.configuration.getElementParameterPattern().matcher(elementName);
        matcher.find();
        return Integer.valueOf(matcher.group(1));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Block currentBlock;
        Block block = currentBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        if (this.onBlockElement(qName)) {
            if (currentBlock != null && currentBlock.listenerElement != null && !currentBlock.beginSent) {
                currentBlock.fireBeginEvent(this.listener, currentBlock.getParametersTable());
            }
            Block block2 = this.getBlock(qName, attributes);
            currentBlock = this.blockStack.push(block2);
            if (!block2.isContainer() && block2.listenerElement.getParameters().size() == 1 && XMLUtils.isSimpleType((Type)block2.listenerElement.getParameters().get(0))) {
                this.content = new StringBuilder();
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getQName(i);
                if (!this.configuration.getElementParameterPattern().matcher(attributeName).matches()) continue;
                int parameterIndex = this.extractParameterIndex(attributeName);
                Type type = (Type)block2.listenerElement.getParameters().get(parameterIndex);
                Class typeClass = ReflectionUtils.getTypeClass((Type)type);
                if (XMLUtils.isSimpleType(typeClass)) {
                    block2.setParameter(parameterIndex, this.stringConverter.convert(type, (Object)attributes.getValue(i)));
                    continue;
                }
                block2.setParameter(parameterIndex, XMLUtils.defaultValue(typeClass));
            }
        } else {
            if (this.onParameterElement(qName) && currentBlock.listenerElement != null) {
                try {
                    currentBlock.parameterDOMBuilder = new Sax2Dom();
                }
                catch (ParserConfigurationException e) {
                    throw new SAXException("Failed to create new Sax2Dom handler", e);
                }
                currentBlock.parameterDOMBuilder.startDocument();
            }
            if (currentBlock.parameterDOMBuilder != null) {
                currentBlock.parameterDOMBuilder.startElement(uri, localName, qName, attributes);
            }
        }
        ++this.elementDepth;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Block currentBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        --this.elementDepth;
        if (this.onBlockElement(qName)) {
            Block block = this.blockStack.pop();
            if (block.listenerElement != null) {
                if (block.isContainer()) {
                    if (!block.beginSent) {
                        block.fireBeginEvent(this.listener, block.getParametersTable());
                    }
                    block.fireEndEvent(this.listener, block.getParametersTable());
                } else {
                    if (block.getParametersList().size() == 0 && ((ListenerElement)this.listenerDescriptor.getElements().get(qName.toLowerCase())).getParameters().size() == 1) {
                        block.setParameter(0, this.stringConverter.convert((Type)((ListenerElement)this.listenerDescriptor.getElements().get(qName.toLowerCase())).getParameters().get(0), (Object)this.content.toString()));
                        this.content = null;
                    }
                    block.fireOnEvent(this.listener, block.getParametersTable());
                }
            }
        } else if (currentBlock.parameterDOMBuilder != null) {
            currentBlock.parameterDOMBuilder.endElement(uri, localName, qName);
            if (this.onParameterElement(qName)) {
                if (currentBlock.listenerElement != null) {
                    currentBlock.parameterDOMBuilder.endDocument();
                    ListenerElement listenerElement = currentBlock.listenerElement;
                    Type parameterType = (Type)listenerElement.getParameters().get(this.extractParameterIndex(qName));
                    Element rootElement = currentBlock.parameterDOMBuilder.getRootElement();
                    int parameterIndex = this.extractParameterIndex(qName);
                    currentBlock.setParameter(parameterIndex, this.parameterManager.unSerialize(parameterType, rootElement));
                }
                currentBlock.parameterDOMBuilder = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parameterDOMBuilder != null) {
            this.blockStack.peek().parameterDOMBuilder.characters(ch, start, length);
        } else if (this.content != null) {
            this.content.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parameterDOMBuilder != null) {
            this.blockStack.peek().parameterDOMBuilder.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parameterDOMBuilder != null) {
            this.blockStack.peek().parameterDOMBuilder.skippedEntity(name);
        }
    }

    private Block getBlock(String qName, Attributes attributes) {
        String blockName = this.configuration.getElementBlock().equals(qName) ? attributes.getValue(this.configuration.getAttributeBlockName()) : qName;
        ListenerElement element = (ListenerElement)this.listenerDescriptor.getElements().get(blockName.toLowerCase());
        return new Block(element, this.elementDepth);
    }

    public static class Block {
        public ListenerElement listenerElement;
        public boolean beginSent = false;
        public List<Object> parametersList = new ArrayList<Object>();
        public Sax2Dom parameterDOMBuilder;
        public int elementDepth;
        private Object[] parametersTable;

        public Block(ListenerElement listenerElement, int elementDepth) {
            this.listenerElement = listenerElement;
            this.elementDepth = elementDepth;
        }

        public boolean isContainer() {
            return this.listenerElement.getOnMethod() == null;
        }

        public void setParameter(int index, Object parameter) {
            while (this.parametersList.size() <= index) {
                this.parametersList.add(null);
            }
            this.parametersList.set(index, parameter);
            this.parametersTable = null;
        }

        public List<Object> getParametersList() {
            return this.parametersList;
        }

        public Object[] getParametersTable() {
            if (this.parametersTable == null) {
                if (this.parametersList.isEmpty()) {
                    this.parametersTable = ArrayUtils.EMPTY_OBJECT_ARRAY;
                }
                this.parametersTable = this.parametersList.toArray();
            }
            return this.parametersTable;
        }

        public void fireBeginEvent(Object listener, Object[] parameters) throws SAXException {
            this.fireEvent(this.listenerElement.getBeginMethod(), listener, parameters);
            this.beginSent = true;
        }

        public void fireEndEvent(Object listener, Object[] parameters) throws SAXException {
            this.fireEvent(this.listenerElement.getEndMethod(), listener, parameters);
        }

        public void fireOnEvent(Object listener, Object[] parameters) throws SAXException {
            this.fireEvent(this.listenerElement.getOnMethod(), listener, parameters);
        }

        private void fireEvent(Method eventMethod, Object listener, Object[] parameters) throws SAXException {
            int i;
            Object[] properParameters = parameters;
            Class<?>[] methodParameters = eventMethod.getParameterTypes();
            if (methodParameters.length > parameters.length) {
                properParameters = new Object[methodParameters.length];
                for (i = 0; i < methodParameters.length; ++i) {
                    properParameters[i] = i < parameters.length ? parameters[i] : null;
                }
            }
            for (i = 0; i < properParameters.length; ++i) {
                Class<?> methodParameter;
                Object parameter = properParameters[i];
                if (parameter != null || !(methodParameter = methodParameters[i]).isPrimitive()) continue;
                properParameters[i] = XMLUtils.defaultValue(methodParameter);
            }
            try {
                eventMethod.invoke(listener, properParameters);
            }
            catch (Exception e) {
                throw new SAXException("Failed to invoke event [" + eventMethod + "]", e);
            }
        }
    }
}

