/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructor
extends SafeConstructor {
    private final Map<String, Class<? extends Object>> typeTags;
    private final Map<Class<? extends Object>, TypeDescription> typeDefinitions;

    public Constructor() {
        this(Object.class);
    }

    public Constructor(Class<? extends Object> theRoot) {
        if (theRoot == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstructYamlObject());
        this.rootType = theRoot;
        this.typeTags = new HashMap<String, Class<? extends Object>>();
        this.typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
        this.yamlClassConstructors.put(NodeId.scalar, new ConstructScalar());
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMapping());
        this.yamlClassConstructors.put(NodeId.sequence, new ConstructSequence());
    }

    public Constructor(String theRoot) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(theRoot)));
    }

    private static final String check(String s) {
        if (s == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (s.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return s;
    }

    public TypeDescription addTypeDescription(TypeDescription definition) {
        if (definition == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        if (this.rootType == Object.class && definition.isRoot()) {
            this.rootType = definition.getType();
        }
        String tag = definition.getTag();
        this.typeTags.put(tag, definition.getType());
        return this.typeDefinitions.put(definition.getType(), definition);
    }

    protected Class<?> getClassForNode(Node node) {
        Class<? extends Object> classForTag = this.typeTags.get(node.getTag());
        if (classForTag == null) {
            Class<?> cl;
            if (node.getTag().length() < "tag:yaml.org,2002:".length()) {
                throw new YAMLException("Unknown tag: " + node.getTag());
            }
            String name = node.getTag().substring("tag:yaml.org,2002:".length());
            try {
                cl = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new YAMLException("Class not found: " + name);
            }
            this.typeTags.put(node.getTag(), cl);
            return cl;
        }
        return classForTag;
    }

    private class ConstructSequence
    implements Construct {
        private ConstructSequence() {
        }

        public Object construct(Node node) {
            int index;
            List<Object> argumentList;
            SequenceNode snode = (SequenceNode)node;
            if (List.class.isAssignableFrom(node.getType()) || node.getType().isArray()) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultList(snode.getValue().size());
                }
                return Constructor.this.constructSequence(snode);
            }
            LinkedList possibleConstructors = new LinkedList();
            for (java.lang.reflect.Constructor<?> constructor : node.getType().getConstructors()) {
                if (snode.getValue().size() != constructor.getParameterTypes().length) continue;
                possibleConstructors.add(constructor);
            }
            if (possibleConstructors.isEmpty()) {
                throw new YAMLException("No constructors with " + String.valueOf(snode.getValue().size()) + " arguments found for " + node.getType());
            }
            if (possibleConstructors.size() == 1) {
                argumentList = new LinkedList();
                java.lang.reflect.Constructor c = (java.lang.reflect.Constructor)possibleConstructors.get(0);
                index = 0;
                for (Node argumentNode : snode.getValue()) {
                    Class<?> type = c.getParameterTypes()[index];
                    argumentNode.setType(type);
                    Object argumentValue = Constructor.this.constructObject(argumentNode);
                    argumentList.add(argumentValue);
                    ++index;
                }
            } else {
                argumentList = Constructor.this.constructSequence(snode);
            }
            Class[] parameterTypes = new Class[argumentList.size()];
            index = 0;
            for (Object parameter : argumentList) {
                parameterTypes[index] = parameter.getClass();
                ++index;
            }
            try {
                Class<? extends Object> cl = node.getType();
                java.lang.reflect.Constructor<? extends Object> javaConstructor = cl.getConstructor(parameterTypes);
                Object[] initargs = argumentList.toArray();
                return javaConstructor.newInstance(initargs);
            }
            catch (Exception e) {
                throw new YAMLException(e);
            }
        }

        public void construct2ndStep(Node node, Object object) {
            SequenceNode snode = (SequenceNode)node;
            List list = (List)object;
            if (!List.class.isAssignableFrom(node.getType())) {
                throw new YAMLException("Immutable objects cannot be recursive.");
            }
            Constructor.this.constructSequenceStep2(snode, list);
        }
    }

    protected class ConstructScalar
    extends AbstractConstruct {
        protected ConstructScalar() {
        }

        public Object construct(Node nnode) {
            Object result;
            ScalarNode node = (ScalarNode)nnode;
            Class<? extends Object> type = node.getType();
            if (type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || Date.class.isAssignableFrom(type) || type == Character.class || type == BigInteger.class || Enum.class.isAssignableFrom(type) || "tag:yaml.org,2002:binary".equals(node.getTag())) {
                result = this.constructStandardJavaInstance(type, node);
            } else {
                Object argument;
                java.lang.reflect.Constructor<?>[] javaConstructors = type.getConstructors();
                int oneArgCount = 0;
                java.lang.reflect.Constructor<Object> javaConstructor = null;
                for (java.lang.reflect.Constructor<?> c : javaConstructors) {
                    if (c.getParameterTypes().length != 1) continue;
                    ++oneArgCount;
                    javaConstructor = c;
                }
                if (javaConstructor == null) {
                    throw new YAMLException("No single argument constructor found for " + type);
                }
                if (oneArgCount == 1) {
                    argument = this.constructStandardJavaInstance(javaConstructor.getParameterTypes()[0], node);
                } else {
                    argument = Constructor.this.constructScalar(node);
                    try {
                        javaConstructor = type.getConstructor(String.class);
                    }
                    catch (Exception e) {
                        throw new ConstructorException(null, null, "Can't construct a java object for scalar " + node.getTag() + "; No String constructor found. Exception=" + e.getMessage(), node.getStartMark(), e);
                    }
                }
                try {
                    result = javaConstructor.newInstance(argument);
                }
                catch (Exception e) {
                    throw new ConstructorException(null, null, "Can't construct a java object for scalar " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark(), e);
                }
            }
            return result;
        }

        private Object constructStandardJavaInstance(Class type, ScalarNode node) {
            Object result;
            if (type == String.class) {
                Construct stringConstructor = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:str");
                result = stringConstructor.construct(node);
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                Construct boolConstructor = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:bool");
                result = boolConstructor.construct(node);
            } else if (type == Character.class || type == Character.TYPE) {
                Construct charConstructor = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:str");
                String ch = (String)charConstructor.construct(node);
                if (ch.length() == 0) {
                    result = null;
                } else {
                    if (ch.length() != 1) {
                        throw new YAMLException("Invalid node Character: '" + ch + "'; length: " + ch.length());
                    }
                    result = new Character(ch.charAt(0));
                }
            } else if (Date.class.isAssignableFrom(type)) {
                Construct dateConstructor = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:timestamp");
                Date date = (Date)dateConstructor.construct(node);
                if (type == Date.class) {
                    result = date;
                } else {
                    try {
                        java.lang.reflect.Constructor constr = type.getConstructor(Long.TYPE);
                        result = constr.newInstance(date.getTime());
                    }
                    catch (Exception e) {
                        throw new YAMLException("Cannot construct: '" + type + "'");
                    }
                }
            } else if (type == Float.class || type == Double.class || type == Float.TYPE || type == Double.TYPE || type == BigDecimal.class) {
                Construct doubleConstructor = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:float");
                result = doubleConstructor.construct(node);
                if (type == Float.class || type == Float.TYPE) {
                    result = new Float((Double)result);
                } else if (type == BigDecimal.class) {
                    result = new BigDecimal((Double)result);
                }
            } else if (type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == BigInteger.class || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE) {
                Construct intConstructor = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:int");
                result = intConstructor.construct(node);
                result = type == Byte.class || type == Byte.TYPE ? (Number)new Byte(result.toString()) : (Number)(type == Short.class || type == Short.TYPE ? (Number)new Short(result.toString()) : (Number)(type == Integer.class || type == Integer.TYPE ? (Number)new Integer(result.toString()) : (Number)(type == Long.class || type == Long.TYPE ? new Long(result.toString()) : new BigInteger(result.toString()))));
            } else if (Enum.class.isAssignableFrom(type)) {
                String enumValueName = node.getValue();
                try {
                    result = Enum.valueOf(type, enumValueName);
                }
                catch (Exception ex) {
                    throw new YAMLException("Unable to find enum value '" + enumValueName + "' for enum class: " + type.getName());
                }
            } else {
                throw new YAMLException("Unsupported class: " + type);
            }
            return result;
        }
    }

    private class ConstructYamlObject
    extends AbstractConstruct {
        private ConstructYamlObject() {
        }

        public Object construct(Node node) {
            Object result = null;
            try {
                Class<?> cl = Constructor.this.getClassForNode(node);
                node.setType(cl);
                Construct constructor = (Construct)Constructor.this.yamlClassConstructors.get((Object)node.getNodeId());
                result = constructor.construct(node);
            }
            catch (Exception e) {
                throw new ConstructorException(null, null, "Can't construct a java object for " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark(), e);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructMapping
    implements Construct {
        private ConstructMapping() {
        }

        @Override
        public Object construct(Node node) {
            MappingNode mnode = (MappingNode)node;
            if (Map.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultMap();
                }
                return Constructor.this.constructMapping(mnode);
            }
            if (Set.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultSet();
                }
                return Constructor.this.constructSet(mnode);
            }
            if (node.isTwoStepsConstruction()) {
                return this.createEmptyJavaBean(mnode);
            }
            return this.constructJavaBean2ndStep(mnode, this.createEmptyJavaBean(mnode));
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            if (Map.class.isAssignableFrom(node.getType())) {
                Constructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
            } else if (Set.class.isAssignableFrom(node.getType())) {
                Constructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
            } else {
                this.constructJavaBean2ndStep((MappingNode)node, object);
            }
        }

        private Object createEmptyJavaBean(MappingNode node) {
            try {
                Class<? extends Object> type = node.getType();
                if (Modifier.isAbstract(type.getModifiers())) {
                    node.setType(Constructor.this.getClassForNode(node));
                }
                return node.getType().newInstance();
            }
            catch (InstantiationException e) {
                throw new YAMLException(e);
            }
            catch (IllegalAccessException e) {
                throw new YAMLException(e);
            }
        }

        private Object constructJavaBean2ndStep(MappingNode node, Object object) {
            Class<? extends Object> beanType = node.getType();
            List<NodeTuple> nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                if (!(tuple.getKeyNode() instanceof ScalarNode)) {
                    throw new YAMLException("Keys must be scalars but found: " + tuple.getKeyNode());
                }
                ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                Node valueNode = tuple.getValueNode();
                keyNode.setType(String.class);
                String key = (String)Constructor.this.constructObject(keyNode);
                boolean isArray = false;
                try {
                    Property property = this.getProperty(beanType, key);
                    valueNode.setType(property.getType());
                    TypeDescription memberDescription = (TypeDescription)Constructor.this.typeDefinitions.get(beanType);
                    if (memberDescription != null) {
                        switch (valueNode.getNodeId()) {
                            case sequence: {
                                SequenceNode snode = (SequenceNode)valueNode;
                                Class<? extends Object> memberType = memberDescription.getListPropertyType(key);
                                if (memberType != null) {
                                    snode.setListType(memberType);
                                    break;
                                }
                                if (!property.getType().isArray()) break;
                                isArray = true;
                                snode.setListType(property.getType().getComponentType());
                                break;
                            }
                            case mapping: {
                                MappingNode mnode = (MappingNode)valueNode;
                                Class<? extends Object> keyType = memberDescription.getMapKeyType(key);
                                if (keyType == null) break;
                                mnode.setKeyType(keyType);
                                mnode.setValueType(memberDescription.getMapValueType(key));
                            }
                        }
                    }
                    Object[] value = Constructor.this.constructObject(valueNode);
                    if (isArray) {
                        List list = (List)value;
                        value = list.toArray(this.createArray(property.getType()));
                    }
                    property.set(object, value);
                }
                catch (Exception e) {
                    throw new YAMLException("Cannot create property=" + key + " for JavaBean=" + object + "; " + e.getMessage(), e);
                }
            }
            return object;
        }

        private <T> T[] createArray(Class<T> type) {
            return (Object[])Array.newInstance(type.getComponentType(), 0);
        }

        private Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                if (!property.getName().equals(name)) continue;
                if (property.getWriteMethod() != null) {
                    return new MethodProperty(property);
                }
                throw new YAMLException("Property '" + name + "' on JavaBean: " + type.getName() + " does not have the write method");
            }
            for (Field field : type.getFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !field.getName().equals(name)) continue;
                return new FieldProperty(field);
            }
            throw new YAMLException("Unable to find property '" + name + "' on class: " + type.getName());
        }
    }
}

