/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tags;
import org.yaml.snakeyaml.representer.BaseRepresenter;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.util.Base64Coder;

class SafeRepresenter
extends BaseRepresenter {
    public static Pattern BINARY_PATTERN = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]");

    public SafeRepresenter() {
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(byte[].class, new RepresentByteArray());
        this.multiRepresenters.put(Number.class, new RepresentNumber());
        this.multiRepresenters.put(List.class, new RepresentList());
        this.multiRepresenters.put(Map.class, new RepresentMap());
        this.multiRepresenters.put(Set.class, new RepresentSet());
        this.multiRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.multiRepresenters.put(Date.class, new RepresentDate());
        this.multiRepresenters.put(Enum.class, new RepresentEnum());
    }

    protected boolean ignoreAliases(Object data) {
        Object[] array;
        if (data == null) {
            return true;
        }
        if (data instanceof Object[] && (array = (Object[])data).length == 0) {
            return true;
        }
        return data instanceof String || data instanceof Boolean || data instanceof Integer || data instanceof Long || data instanceof Float || data instanceof Double || data instanceof Enum;
    }

    private class RepresentByteArray
    implements Represent {
        private RepresentByteArray() {
        }

        public Node representData(Object data) {
            char[] binary = Base64Coder.encode((byte[])data);
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:binary", String.valueOf(binary), Character.valueOf('|'));
        }
    }

    private class RepresentEnum
    implements Represent {
        private RepresentEnum() {
        }

        public Node representData(Object data) {
            String tag = Tags.getGlobalTagForClass(data.getClass());
            return SafeRepresenter.this.representScalar(tag, data.toString());
        }
    }

    private class RepresentDate
    implements Represent {
        private RepresentDate() {
        }

        public Node representData(Object data) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.setTime((Date)data);
            int years = calendar.get(1);
            int months = calendar.get(2) + 1;
            int days = calendar.get(5);
            int hour24 = calendar.get(11);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            int millis = calendar.get(14);
            StringBuffer buffer = new StringBuffer(String.valueOf(years));
            buffer.append("-");
            if (months < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(months));
            buffer.append("-");
            if (days < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(days));
            buffer.append("T");
            if (hour24 < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(hour24));
            buffer.append(":");
            if (minutes < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(minutes));
            buffer.append(":");
            if (seconds < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(seconds));
            if (millis > 0) {
                if (millis < 10) {
                    buffer.append(".00");
                } else if (millis < 100) {
                    buffer.append(".0");
                } else {
                    buffer.append(".");
                }
                buffer.append(String.valueOf(millis));
            }
            buffer.append("Z");
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:timestamp", buffer.toString(), null);
        }
    }

    private class RepresentSet
    implements Represent {
        private RepresentSet() {
        }

        public Node representData(Object data) {
            LinkedHashMap value = new LinkedHashMap();
            Set set = (Set)data;
            for (Object key : set) {
                value.put(key, null);
            }
            return SafeRepresenter.this.representMapping("tag:yaml.org,2002:set", value, null);
        }
    }

    private class RepresentMap
    implements Represent {
        private RepresentMap() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representMapping("tag:yaml.org,2002:map", (Map)data, null);
        }
    }

    private class RepresentArray
    implements Represent {
        private RepresentArray() {
        }

        public Node representData(Object data) {
            Object[] array = (Object[])data;
            List<Object> list = Arrays.asList(array);
            return SafeRepresenter.this.representSequence("tag:yaml.org,2002:seq", list, null);
        }
    }

    private class RepresentList
    implements Represent {
        private RepresentList() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representSequence("tag:yaml.org,2002:seq", (List)data, null);
        }
    }

    private class RepresentNumber
    implements Represent {
        private RepresentNumber() {
        }

        public Node representData(Object data) {
            String value;
            String tag;
            if (data instanceof Byte || data instanceof Short || data instanceof Integer || data instanceof Long || data instanceof BigInteger) {
                tag = "tag:yaml.org,2002:int";
                value = data.toString();
            } else {
                Number number = (Number)data;
                tag = "tag:yaml.org,2002:float";
                value = number.equals(Double.NaN) ? ".NaN" : (number.equals(Double.POSITIVE_INFINITY) ? ".inf" : (number.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : number.toString()));
            }
            return SafeRepresenter.this.representScalar(tag, value);
        }
    }

    private class RepresentBoolean
    implements Represent {
        private RepresentBoolean() {
        }

        public Node representData(Object data) {
            String value = Boolean.TRUE.equals(data) ? "true" : "false";
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:bool", value);
        }
    }

    private class RepresentString
    implements Represent {
        private RepresentString() {
        }

        public Node representData(Object data) {
            String tag = "tag:yaml.org,2002:str";
            Character style = null;
            String value = data.toString();
            if (BINARY_PATTERN.matcher(value).find()) {
                tag = "tag:yaml.org,2002:binary";
                char[] binary = Base64Coder.encode(value.getBytes());
                value = String.valueOf(binary);
                style = Character.valueOf('|');
            }
            return SafeRepresenter.this.representScalar(tag, value, style);
        }
    }

    private class RepresentNull
    implements Represent {
        private RepresentNull() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:null", "null");
        }
    }
}

