/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.util.ArrayList;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.core.DefaultHttpLogFormatter;

@API(status=API.Status.EXPERIMENTAL)
public final class CurlHttpLogFormatter
implements HttpLogFormatter {
    private final HttpLogFormatter fallback;

    public CurlHttpLogFormatter() {
        this(new DefaultHttpLogFormatter());
    }

    public CurlHttpLogFormatter(HttpLogFormatter fallback) {
        this.fallback = fallback;
    }

    public String format(Precorrelation precorrelation, HttpRequest request) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(precorrelation.getId());
        command.add("curl");
        command.add("-v");
        command.add("-X");
        command.add(request.getMethod());
        command.add(CurlHttpLogFormatter.quote(request.getRequestUri()));
        request.getHeaders().forEach((header, values) -> values.forEach(value -> {
            command.add("-H");
            command.add(CurlHttpLogFormatter.quote(header + ": " + value));
        }));
        String body = request.getBodyAsString();
        if (!body.isEmpty()) {
            command.add("--data-binary");
            command.add(CurlHttpLogFormatter.quote(body));
        }
        return String.join((CharSequence)" ", command);
    }

    private static String quote(String s) {
        return "'" + CurlHttpLogFormatter.escape(s) + "'";
    }

    private static String escape(String s) {
        return s.replace("'", "\\'");
    }

    public String format(Correlation correlation, HttpResponse response) throws IOException {
        return this.fallback.format(correlation, response);
    }
}

