/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.RawPullCommand;
import org.zanata.maven.AbstractPushPullMojo;

public abstract class AbstractPullMojo
extends AbstractPushPullMojo<PullOptions>
implements PullOptions {
    @Deprecated
    private String pullSrc;
    private boolean createSkeletons;
    private boolean includeFuzzy = false;
    private boolean purgeCache;
    private boolean useCache;
    private String pullType;
    private boolean encodeTabs = true;
    private boolean continueAfterError = false;
    private int minDocPercent = 0;

    public AbstractPullMojo() {
        Preconditions.checkArgument((this.minDocPercent >= 0 && this.minDocPercent <= 100 ? 1 : 0) != 0, (Object)"zanata.minDocPercent should be an integer from 0 to 100");
    }

    @Override
    public PushPullCommand<PullOptions> initCommand() {
        if ("file".equalsIgnoreCase(this.getProjectType())) {
            return new RawPullCommand((PullOptions)this);
        }
        return new PullCommand((PullOptions)this);
    }

    public boolean getCreateSkeletons() {
        return this.createSkeletons;
    }

    public boolean getEncodeTabs() {
        return this.encodeTabs;
    }

    public boolean getIncludeFuzzy() {
        return this.includeFuzzy;
    }

    public boolean getPurgeCache() {
        return this.purgeCache;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Injected by Maven")
    public PushPullType getPullType() {
        if (this.pullSrc != null) {
            return Boolean.parseBoolean(this.pullSrc) ? PushPullType.Both : PushPullType.Trans;
        }
        return PushPullType.fromString((String)this.pullType);
    }

    public String getCommandName() {
        return "pull";
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    public int getMinDocPercent() {
        return this.minDocPercent;
    }
}

