/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.maven.AbstractPushPullMojo;

public abstract class AbstractPushMojo
extends AbstractPushPullMojo<PushOptions>
implements PushOptions {
    private String sourceLang = "en-US";
    @Deprecated
    private String pushTrans;
    private String pushType = "source";
    private boolean copyTrans;
    private String merge = "auto";
    private boolean defaultExcludes = true;
    private int maxChunkSize = 0x100000;
    private String[] fileTypes = "txt,dtd,odt,fodt,odp,fodp,ods,fods,odg,fodg,odf,odb".split(",");
    private boolean caseSensitive = true;
    private boolean excludeLocaleFilenames = true;
    private String validate = "content";
    private boolean myTrans = false;

    @Override
    public PushPullCommand<PushOptions> initCommand() {
        if ("file".equalsIgnoreCase(this.getProjectType())) {
            return new RawPushCommand((PushOptions)this);
        }
        return new PushCommand((PushOptions)this);
    }

    public String getSourceLang() {
        return this.sourceLang;
    }

    public PushPullType getPushType() {
        if (this.pushTrans != null) {
            return Boolean.parseBoolean(this.pushTrans) ? PushPullType.Both : PushPullType.Source;
        }
        return PushPullType.fromString((String)this.pushType);
    }

    public boolean getCopyTrans() {
        return this.copyTrans;
    }

    public String getMergeType() {
        return this.merge;
    }

    public boolean getDefaultExcludes() {
        return this.defaultExcludes;
    }

    public int getChunkSize() {
        return this.maxChunkSize;
    }

    public ImmutableList<String> getFileTypes() {
        return ImmutableList.copyOf((Object[])this.fileTypes);
    }

    public String getCommandName() {
        return "push";
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean getExcludeLocaleFilenames() {
        return this.excludeLocaleFilenames;
    }

    @Nonnull
    public String getValidate() {
        return this.validate;
    }

    public boolean isMyTrans() {
        return this.myTrans;
    }
}

