/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import org.zanata.rest.client.CacheResponseFilter;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.CopyTransStatus;
import org.zanata.rest.service.CopyTransResource;

public class CopyTransClient
implements CopyTransResource {
    private final RestClientFactory factory;
    private final URI baseUri;

    CopyTransClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public CopyTransStatus startCopyTrans(String projectSlug, String iterationSlug, String docId) {
        Client client = this.factory.getClient();
        CacheResponseFilter filter = new CacheResponseFilter();
        client.addFilter((ClientFilter)filter);
        this.webResource(client, projectSlug, iterationSlug, docId).post();
        client.removeFilter((ClientFilter)filter);
        return filter.getEntity(CopyTransStatus.class);
    }

    private WebResource webResource(Client client, String projectSlug, String iterationSlug, String docId) {
        return client.resource(this.baseUri).path("/copytrans").path("/proj").path(projectSlug).path("iter").path(iterationSlug).path("doc").path(docId);
    }

    public CopyTransStatus getCopyTransStatus(String projectSlug, String iterationSlug, String docId) {
        return (CopyTransStatus)this.webResource(this.factory.getClient(), projectSlug, iterationSlug, docId).get(CopyTransStatus.class);
    }
}

