/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.zanata.common.DocumentType;
import org.zanata.rest.DocumentFileUploadForm;
import org.zanata.rest.client.CacheResponseFilter;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ChunkUploadResponse;

public class FileResourceClient {
    private final RestClientFactory factory;
    private final URI baseUri;

    FileResourceClient(RestClientFactory restClientFactory) {
        this.factory = restClientFactory;
        this.baseUri = restClientFactory.getBaseUri();
    }

    public List<DocumentType> acceptedFileTypes() {
        List types = (List)this.factory.getClient().resource(this.baseUri).path("/file/accepted_document_types").get((GenericType)new GenericType<List<DocumentType>>(){});
        return types;
    }

    public ChunkUploadResponse uploadSourceFile(String projectSlug, String iterationSlug, String docId, DocumentFileUploadForm documentFileUploadForm) {
        CacheResponseFilter filter = new CacheResponseFilter();
        Client client = this.factory.getClient();
        client.addFilter((ClientFilter)filter);
        WebResource.Builder builder = client.resource(this.baseUri).path("file").path("source").path(projectSlug).path(iterationSlug).queryParam("docId", docId).type(MediaType.MULTIPART_FORM_DATA_TYPE);
        FormDataMultiPart form = this.prepareFormDataMultiPart(documentFileUploadForm);
        builder.post((Object)form);
        ChunkUploadResponse chunkUploadResponse = filter.getEntity(ChunkUploadResponse.class);
        client.removeFilter((ClientFilter)filter);
        return chunkUploadResponse;
    }

    private FormDataMultiPart prepareFormDataMultiPart(DocumentFileUploadForm documentFileUploadForm) {
        FormDataMultiPart form = new FormDataMultiPart().field("file", (Object)documentFileUploadForm.getFileStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        FileResourceClient.addBodyPartIfPresent(form, "adapterParams", documentFileUploadForm.getAdapterParams());
        FileResourceClient.addBodyPartIfPresent(form, "type", documentFileUploadForm.getFileType());
        FileResourceClient.addBodyPartIfPresent(form, "first", documentFileUploadForm.getFirst());
        FileResourceClient.addBodyPartIfPresent(form, "hash", documentFileUploadForm.getHash());
        FileResourceClient.addBodyPartIfPresent(form, "last", documentFileUploadForm.getLast());
        FileResourceClient.addBodyPartIfPresent(form, "size", documentFileUploadForm.getSize());
        FileResourceClient.addBodyPartIfPresent(form, "uploadId", documentFileUploadForm.getUploadId());
        return form;
    }

    public ChunkUploadResponse uploadTranslationFile(String projectSlug, String iterationSlug, String locale, String docId, String mergeType, DocumentFileUploadForm documentFileUploadForm) {
        CacheResponseFilter filter = new CacheResponseFilter();
        Client client = this.factory.getClient();
        client.addFilter((ClientFilter)filter);
        WebResource.Builder builder = client.resource(this.baseUri).path("/file").path("translation").path(projectSlug).path(iterationSlug).path(locale).queryParam("docId", docId).queryParam("merge", mergeType).type(MediaType.MULTIPART_FORM_DATA_TYPE);
        FormDataMultiPart form = this.prepareFormDataMultiPart(documentFileUploadForm);
        builder.post((Object)form);
        ChunkUploadResponse chunkUploadResponse = filter.getEntity(ChunkUploadResponse.class);
        client.removeFilter((ClientFilter)filter);
        return chunkUploadResponse;
    }

    public ClientResponse downloadSourceFile(String projectSlug, String iterationSlug, String fileType, String docId) {
        WebResource webResource = this.factory.getClient().resource(this.baseUri).path("/file").path("source").path(projectSlug).path(iterationSlug).path(fileType);
        return (ClientResponse)webResource.queryParam("docId", docId).get(ClientResponse.class);
    }

    public ClientResponse downloadTranslationFile(String projectSlug, String iterationSlug, String locale, String fileExtension, String docId) {
        WebResource webResource = this.factory.getClient().resource(this.baseUri).path("/file").path("translation").path(projectSlug).path(iterationSlug).path(locale).path(fileExtension);
        return (ClientResponse)webResource.queryParam("docId", docId).get(ClientResponse.class);
    }

    private static <T> FormDataMultiPart addBodyPartIfPresent(FormDataMultiPart form, String field, T value) {
        if (value != null) {
            return form.field(field, value.toString());
        }
        return form;
    }
}

