/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.GlossaryEntry;

public class GlossaryClient {
    private final RestClientFactory factory;
    private final URI baseUri;

    GlossaryClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public void post(List<GlossaryEntry> glossaryEntries) {
        Type genericType = new GenericType<List<GlossaryEntry>>(){}.getType();
        GenericEntity entity = new GenericEntity(glossaryEntries, genericType);
        this.webResource().path("entries").type(MediaType.APPLICATION_XML_TYPE).post((Object)entity);
    }

    public void delete(String id) {
        this.webResource().path("entries/" + id).delete();
    }

    public void deleteAll() {
        this.webResource().delete();
    }

    private WebResource webResource() {
        return this.factory.getClient().resource(this.baseUri).path("/glossary");
    }
}

