/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ProjectIteration;

public class ProjectIterationClient {
    private final RestClientFactory factory;
    private final String projectSlug;
    private final String versionSlug;
    private URI baseUri;

    ProjectIterationClient(RestClientFactory factory, String projectSlug, String versionSlug) {
        this.factory = factory;
        this.projectSlug = projectSlug;
        this.versionSlug = versionSlug;
        this.baseUri = factory.getBaseUri();
    }

    public ProjectIteration get() {
        return (ProjectIteration)this.webResource().get(ProjectIteration.class);
    }

    private WebResource webResource() {
        return this.factory.getClient().resource(this.baseUri).path("projects").path("p").path(this.projectSlug).path("iterations").path("i").path(this.versionSlug);
    }

    public void put(ProjectIteration projectVersion) {
        this.webResource().put((Object)projectVersion);
    }

    public String sampleConfiguration() {
        return (String)this.webResource().path("config").get(String.class);
    }
}

