/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(RedirectFilter.class);

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        ClientHandler ch = this.getNext();
        ClientResponse resp = ch.handle(clientRequest);
        if (resp.getClientResponseStatus().getFamily() != Response.Status.Family.REDIRECTION) {
            return resp;
        }
        String method = clientRequest.getMethod();
        if ("HEAD".equals(method) || "GET".equals(method)) {
            log.debug("Server returns redirection status: {}. Try to follow it", (Object)resp.getClientResponseStatus());
            URI redirectTarget = resp.getLocation();
            if (redirectTarget != null) {
                clientRequest.setURI(redirectTarget);
            }
            return ch.handle(clientRequest);
        }
        throw new IllegalStateException("Received status " + resp.getClientResponseStatus() + ". Check your server URL (e.g. used http instead of https)");
    }
}

