/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.process.SystemProcess;

public abstract class AbstractProcess
implements SystemProcess {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getDescription() + ")";
    }

    protected abstract String getDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        try {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractProcess.this.waitFor();
                    }
                    catch (InterruptedException e) {
                        AbstractProcess.this.log.debug("Interrupted waiting for {}", (Object)AbstractProcess.this.getDescription());
                    }
                }
            };
            service.submit(task).get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error occured while waiting for process to finish:", e.getCause());
        }
        catch (TimeoutException e) {
            this.log.debug("{} is running too long", (Object)this.getDescription());
            boolean bl = false;
            return bl;
        }
        finally {
            service.shutdownNow();
        }
        return true;
    }

    @Override
    public AbstractProcess destroyGracefully() throws IOException, InterruptedException {
        this.destroy(false);
        return this;
    }

    @Override
    public AbstractProcess destroyForcefully() throws IOException, InterruptedException {
        this.destroy(true);
        return this;
    }

    public abstract void destroy(boolean var1) throws IOException, InterruptedException;
}

