/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.process.JavaProcess;
import org.zeroturnaround.process.ReflectionUtil;

public class Java8Process
extends JavaProcess {
    private static final Logger log = LoggerFactory.getLogger(Java8Process.class);
    private static final Method METHOD_DESTROY_FORCIBLY = Java8Process.getMethod("destroyForcibly", new Class[0]);
    private static final Method METHOD_IS_ALIVE = Java8Process.getMethod("isAlive", new Class[0]);
    private static final Method METHOD_WAIT_FOR_TIMEOUT = Java8Process.getMethod("waitFor", Long.TYPE, TimeUnit.class);

    public static boolean isSupported() {
        return METHOD_DESTROY_FORCIBLY != null;
    }

    public Java8Process(Process process) {
        super(process);
    }

    @Override
    protected boolean canDestroy(boolean forceful) {
        if (forceful) {
            return true;
        }
        return super.canDestroy(forceful);
    }

    @Override
    protected void invokeDestroy(boolean forceful) {
        if (forceful) {
            log.debug("Invoking destroyForcibly() on {}", (Object)this.process);
            this.invokeDestroyForcibly();
        } else {
            super.invokeDestroy(forceful);
        }
    }

    public Process invokeDestroyForcibly() {
        return (Process)ReflectionUtil.invokeWithoutDeclaredExceptions(METHOD_DESTROY_FORCIBLY, this.process, new Object[0]);
    }

    @Override
    public boolean isAlive() {
        return (Boolean)ReflectionUtil.invokeWithoutDeclaredExceptions(METHOD_IS_ALIVE, this.process, new Object[0]);
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return (Boolean)ReflectionUtil.invokeWithInterruptedException(METHOD_WAIT_FOR_TIMEOUT, this.process, new Object[]{timeout, unit});
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) {
        return ReflectionUtil.getMethodOrNull(Process.class, name, parameterTypes);
    }
}

