/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.HashSet;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.TypeConverter;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ext.Selectable;

public class SelectedItemConverter
implements TypeConverter,
Serializable {
    private static final long serialVersionUID = 200808191439L;
    private static Boolean _onSelectWhenLoad;

    public Object coerceToUi(Object val, Component comp) {
        Listbox lbx = (Listbox)comp;
        if (val != null) {
            ListModel xmodel = lbx.getModel();
            if (xmodel instanceof BindingListModel) {
                BindingListModel model = (BindingListModel)xmodel;
                int index = model.indexOf(val);
                if (index >= 0) {
                    Listitem item = lbx.getItemAtIndex(index);
                    if (SelectedItemConverter.isOnSelectWhenLoad()) {
                        int selIndex = lbx.getSelectedIndex();
                        if (item != null && selIndex != index) {
                            HashSet<Listitem> items = new HashSet<Listitem>();
                            items.add(item);
                            Executions.getCurrent().setAttribute("zkoss.zkplus.databind.ON_SELECT" + lbx.getUuid(), (Object)Boolean.TRUE);
                            Events.postEvent((Event)new SelectEvent("onSelect", (Component)lbx, items, (Component)item));
                        }
                    }
                    if (model instanceof Selectable) {
                        ((Selectable)model).addToSelection(val);
                        return TypeConverter.IGNORE;
                    }
                    return item;
                }
            } else if (xmodel == null) {
                for (Listitem li : lbx.getItems()) {
                    if (!val.equals(li.getValue())) continue;
                    return li;
                }
            } else {
                throw new UiException("model of the databind listbox " + lbx + " must be an instanceof of org.zkoss.zkplus.databind.BindingListModel." + xmodel);
            }
        }
        return null;
    }

    static boolean isOnSelectWhenLoad() {
        if (_onSelectWhenLoad == null) {
            String str = Library.getProperty((String)"org.zkoss.zkplus.databind.onSelectWhenLoad", (String)"false");
            _onSelectWhenLoad = "true".equals(str);
        }
        return _onSelectWhenLoad;
    }

    public Object coerceToBean(Object val, Component comp) {
        Listbox lbx = (Listbox)comp;
        if (Executions.getCurrent().getAttribute("zkoss.zkplus.databind.ON_SELECT" + lbx.getUuid()) != null) {
            Executions.getCurrent().removeAttribute("zkoss.zkplus.databind.ON_SELECT" + lbx.getUuid());
            return TypeConverter.IGNORE;
        }
        if (val != null) {
            ListModel model = lbx.getModel();
            return model != null ? model.getElementAt(((Listitem)val).getIndex()) : ((Listitem)val).getValue();
        }
        return null;
    }
}

