/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Detail;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.Rows;
import org.zkoss.zul.impl.LoadStatus;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row
extends XulElement {
    private static final long serialVersionUID = 20091111L;
    private transient Object _value;
    private String _align;
    private String _valign;
    private String _spans;
    private boolean _nowrap;
    private boolean _loaded;
    private transient Detail _detail;
    private transient int _index = -1;

    public Detail getDetailChild() {
        return this._detail;
    }

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public boolean isNowrap() {
        return this._nowrap;
    }

    public void setNowrap(boolean nowrap) {
        if (this._nowrap != nowrap) {
            this._nowrap = nowrap;
            this.smartUpdate("nowrap", this._nowrap);
        }
    }

    public String getValign() {
        return this._valign;
    }

    public void setValign(String valign) {
        if (!Objects.equals((Object)this._valign, (Object)valign)) {
            this._valign = valign;
            this.smartUpdate("valign", this._valign);
        }
    }

    public boolean setVisible(boolean visible) {
        Group g;
        Rows rows;
        if (this.isVisible() != visible && (rows = (Rows)this.getParent()) != null && ((g = rows.getGroup(this.getIndex())) == null || g.isOpen())) {
            rows.addVisibleItemCount(visible ? 1 : -1);
        }
        return super.setVisible(visible);
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        this._value = value;
    }

    public String getSpans() {
        return this._spans;
    }

    public void setSpans(String spans) throws WrongValueException {
        if (!Objects.equals((Object)spans, (Object)this._spans)) {
            this._spans = spans;
            this.smartUpdate("spans", spans);
        }
    }

    void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Grid grid = this.getGrid();
            if (grid != null && grid.getModel() != null) {
                this.smartUpdate("_loaded", this._loaded);
            }
        }
    }

    boolean isLoaded() {
        return this._loaded;
    }

    public int getIndex() {
        return this._index;
    }

    void setIndexDirectly(int index) {
        this._index = index;
    }

    public String getZclass() {
        return this._zclass == null ? "z-row" : this._zclass;
    }

    public Group getGroup() {
        Rows rows = (Rows)this.getParent();
        return rows != null ? rows.getGroup(this.getIndex()) : null;
    }

    public void setWidth(String width) {
    }

    public void setHflex(String flex) {
    }

    public String getSclass() {
        String sclass = super.getSclass();
        if (sclass != null) {
            return sclass;
        }
        Grid grid = this.getGrid();
        return grid != null ? grid.getSclass() : sclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "align", this._align);
        this.render(renderer, "valign", this._valign);
        this.render(renderer, "nowrap", this._nowrap);
        this.render(renderer, "spans", this._spans);
        this.render(renderer, "_loaded", this._loaded);
        if (this._index >= 0) {
            renderer.render("_index", this._index);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Rows)) {
            throw new UiException("Unsupported parent for row: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof Detail && this._detail != null && this._detail != newChild) {
            throw new UiException("Only one detail is allowed: " + (Object)((Object)this));
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Detail) {
            Component component = refChild = this.getChildren().isEmpty() ? null : (Component)this.getChildren().get(0);
            if (super.insertBefore(newChild, refChild)) {
                this._detail = (Detail)newChild;
                return true;
            }
            return false;
        }
        if (refChild != null && refChild == this._detail) {
            refChild = this.getChildren().size() <= 1 ? null : (Component)this.getChildren().get(1);
        }
        return super.insertBefore(newChild, refChild);
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._detail == child) {
            this._detail = null;
        }
    }

    @Override
    public Object clone() {
        Row clone = (Row)((Object)super.clone());
        if (this._detail != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        for (Object child : this.getChildren()) {
            if (!(child instanceof Detail)) continue;
            this._detail = (Detail)((Object)child);
            break;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._value instanceof Serializable) {
            s.writeBoolean(true);
            s.writeObject(this._value);
        } else {
            s.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (s.readBoolean()) {
            this._value = s.readObject();
        }
        this.afterUnmarshal();
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements LoadStatus {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Row.this);
        }

        public boolean isLoaded() {
            return Row.this.isLoaded();
        }

        public void setLoaded(boolean loaded) {
            Row.this.setLoaded(loaded);
        }

        public void setIndex(int index) {
            Row.this.setIndexDirectly(index);
        }
    }
}

