/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import junitparams.internal.Utils;
import junitparams.naming.TestCaseNamingStrategy;
import org.junit.runner.Description;

class ParametrizedDescription {
    private TestCaseNamingStrategy namingStrategy;
    private String testClassName;
    private String methodName;

    ParametrizedDescription(TestCaseNamingStrategy namingStrategy, String testClassName, String methodName) {
        this.namingStrategy = namingStrategy;
        this.testClassName = testClassName;
        this.methodName = methodName;
    }

    Description parametrizedDescription(Object[] params) {
        Description parametrised = Description.createSuiteDescription((String)this.methodName, (Annotation[])new Annotation[0]);
        for (int i = 0; i < params.length; ++i) {
            Object paramSet = params[i];
            String name = this.namingStrategy.getTestCaseName(i, paramSet);
            String uniqueMethodId = Utils.uniqueMethodId(i, paramSet, this.methodName);
            parametrised.addChild(Description.createTestDescription((String)this.testClassName, (String)name, (Serializable)((Object)uniqueMethodId)));
        }
        return parametrised;
    }
}

