/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class TravisBuildServerData
extends BuildServerDataProvider {
    TravisBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(@Nonnull Map<String, String> env) {
        return env.containsKey("TRAVIS");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = (String)this.env.get("TRAVIS_BUILD_NUMBER");
        String uniqueBuildNumber = (String)this.env.get("TRAVIS_BUILD_ID");
        this.put(properties, "build.number", buildNumber == null ? "" : buildNumber);
        this.put(properties, "build.number.unique", uniqueBuildNumber == null ? "" : uniqueBuildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = (String)this.env.get("TRAVIS_BRANCH");
        this.log.info("Using environment variable based branch name. TRAVIS_BRANCH = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

