/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import nu.studer.java.util.OrderedProperties;
import org.sonatype.plexus.build.incremental.BuildContext;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.log.LoggerBridge;

public class PropertiesFileGenerator {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES});
    private LoggerBridge log;
    private BuildContext buildContext;
    private String format;
    private String prefixDot;
    private String projectName;

    public PropertiesFileGenerator(LoggerBridge log, BuildContext buildContext, String format, String prefixDot, String projectName) {
        this.log = log;
        this.buildContext = buildContext;
        this.format = format;
        this.prefixDot = prefixDot;
        this.projectName = projectName;
    }

    public void maybeGeneratePropertiesFile(@Nonnull Properties localProperties, File base, String propertiesFilename, Charset sourceCharset) throws GitCommitIdExecutionException {
        block23: {
            try {
                File gitPropsFile = PropertiesFileGenerator.craftPropertiesOutputFile(base, propertiesFilename);
                boolean isJsonFormat = "json".equalsIgnoreCase(this.format);
                boolean shouldGenerate = true;
                if (gitPropsFile.exists()) {
                    try {
                        Properties persistedProperties;
                        if (isJsonFormat) {
                            this.log.info("Reading existing json file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                            persistedProperties = this.readJsonProperties(gitPropsFile, sourceCharset);
                        } else {
                            this.log.info("Reading existing properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                            persistedProperties = this.readProperties(gitPropsFile, sourceCharset);
                        }
                        Properties propertiesCopy = (Properties)localProperties.clone();
                        String buildTimeProperty = this.prefixDot + "build.time";
                        propertiesCopy.remove(buildTimeProperty);
                        persistedProperties.remove(buildTimeProperty);
                        shouldGenerate = !propertiesCopy.equals(persistedProperties);
                    }
                    catch (CannotReadFileException ex) {
                        this.log.info("Cannot read properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                        shouldGenerate = true;
                    }
                }
                if (shouldGenerate) {
                    block22: {
                        Files.createDirectories(gitPropsFile.getParentFile().toPath(), new FileAttribute[0]);
                        try (FileOutputStream outputStream = new FileOutputStream(gitPropsFile);){
                            OrderedProperties sortedLocalProperties = new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).withOrdering(Comparator.nullsLast(Comparator.naturalOrder())).build();
                            localProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> sortedLocalProperties.setProperty((String)key, (String)value)));
                            if (isJsonFormat) {
                                try (OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, sourceCharset);){
                                    this.log.info("Writing json file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                                    MAPPER.writerWithDefaultPrettyPrinter().writeValue((Writer)outputWriter, (Object)sortedLocalProperties);
                                    break block22;
                                }
                            }
                            this.log.info("Writing properties file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                            sortedLocalProperties.store((OutputStream)outputStream, "Generated by Git-Commit-Id-Plugin");
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                        }
                    }
                    if (this.buildContext != null) {
                        this.buildContext.refresh(gitPropsFile);
                    }
                    break block23;
                }
                this.log.info("Properties file [{}] is up-to-date (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
            }
            catch (IOException e) {
                throw new GitCommitIdExecutionException(e);
            }
        }
    }

    public static File craftPropertiesOutputFile(File base, String propertiesFilename) {
        File returnPath = new File(base, propertiesFilename);
        File currentPropertiesFilepath = new File(propertiesFilename);
        if (currentPropertiesFilepath.isAbsolute()) {
            returnPath = currentPropertiesFilepath;
        }
        return returnPath;
    }

    private Properties readJsonProperties(@Nonnull File jsonFile, Charset sourceCharset) throws CannotReadFileException {
        HashMap propertiesMap;
        try {
            FileInputStream fis = new FileInputStream(jsonFile);
            Object object = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, sourceCharset);){
                TypeReference<HashMap<String, Object>> mapTypeRef = new TypeReference<HashMap<String, Object>>(){};
                propertiesMap = (HashMap)MAPPER.readValue((Reader)inputStreamReader, (TypeReference)mapTypeRef);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                PropertiesFileGenerator.$closeResource((Throwable)object, fis);
            }
        }
        catch (Exception ex) {
            throw new CannotReadFileException(ex);
        }
        Properties retVal = new Properties();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            retVal.setProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return retVal;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Properties readProperties(@Nonnull File propertiesFile, Charset sourceCharset) throws CannotReadFileException {
        try {
            Throwable throwable = null;
            try (FileInputStream fis = new FileInputStream(propertiesFile);){
                Properties properties;
                InputStreamReader reader = new InputStreamReader((InputStream)fis, sourceCharset);
                Throwable throwable2 = null;
                try {
                    Properties retVal = new Properties();
                    retVal.load(reader);
                    properties = retVal;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            PropertiesFileGenerator.$closeResource(throwable2, reader);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                PropertiesFileGenerator.$closeResource(throwable2, reader);
                return properties;
            }
        }
        catch (Exception ex) {
            throw new CannotReadFileException(ex);
        }
    }

    static class CannotReadFileException
    extends Exception {
        private static final long serialVersionUID = -6290782570018307756L;

        CannotReadFileException(Throwable cause) {
            super(cause);
        }
    }
}

