/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.io.IOException;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import pl.tkowalcz.tjahzi.LogBufferMessageHandler;
import pl.tkowalcz.tjahzi.OutputBuffer;
import pl.tkowalcz.tjahzi.TimeCappedBatchingStrategy;
import pl.tkowalcz.tjahzi.http.NettyHttpClient;

public class LogBufferAgent
implements Agent {
    public static final int MAX_MESSAGES_TO_RETRIEVE = 100;
    private final ManyToOneRingBuffer logBuffer;
    private final NettyHttpClient httpClient;
    private final OutputBuffer outputBuffer;
    private final LogBufferMessageHandler messageHandler;
    private final TimeCappedBatchingStrategy batchStrategy;

    public LogBufferAgent(TimeCappedBatchingStrategy batchStrategy, ManyToOneRingBuffer logBuffer, OutputBuffer outputBuffer, NettyHttpClient httpClient, LogBufferMessageHandler messageHandler) {
        this.batchStrategy = batchStrategy;
        this.logBuffer = logBuffer;
        this.httpClient = httpClient;
        this.messageHandler = messageHandler;
        this.outputBuffer = outputBuffer;
    }

    private int doWork(boolean isTerminating) throws IOException {
        int workDone = this.logBuffer.read((MessageHandler)this.messageHandler, 100);
        if (isTerminating || this.batchStrategy.shouldProceed()) {
            try {
                this.httpClient.log(this.outputBuffer);
            }
            finally {
                this.outputBuffer.clear();
            }
        }
        return workDone;
    }

    public int doWork() throws IOException {
        return this.doWork(false);
    }

    public void onClose() {
        this.batchStrategy.initShutdown();
        int workDone = Integer.MAX_VALUE;
        do {
            try {
                workDone = this.doWork(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (workDone != 0 && this.batchStrategy.shouldContinueShutdown());
    }

    public String roleName() {
        return "ReadingLogBufferAndSendingHttp";
    }
}

