/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.util.function.Consumer;
import pl.tkowalcz.tjahzi.http.ExponentialBackoffStrategy;
import pl.tkowalcz.tjahzi.http.Retry;

class BlockingRetry
implements Retry {
    private final Consumer<BlockingRetry> operation;
    private final Runnable failureAction;
    private final ExponentialBackoffStrategy strategy;
    private int retries;

    BlockingRetry(Consumer<BlockingRetry> operation, Runnable failureAction, ExponentialBackoffStrategy strategy, int retries) {
        this.operation = operation;
        this.failureAction = failureAction;
        this.strategy = strategy;
        this.retries = retries;
    }

    BlockingRetry(Consumer<BlockingRetry> operation, Runnable failureAction, int retries) {
        this(operation, failureAction, ExponentialBackoffStrategy.withDefault(), retries);
    }

    @Override
    public void retry() {
        if (this.retries > 0) {
            --this.retries;
            try {
                Thread.sleep(this.strategy.getAsLong(), 0);
            }
            catch (InterruptedException ignore) {
                return;
            }
            this.operation.accept(this);
        } else {
            this.failureAction.run();
        }
    }
}

