/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import java.io.Closeable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import pl.tkowalcz.tjahzi.http.BlockingRetry;
import pl.tkowalcz.tjahzi.http.BootstrapUtil;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.EventLoopGroupRetry;
import pl.tkowalcz.tjahzi.http.Retry;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class HttpConnection
implements Closeable {
    private final ClientConfiguration clientConfiguration;
    private final MonitoringModule monitoringModule;
    private final NioEventLoopGroup group;
    private volatile ChannelFuture lokiConnection;

    public HttpConnection(ClientConfiguration clientConfiguration, MonitoringModule monitoringModule) {
        this.clientConfiguration = clientConfiguration;
        this.monitoringModule = monitoringModule;
        ThreadGroup threadGroup = new ThreadGroup("Tjahzi Loki client");
        ThreadFactory threadFactory = r -> new Thread(threadGroup, r, "tjahzi-worker");
        this.group = new NioEventLoopGroup(1, threadFactory);
        EventLoopGroupRetry retry = new EventLoopGroupRetry((ScheduledExecutorService)this.group, __ -> {
            monitoringModule.incrementHttpConnectAttempts();
            this.recreateConnection((Retry)__);
        });
        this.recreateConnection(retry);
    }

    private void recreateConnection(Retry retry) {
        this.lokiConnection = BootstrapUtil.initConnection((EventLoopGroup)this.group, this.clientConfiguration, this.monitoringModule);
        this.lokiConnection.addListener(future -> {
            if (future.isSuccess()) {
                future.channel().closeFuture().addListener(__ -> retry.retry());
            } else {
                retry.retry();
            }
        });
    }

    public void execute(FullHttpRequest request) {
        BlockingRetry blockingRetry = new BlockingRetry(retry -> {
            this.monitoringModule.incrementRetriedHttpRequests();
            this.execute(request, (Retry)retry);
        }, () -> {
            this.monitoringModule.incrementFailedHttpRequests();
            request.release();
        }, this.clientConfiguration.getMaxRetries());
        this.execute(request, blockingRetry);
    }

    private void execute(FullHttpRequest request, Retry retry) {
        ChannelFuture stableReference = this.lokiConnection;
        stableReference.awaitUninterruptibly();
        if (stableReference.isSuccess() && stableReference.channel().isActive()) {
            stableReference.channel().writeAndFlush((Object)request);
        } else {
            retry.retry();
        }
    }

    @Override
    public void close() {
        this.group.shutdownGracefully();
    }
}

