/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.SerializerXMLWriter;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class Xpp3Dom {
    protected String name;
    protected String value;
    protected Map attributes;
    protected List childList;
    protected Map childMap;
    protected Xpp3Dom parent;
    private static final Xpp3Dom[] EMPTY_DOM_ARRAY = new Xpp3Dom[0];

    public Xpp3Dom(String name) {
        this.name = name;
        this.childList = new ArrayList();
        this.childMap = new HashMap();
    }

    public Xpp3Dom(Xpp3Dom src) {
        this(src.getName());
        this.setValue(src.getValue());
        String[] attributeNames = src.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            this.setAttribute(attributeName, src.getAttribute(attributeName));
        }
        Xpp3Dom[] children = src.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.addChild(new Xpp3Dom(children[i]));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String[] getAttributeNames() {
        if (null == this.attributes) {
            return new String[0];
        }
        return this.attributes.keySet().toArray(new String[0]);
    }

    public String getAttribute(String name) {
        return null != this.attributes ? (String)this.attributes.get(name) : null;
    }

    public void setAttribute(String name, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Xpp3Dom getChild(int i) {
        return (Xpp3Dom)this.childList.get(i);
    }

    public Xpp3Dom getChild(String name) {
        return (Xpp3Dom)this.childMap.get(name);
    }

    public void addChild(Xpp3Dom xpp3Dom) {
        xpp3Dom.setParent(this);
        this.childList.add(xpp3Dom);
        this.childMap.put(xpp3Dom.getName(), xpp3Dom);
    }

    public Xpp3Dom[] getChildren() {
        if (null == this.childList) {
            return EMPTY_DOM_ARRAY;
        }
        return this.childList.toArray(EMPTY_DOM_ARRAY);
    }

    public Xpp3Dom[] getChildren(String name) {
        if (null == this.childList) {
            return EMPTY_DOM_ARRAY;
        }
        ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>();
        int size = this.childList.size();
        for (int i = 0; i < size; ++i) {
            Xpp3Dom configuration = (Xpp3Dom)this.childList.get(i);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(EMPTY_DOM_ARRAY);
    }

    public int getChildCount() {
        if (null == this.childList) {
            return 0;
        }
        return this.childList.size();
    }

    public void removeChild(int i) {
        Xpp3Dom child = this.getChild(i);
        this.childMap.values().remove(child);
        this.childList.remove(i);
        child.setParent(null);
    }

    public Xpp3Dom getParent() {
        return this.parent;
    }

    public void setParent(Xpp3Dom parent) {
        this.parent = parent;
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer) throws IOException {
        SerializerXMLWriter xmlWriter = new SerializerXMLWriter(namespace, serializer);
        Xpp3DomWriter.write(xmlWriter, this);
        if (xmlWriter.getExceptions().size() > 0) {
            throw (IOException)xmlWriter.getExceptions().get(0);
        }
    }

    private static void mergeIntoXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        if (recessive == null) {
            return;
        }
        Xpp3Dom[] children = recessive.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Xpp3Dom child = children[i];
            Xpp3Dom childDom = dominant.getChild(child.getName());
            if (childDom != null) {
                Xpp3Dom.mergeIntoXpp3Dom(childDom, child);
                continue;
            }
            dominant.addChild(new Xpp3Dom(child));
        }
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive);
            return dominant;
        }
        return recessive;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Xpp3Dom)) {
            return false;
        }
        Xpp3Dom dom = (Xpp3Dom)obj;
        if (this.name == null ? dom.name != null : !dom.name.equals(this.name)) {
            return false;
        }
        if (this.value == null ? dom.value != null : !dom.value.equals(this.value)) {
            return false;
        }
        if (this.attributes == null ? dom.attributes != null : !((Object)dom.attributes).equals(this.attributes)) {
            return false;
        }
        return !(this.childList == null ? dom.childList != null : !((Object)dom.childList).equals(this.childList));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 37 * result + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        result = 37 * result + (this.childList != null ? ((Object)this.childList).hashCode() : 0);
        return result;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer);
        Xpp3DomWriter.write(xmlWriter, this);
        return writer.toString();
    }
}

