/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.hslf.record.CurrentUserAtom;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSLFSlideShow {
    private InputStream istream;
    private POIFSFileSystem filesystem;
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;

    public HSLFSlideShow(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public HSLFSlideShow(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
        this.istream = inputStream;
    }

    public HSLFSlideShow(POIFSFileSystem filesystem) throws IOException {
        this.filesystem = filesystem;
        this.readFIB();
        this.readProperties();
    }

    public void close() throws IOException {
        if (this.istream != null) {
            this.istream.close();
        }
        this.filesystem = null;
    }

    private void readFIB() throws IOException {
        DocumentEntry docProps = (DocumentEntry)this.filesystem.getRoot().getEntry("PowerPoint Document");
        this._docstream = new byte[docProps.getSize()];
        this.filesystem.createDocumentInputStream("PowerPoint Document").read(this._docstream);
        this._records = Record.findChildRecords(this._docstream, 0, this._docstream.length);
    }

    public void readProperties() {
        this.dsInf = (DocumentSummaryInformation)this.getPropertySet("\u0005DocumentSummaryInformation");
        this.sInf = (SummaryInformation)this.getPropertySet("\u0005SummaryInformation");
        try {
            this.currentUser = new CurrentUserAtom(this.filesystem);
        }
        catch (IOException ie) {
            System.err.println("Error finding Current User Atom:\n" + ie);
            this.currentUser = new CurrentUserAtom();
        }
    }

    public PropertySet getPropertySet(String setName) {
        DocumentInputStream dis;
        try {
            dis = this.filesystem.createDocumentInputStream(setName);
        }
        catch (IOException ie) {
            System.err.println("Error getting property set with name " + setName + "\n" + ie);
            return null;
        }
        try {
            PropertySet set = PropertySetFactory.create((InputStream)dis);
            return set;
        }
        catch (IOException ie) {
            System.err.println("Error creating property set with name " + setName + "\n" + ie);
        }
        catch (HPSFException he) {
            System.err.println("Error creating property set with name " + setName + "\n" + (Object)((Object)he));
        }
        return null;
    }

    public void write(OutputStream out) throws IOException {
        POIFSFileSystem outFS = new POIFSFileSystem();
        if (this.sInf != null) {
            this.writePropertySet("\u0005SummaryInformation", (PropertySet)this.sInf, outFS);
        }
        if (this.dsInf != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", (PropertySet)this.dsInf, outFS);
        }
        Hashtable<Integer, Integer> oldToNewPositions = new Hashtable<Integer, Integer>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < this._records.length; ++i) {
            if (this._records[i] instanceof PositionDependentRecord) {
                PositionDependentRecord pdr = (PositionDependentRecord)((Object)this._records[i]);
                int oldPos = pdr.getLastOnDiskOffset();
                int newPos = baos.size();
                pdr.setLastOnDiskOffset(newPos);
                oldToNewPositions.put(new Integer(oldPos), new Integer(newPos));
                pdr.updateOtherRecordReferences(oldToNewPositions);
            }
            this._records[i].writeOut(baos);
        }
        this._docstream = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        outFS.createDocument((InputStream)bais, "PowerPoint Document");
        int oldLastUserEditAtomPos = (int)this.currentUser.getCurrentEditOffset();
        Integer newLastUserEditAtomPos = (Integer)oldToNewPositions.get(new Integer(oldLastUserEditAtomPos));
        if (newLastUserEditAtomPos == null) {
            throw new RuntimeException("Couldn't find the new location of the UserEditAtom that used to be at " + oldLastUserEditAtomPos);
        }
        this.currentUser.setCurrentEditOffset(newLastUserEditAtomPos.intValue());
        this.currentUser.writeToFS(outFS);
        outFS.writeFilesystem(out);
    }

    private void writePropertySet(String name, PropertySet set, POIFSFileSystem fs) throws IOException {
        try {
            MutablePropertySet mSet = new MutablePropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write((OutputStream)bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            fs.createDocument((InputStream)bIn, name);
            System.out.println("Wrote property set " + name + " of size " + data.length);
        }
        catch (WritingNotSupportedException wnse) {
            System.err.println("Couldn't write property set with name " + name + " as not supported by HPSF yet");
        }
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        return this.sInf;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }
}

