/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.util.Vector;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;

public abstract class Sheet {
    public abstract TextRun[] getTextRuns();

    public abstract int getSheetNumber();

    public static TextRun[] findTextRuns(PPDrawing ppdrawing) {
        Vector runsV = new Vector();
        EscherTextboxWrapper[] wrappers = ppdrawing.getTextboxWrappers();
        for (int i = 0; i < wrappers.length; ++i) {
            Sheet.findTextRuns(wrappers[i].getChildRecords(), runsV);
        }
        TextRun[] runs = new TextRun[runsV.size()];
        for (int i = 0; i < runs.length; ++i) {
            runs[i] = (TextRun)runsV.get(i);
        }
        return runs;
    }

    protected static void findTextRuns(Record[] records, Vector found) {
        for (int i = 0; i < records.length - 1; ++i) {
            if (!(records[i] instanceof TextHeaderAtom)) continue;
            TextRun trun = null;
            TextHeaderAtom tha = (TextHeaderAtom)records[i];
            if (records[i + 1] instanceof TextCharsAtom) {
                TextCharsAtom tca = (TextCharsAtom)records[i + 1];
                trun = new TextRun(tha, tca);
            } else if (records[i + 1] instanceof TextBytesAtom) {
                TextBytesAtom tba = (TextBytesAtom)records[i + 1];
                trun = new TextRun(tha, tba);
            } else if (records[i + 1].getRecordType() != 4001L && records[i + 1].getRecordType() != 4010L) {
                System.err.println("Found a TextHeaderAtom not followed by a TextBytesAtom or TextCharsAtom: Followed by " + records[i + 1].getRecordType());
                continue;
            }
            if (trun == null) continue;
            found.add(trun);
            ++i;
        }
    }
}

