/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.DocumentAtom;
import org.apache.poi.hslf.record.DummyPositionSensitiveRecordWithChildren;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.NotesAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.hslf.record.UnknownRecordPlaceholder;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.util.LittleEndian;

public abstract class Record {
    public abstract boolean isAnAtom();

    public abstract long getRecordType();

    public abstract Record[] getChildRecords();

    public abstract void writeOut(OutputStream var1) throws IOException;

    public static void writeLittleEndian(int i, OutputStream o) throws IOException {
        byte[] bi = new byte[4];
        LittleEndian.putInt((byte[])bi, (int)i);
        o.write(bi);
    }

    public static void writeLittleEndian(short s, OutputStream o) throws IOException {
        byte[] bs = new byte[2];
        LittleEndian.putShort((byte[])bs, (short)s);
        o.write(bs);
    }

    public static Record[] findChildRecords(byte[] b, int start, int len) {
        Vector<Record> children = new Vector<Record>(5);
        int pos = start;
        while (pos <= start + len - 8) {
            long type = LittleEndian.getUShort((byte[])b, (int)(pos + 2));
            long rlen = LittleEndian.getUInt((byte[])b, (int)(pos + 4));
            int rleni = (int)rlen;
            if (rleni < 0) {
                rleni = 0;
            }
            Record r = Record.createRecordForType(type, b, pos, 8 + rleni);
            children.add(r);
            pos += 8;
            pos = (int)((long)pos + rlen);
        }
        Record[] cRecords = new Record[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            cRecords[i] = (Record)children.get(i);
        }
        return cRecords;
    }

    public static Record createRecordForType(long type, byte[] b, int start, int len) {
        Record toReturn = null;
        switch ((int)type) {
            case 1000: {
                toReturn = new DummyPositionSensitiveRecordWithChildren(b, start, len);
                break;
            }
            case 1001: {
                toReturn = new DocumentAtom(b, start, len);
                break;
            }
            case 1006: {
                toReturn = new Slide(b, start, len);
                break;
            }
            case 1007: {
                toReturn = new SlideAtom(b, start, len);
                break;
            }
            case 1008: {
                toReturn = new Notes(b, start, len);
                break;
            }
            case 1009: {
                toReturn = new NotesAtom(b, start, len);
                break;
            }
            case 1011: {
                toReturn = new SlidePersistAtom(b, start, len);
                break;
            }
            case 1016: {
                toReturn = new DummyPositionSensitiveRecordWithChildren(b, start, len);
                break;
            }
            case 1036: {
                toReturn = new PPDrawing(b, start, len);
                break;
            }
            case 2032: {
                toReturn = new ColorSchemeAtom(b, start, len);
                break;
            }
            case 3999: {
                toReturn = new TextHeaderAtom(b, start, len);
                break;
            }
            case 4000: {
                toReturn = new TextCharsAtom(b, start, len);
                break;
            }
            case 4008: {
                toReturn = new TextBytesAtom(b, start, len);
                break;
            }
            case 4080: {
                toReturn = new SlideListWithText(b, start, len);
                break;
            }
            case 4085: {
                toReturn = new UserEditAtom(b, start, len);
                break;
            }
            case 6001: {
                toReturn = new PersistPtrHolder(b, start, len);
                break;
            }
            case 6002: {
                toReturn = new PersistPtrHolder(b, start, len);
                break;
            }
            default: {
                toReturn = new UnknownRecordPlaceholder(b, start, len);
            }
        }
        if (toReturn instanceof PositionDependentRecord) {
            PositionDependentRecord pdr = toReturn;
            pdr.setLastOnDiskOffset(start);
        }
        return toReturn;
    }
}

