/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.util.MutableByteArrayOutputStream;
import org.apache.poi.util.LittleEndian;

public abstract class RecordContainer
extends Record {
    public boolean isAnAtom() {
        return false;
    }

    public void writeOut(byte headerA, byte headerB, long type, Record[] children, OutputStream out) throws IOException {
        if (out instanceof MutableByteArrayOutputStream) {
            MutableByteArrayOutputStream mout = (MutableByteArrayOutputStream)out;
            int oldSize = mout.getBytesWritten();
            mout.write(new byte[]{headerA, headerB});
            byte[] typeB = new byte[2];
            LittleEndian.putShort((byte[])typeB, (short)((short)type));
            mout.write(typeB);
            mout.write(new byte[4]);
            for (int i = 0; i < children.length; ++i) {
                children[i].writeOut(mout);
            }
            int length = mout.getBytesWritten() - oldSize - 8;
            byte[] size = new byte[4];
            LittleEndian.putInt((byte[])size, (int)0, (int)length);
            mout.overwrite(size, oldSize + 4);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(new byte[]{headerA, headerB});
            byte[] typeB = new byte[2];
            LittleEndian.putShort((byte[])typeB, (short)((short)type));
            baos.write(typeB);
            baos.write(new byte[]{0, 0, 0, 0});
            for (int i = 0; i < children.length; ++i) {
                children[i].writeOut(baos);
            }
            byte[] toWrite = baos.toByteArray();
            LittleEndian.putInt((byte[])toWrite, (int)4, (int)(toWrite.length - 8));
            out.write(toWrite);
        }
    }
}

