/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class BorderCode
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private static final BitField _dptLineWidth = new BitField(255);
    private static final BitField _brcType = new BitField(65280);
    private short _info2;
    private static final BitField _ico = new BitField(255);
    private static final BitField _dptDpace = new BitField(7936);
    private static final BitField _fShadow = new BitField(8192);
    private static final BitField _fFrame = new BitField(16384);

    public BorderCode() {
    }

    public BorderCode(byte[] buf, int offset) {
        this._info = LittleEndian.getShort((byte[])buf, (int)offset);
        this._info2 = LittleEndian.getShort((byte[])buf, (int)(offset + 2));
    }

    public void serialize(byte[] buf, int offset) {
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this._info);
        LittleEndian.putShort((byte[])buf, (int)(offset + 2), (short)this._info2);
    }

    public int toInt() {
        byte[] buf = new byte[4];
        this.serialize(buf, 0);
        return LittleEndian.getInt((byte[])buf);
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0;
    }

    public boolean equals(Object o) {
        BorderCode brc = (BorderCode)o;
        return this._info == brc._info && this._info2 == brc._info2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

