/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeDate
extends IdScriptable {
    private static final double HalfTimeDomain = 8.64E15;
    private static final double HoursPerDay = 24.0;
    private static final double MinutesPerHour = 60.0;
    private static final double SecondsPerMinute = 60.0;
    private static final double msPerSecond = 1000.0;
    private static final double MinutesPerDay = 1440.0;
    private static final double SecondsPerDay = 86400.0;
    private static final double SecondsPerHour = 3600.0;
    private static final double msPerDay = 8.64E7;
    private static final double msPerHour = 3600000.0;
    private static final double msPerMinute = 60000.0;
    private static final boolean TZO_WORKAROUND = false;
    private static final int MAXARGS = 7;
    private static String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static int[] ttb = new int[]{-1, -2, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
    private static final int FORMATSPEC_FULL = 0;
    private static final int FORMATSPEC_DATE = 1;
    private static final int FORMATSPEC_TIME = 2;
    private static String js_NaN_date_str = "Invalid Date";
    private static String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final int ConstructorId_UTC = -2;
    private static final int ConstructorId_parse = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toTimeString = 3;
    private static final int Id_toDateString = 4;
    private static final int Id_toLocaleString = 5;
    private static final int Id_toLocaleTimeString = 6;
    private static final int Id_toLocaleDateString = 7;
    private static final int Id_toUTCString = 8;
    private static final int Id_valueOf = 9;
    private static final int Id_getTime = 10;
    private static final int Id_getYear = 11;
    private static final int Id_getFullYear = 12;
    private static final int Id_getUTCFullYear = 13;
    private static final int Id_getMonth = 14;
    private static final int Id_getUTCMonth = 15;
    private static final int Id_getDate = 16;
    private static final int Id_getUTCDate = 17;
    private static final int Id_getDay = 18;
    private static final int Id_getUTCDay = 19;
    private static final int Id_getHours = 20;
    private static final int Id_getUTCHours = 21;
    private static final int Id_getMinutes = 22;
    private static final int Id_getUTCMinutes = 23;
    private static final int Id_getSeconds = 24;
    private static final int Id_getUTCSeconds = 25;
    private static final int Id_getMilliseconds = 26;
    private static final int Id_getUTCMilliseconds = 27;
    private static final int Id_getTimezoneOffset = 28;
    private static final int Id_setTime = 29;
    private static final int Id_setMilliseconds = 30;
    private static final int Id_setUTCMilliseconds = 31;
    private static final int Id_setSeconds = 32;
    private static final int Id_setUTCSeconds = 33;
    private static final int Id_setMinutes = 34;
    private static final int Id_setUTCMinutes = 35;
    private static final int Id_setHours = 36;
    private static final int Id_setUTCHours = 37;
    private static final int Id_setDate = 38;
    private static final int Id_setUTCDate = 39;
    private static final int Id_setMonth = 40;
    private static final int Id_setUTCMonth = 41;
    private static final int Id_setFullYear = 42;
    private static final int Id_setUTCFullYear = 43;
    private static final int Id_setYear = 44;
    private static final int MAX_PROTOTYPE_ID = 44;
    private static final int Id_toGMTString = 8;
    private static TimeZone thisTimeZone;
    private static double LocalTZA;
    private static DateFormat timeZoneFormatter;
    private static DateFormat localeDateTimeFormatter;
    private static DateFormat localeDateFormatter;
    private static DateFormat localeTimeFormatter;
    private double date;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeDate obj = new NativeDate();
        obj.prototypeFlag = true;
        obj.date = ScriptRuntime.NaN;
        obj.addAsPrototype(44, cx, scope, sealed);
    }

    private NativeDate() {
        if (thisTimeZone == null) {
            thisTimeZone = TimeZone.getDefault();
            LocalTZA = thisTimeZone.getRawOffset();
        }
    }

    public String getClassName() {
        return "Date";
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == null) {
            typeHint = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(typeHint);
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
        this.addIdFunctionProperty(ctor, -2, sealed);
        this.addIdFunctionProperty(ctor, -1, sealed);
        super.fillConstructorProperties(cx, ctor, sealed);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case -2: {
                    return 1;
                }
                case -1: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 0;
                }
                case 9: {
                    return 0;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 0;
                }
                case 14: {
                    return 0;
                }
                case 15: {
                    return 0;
                }
                case 16: {
                    return 0;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 1;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 2;
                }
                case 33: {
                    return 2;
                }
                case 34: {
                    return 3;
                }
                case 35: {
                    return 3;
                }
                case 36: {
                    return 4;
                }
                case 37: {
                    return 4;
                }
                case 38: {
                    return 1;
                }
                case 39: {
                    return 1;
                }
                case 40: {
                    return 2;
                }
                case 41: {
                    return 2;
                }
                case 42: {
                    return 3;
                }
                case 43: {
                    return 3;
                }
                case 44: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case -2: {
                    return this.wrap_double(NativeDate.jsStaticFunction_UTC(args));
                }
                case -1: {
                    return this.wrap_double(NativeDate.jsStaticFunction_parse(ScriptRuntime.toString(args, 0)));
                }
                case 1: {
                    return NativeDate.jsConstructor(args, thisObj == null);
                }
                case 2: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    return NativeDate.date_format(t, 0);
                }
                case 3: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    return NativeDate.date_format(t, 2);
                }
                case 4: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    return NativeDate.date_format(t, 1);
                }
                case 5: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    return NativeDate.js_toLocaleString(t);
                }
                case 6: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    return NativeDate.js_toLocaleTimeString(t);
                }
                case 7: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    return NativeDate.js_toLocaleDateString(t);
                }
                case 8: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        return NativeDate.js_toUTCString(t);
                    }
                    return js_NaN_date_str;
                }
                case 9: {
                    return this.wrap_double(this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date);
                }
                case 10: {
                    return this.wrap_double(this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date);
                }
                case 11: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.js_getYear(cx, t);
                    }
                    return this.wrap_double(t);
                }
                case 12: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.YearFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 13: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.YearFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 14: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.MonthFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 15: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.MonthFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 16: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.DateFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 17: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.DateFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 18: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.WeekDay(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 19: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.WeekDay(t);
                    }
                    return this.wrap_double(t);
                }
                case 20: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.HourFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 21: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.HourFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 22: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.MinFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 23: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.MinFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 24: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.SecFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 25: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.SecFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 26: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.msFromTime(NativeDate.LocalTime(t));
                    }
                    return this.wrap_double(t);
                }
                case 27: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.msFromTime(t);
                    }
                    return this.wrap_double(t);
                }
                case 28: {
                    double t = this.realThis((Scriptable)thisObj, (IdFunction)f, (boolean)true).date;
                    if (t == t) {
                        t = NativeDate.js_getTimezoneOffset(t);
                    }
                    return this.wrap_double(t);
                }
                case 29: {
                    return this.wrap_double(this.realThis(thisObj, f, true).js_setTime(ScriptRuntime.toNumber(args, 0)));
                }
                case 30: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 1, true));
                }
                case 31: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 1, false));
                }
                case 32: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 2, true));
                }
                case 33: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 2, false));
                }
                case 34: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 3, true));
                }
                case 35: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 3, false));
                }
                case 36: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 4, true));
                }
                case 37: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeTime(args, 4, false));
                }
                case 38: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeDate(args, 1, true));
                }
                case 39: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeDate(args, 1, false));
                }
                case 40: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeDate(args, 2, true));
                }
                case 41: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeDate(args, 2, false));
                }
                case 42: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeDate(args, 3, true));
                }
                case 43: {
                    return this.wrap_double(this.realThis(thisObj, f, false).makeDate(args, 3, false));
                }
                case 44: {
                    return this.wrap_double(this.realThis(thisObj, f, false).js_setYear(ScriptRuntime.toNumber(args, 0)));
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeDate realThis(Scriptable thisObj, IdFunction f, boolean readOnly) {
        while (!(thisObj instanceof NativeDate)) {
            thisObj = this.nextInstanceCheck(thisObj, f, readOnly);
        }
        return (NativeDate)thisObj;
    }

    private static double Day(double t) {
        return Math.floor(t / 8.64E7);
    }

    private static double TimeWithinDay(double t) {
        double result = t % 8.64E7;
        if (result < 0.0) {
            result += 8.64E7;
        }
        return result;
    }

    private static int DaysInYear(int y) {
        if (y % 4 == 0 && (y % 100 != 0 || y % 400 == 0)) {
            return 366;
        }
        return 365;
    }

    private static double DayFromYear(double y) {
        return 365.0 * (y - 1970.0) + Math.floor((y - 1969.0) / 4.0) - Math.floor((y - 1901.0) / 100.0) + Math.floor((y - 1601.0) / 400.0);
    }

    private static double TimeFromYear(double y) {
        return NativeDate.DayFromYear(y) * 8.64E7;
    }

    private static int YearFromTime(double t) {
        int temp;
        int lo = (int)Math.floor(t / 8.64E7 / 366.0) + 1970;
        int hi = (int)Math.floor(t / 8.64E7 / 365.0) + 1970;
        if (hi < lo) {
            temp = lo;
            lo = hi;
            hi = temp;
        }
        while (hi > lo) {
            int mid = (hi + lo) / 2;
            if (NativeDate.TimeFromYear(mid) > t) {
                hi = mid - 1;
                continue;
            }
            if (!(NativeDate.TimeFromYear(mid) <= t)) continue;
            temp = mid + 1;
            if (NativeDate.TimeFromYear(temp) > t) {
                return mid;
            }
            lo = mid + 1;
        }
        return lo;
    }

    private static boolean InLeapYear(double t) {
        return NativeDate.DaysInYear(NativeDate.YearFromTime(t)) == 366;
    }

    private static int DayWithinYear(double t) {
        int year = NativeDate.YearFromTime(t);
        return (int)(NativeDate.Day(t) - NativeDate.DayFromYear(year));
    }

    private static double DayFromMonth(int m, boolean leap) {
        int day = m * 30;
        day = m >= 7 ? (day += m / 2 - 1) : (m >= 2 ? (day += (m - 1) / 2 - 1) : (day += m));
        if (leap && m >= 2) {
            ++day;
        }
        return day;
    }

    private static int MonthFromTime(double t) {
        int d = NativeDate.DayWithinYear(t);
        int step = 31;
        if (d < 31) {
            return 0;
        }
        step = NativeDate.InLeapYear(t) ? (step += 29) : (step += 28);
        if (d < step) {
            return 1;
        }
        if (d < (step += 31)) {
            return 2;
        }
        if (d < (step += 30)) {
            return 3;
        }
        if (d < (step += 31)) {
            return 4;
        }
        if (d < (step += 30)) {
            return 5;
        }
        if (d < (step += 31)) {
            return 6;
        }
        if (d < (step += 31)) {
            return 7;
        }
        if (d < (step += 30)) {
            return 8;
        }
        if (d < (step += 31)) {
            return 9;
        }
        if (d < (step += 30)) {
            return 10;
        }
        return 11;
    }

    private static int DateFromTime(double t) {
        int d = NativeDate.DayWithinYear(t);
        int next = 30;
        if (d <= 30) {
            return d + 1;
        }
        int step = next;
        next = NativeDate.InLeapYear(t) ? (next += 29) : (next += 28);
        if (d <= next) {
            return d - step;
        }
        step = next;
        if (d <= (next += 31)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 30)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 31)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 30)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 31)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 31)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 30)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 31)) {
            return d - step;
        }
        step = next;
        if (d <= (next += 30)) {
            return d - step;
        }
        step = next;
        return d - step;
    }

    private static int WeekDay(double t) {
        double result = NativeDate.Day(t) + 4.0;
        if ((result %= 7.0) < 0.0) {
            result += 7.0;
        }
        return (int)result;
    }

    private static double Now() {
        return System.currentTimeMillis();
    }

    private static double DaylightSavingTA(double t) {
        Date date = new Date((long)t);
        if (thisTimeZone.inDaylightTime(date)) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static double LocalTime(double t) {
        return t + LocalTZA + NativeDate.DaylightSavingTA(t);
    }

    private static double internalUTC(double t) {
        return t - LocalTZA - NativeDate.DaylightSavingTA(t - LocalTZA);
    }

    private static int HourFromTime(double t) {
        double result = Math.floor(t / 3600000.0) % 24.0;
        if (result < 0.0) {
            result += 24.0;
        }
        return (int)result;
    }

    private static int MinFromTime(double t) {
        double result = Math.floor(t / 60000.0) % 60.0;
        if (result < 0.0) {
            result += 60.0;
        }
        return (int)result;
    }

    private static int SecFromTime(double t) {
        double result = Math.floor(t / 1000.0) % 60.0;
        if (result < 0.0) {
            result += 60.0;
        }
        return (int)result;
    }

    private static int msFromTime(double t) {
        double result = t % 1000.0;
        if (result < 0.0) {
            result += 1000.0;
        }
        return (int)result;
    }

    private static double MakeTime(double hour, double min, double sec, double ms) {
        return ((hour * 60.0 + min) * 60.0 + sec) * 1000.0 + ms;
    }

    private static double MakeDay(double year, double month, double date) {
        year += Math.floor(month / 12.0);
        if ((month %= 12.0) < 0.0) {
            month += 12.0;
        }
        boolean leap = NativeDate.DaysInYear((int)year) == 366;
        double yearday = Math.floor(NativeDate.TimeFromYear(year) / 8.64E7);
        double monthday = NativeDate.DayFromMonth((int)month, leap);
        double result = yearday + monthday + date - 1.0;
        return result;
    }

    private static double MakeDate(double day, double time) {
        return day * 8.64E7 + time;
    }

    private static double TimeClip(double d) {
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Math.abs(d) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d > 0.0) {
            return Math.floor(d + 0.0);
        }
        return Math.ceil(d + 0.0);
    }

    private static double date_msecFromDate(double year, double mon, double mday, double hour, double min, double sec, double msec) {
        double day = NativeDate.MakeDay(year, mon, mday);
        double time = NativeDate.MakeTime(hour, min, sec, msec);
        double result = NativeDate.MakeDate(day, time);
        return result;
    }

    private static double jsStaticFunction_UTC(Object[] args) {
        double d;
        double[] array = new double[7];
        int loop = 0;
        while (loop < 7) {
            if (loop < args.length) {
                d = ScriptRuntime.toNumber(args[loop]);
                if (d != d || Double.isInfinite(d)) {
                    return ScriptRuntime.NaN;
                }
                array[loop] = ScriptRuntime.toInteger(args[loop]);
            } else {
                array[loop] = 0.0;
            }
            ++loop;
        }
        if (array[0] >= 0.0 && array[0] <= 99.0) {
            array[0] = array[0] + 1900.0;
        }
        if (array[2] < 1.0) {
            array[2] = 1.0;
        }
        d = NativeDate.date_msecFromDate(array[0], array[1], array[2], array[3], array[4], array[5], array[6]);
        d = NativeDate.TimeClip(d);
        return d;
    }

    private static boolean date_regionMatches(String s1, int s1off, String s2, int s2off, int count) {
        boolean result = false;
        int s1len = s1.length();
        int s2len = s2.length();
        while (count > 0 && s1off < s1len && s2off < s2len) {
            if (Character.toLowerCase(s1.charAt(s1off)) != Character.toLowerCase(s2.charAt(s2off))) break;
            ++s1off;
            ++s2off;
            --count;
        }
        if (count == 0) {
            result = true;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double date_parseString(String s) {
        int year = -1;
        int mon = -1;
        int mday = -1;
        int hour = -1;
        int min = -1;
        int sec = -1;
        char c = '\u0000';
        char si = '\u0000';
        int i = 0;
        int n = -1;
        double tzoffset = -1.0;
        char prevc = '\u0000';
        int limit = 0;
        boolean seenplusminus = false;
        if (s == null) {
            return ScriptRuntime.NaN;
        }
        limit = s.length();
        block0: while (i < limit) {
            c = s.charAt(i);
            ++i;
            if (c <= ' ' || c == ',' || c == '-') {
                if (i >= limit) continue;
                si = s.charAt(i);
                if (c != '-' || '0' > si || si > '9') continue;
                prevc = c;
                continue;
            }
            if (c == '(') {
                int depth = 1;
                while (i < limit) {
                    c = s.charAt(i);
                    ++i;
                    if (c == '(') {
                        ++depth;
                        continue;
                    }
                    if (c == ')' && --depth <= 0) continue block0;
                }
                continue;
            }
            if ('0' <= c && c <= '9') {
                n = c - 48;
                while (i < limit && '0' <= (c = s.charAt(i)) && c <= '9') {
                    n = n * 10 + c - 48;
                    ++i;
                }
                if (prevc == '+' || prevc == '-') {
                    seenplusminus = true;
                    n = n < 24 ? (n *= 60) : n % 100 + n / 100 * 60;
                    if (prevc == '+') {
                        n = -n;
                    }
                    if (tzoffset != 0.0 && tzoffset != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    tzoffset = n;
                } else if (n >= 70 || prevc == '/' && mon >= 0 && mday >= 0 && year < 0) {
                    if (year >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c > ' ' && c != ',' && c != '/' && i < limit) return ScriptRuntime.NaN;
                    year = n < 100 ? n + 1900 : n;
                } else if (c == ':') {
                    if (hour < 0) {
                        hour = n;
                    } else {
                        if (min >= 0) return ScriptRuntime.NaN;
                        min = n;
                    }
                } else if (c == '/') {
                    if (mon < 0) {
                        mon = n - 1;
                    } else {
                        if (mday >= 0) return ScriptRuntime.NaN;
                        mday = n;
                    }
                } else {
                    if (i < limit && c != ',' && c > ' ' && c != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (seenplusminus && n < 60) {
                        tzoffset = tzoffset < 0.0 ? (tzoffset -= (double)n) : (tzoffset += (double)n);
                    } else if (hour >= 0 && min < 0) {
                        min = n;
                    } else if (min >= 0 && sec < 0) {
                        sec = n;
                    } else {
                        if (mday >= 0) return ScriptRuntime.NaN;
                        mday = n;
                    }
                }
                prevc = '\u0000';
                continue;
            }
            if (c == '/' || c == ':' || c == '+' || c == '-') {
                prevc = c;
                continue;
            }
            int st = i - 1;
            while (i < limit) {
                c = s.charAt(i);
                if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) break;
                ++i;
            }
            if (i <= st + 1) {
                return ScriptRuntime.NaN;
            }
            int k = wtb.length;
            while (--k >= 0) {
                if (!NativeDate.date_regionMatches(wtb[k], 0, s, st, i - st)) continue;
                int action = ttb[k];
                if (action == 0) break;
                if (action < 0) {
                    if (hour > 12 || hour < 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (action == -1 && hour == 12) {
                        hour = 0;
                        break;
                    }
                    if (action != -2 || hour == 12) break;
                    hour += 12;
                    break;
                }
                if (action <= 13) {
                    if (mon >= 0) return ScriptRuntime.NaN;
                    mon = action - 2;
                    break;
                }
                tzoffset = action - 10000;
                break;
            }
            if (k < 0) {
                return ScriptRuntime.NaN;
            }
            prevc = '\u0000';
        }
        if (year < 0 || mon < 0 || mday < 0) {
            return ScriptRuntime.NaN;
        }
        if (sec < 0) {
            sec = 0;
        }
        if (min < 0) {
            min = 0;
        }
        if (hour < 0) {
            hour = 0;
        }
        if (tzoffset == -1.0) {
            double time = NativeDate.date_msecFromDate(year, mon, mday, hour, min, sec, 0.0);
            return NativeDate.internalUTC(time);
        }
        double msec = NativeDate.date_msecFromDate(year, mon, mday, hour, min, sec, 0.0);
        return msec += tzoffset * 60000.0;
    }

    private static double jsStaticFunction_parse(String s) {
        return NativeDate.date_parseString(s);
    }

    private static String date_format(double t, int format) {
        int i;
        if (t != t) {
            return js_NaN_date_str;
        }
        StringBuffer result = new StringBuffer(60);
        double local = NativeDate.LocalTime(t);
        int minutes = (int)Math.floor((LocalTZA + NativeDate.DaylightSavingTA(t)) / 60000.0);
        int offset = minutes / 60 * 100 + minutes % 60;
        String dateStr = Integer.toString(NativeDate.DateFromTime(local));
        String hourStr = Integer.toString(NativeDate.HourFromTime(local));
        String minStr = Integer.toString(NativeDate.MinFromTime(local));
        String secStr = Integer.toString(NativeDate.SecFromTime(local));
        String offsetStr = Integer.toString(offset > 0 ? offset : -offset);
        int year = NativeDate.YearFromTime(local);
        String yearStr = Integer.toString(year > 0 ? year : -year);
        if (format != 2) {
            result.append(days[NativeDate.WeekDay(local)]);
            result.append(' ');
            result.append(months[NativeDate.MonthFromTime(local)]);
            if (dateStr.length() == 1) {
                result.append(" 0");
            } else {
                result.append(' ');
            }
            result.append(dateStr);
            result.append(' ');
            if (year < 0) {
                result.append('-');
            }
            i = yearStr.length();
            while (i < 4) {
                result.append('0');
                ++i;
            }
            result.append(yearStr);
            if (format != 1) {
                result.append(' ');
            }
        }
        if (format != 1) {
            if (hourStr.length() == 1) {
                result.append('0');
            }
            result.append(hourStr);
            if (minStr.length() == 1) {
                result.append(":0");
            } else {
                result.append(':');
            }
            result.append(minStr);
            if (secStr.length() == 1) {
                result.append(":0");
            } else {
                result.append(':');
            }
            result.append(secStr);
            if (offset > 0) {
                result.append(" GMT+");
            } else {
                result.append(" GMT-");
            }
            i = offsetStr.length();
            while (i < 4) {
                result.append('0');
                ++i;
            }
            result.append(offsetStr);
            if (timeZoneFormatter == null) {
                timeZoneFormatter = new SimpleDateFormat("zzz");
            }
            if (timeZoneFormatter != null) {
                result.append(" (");
                Date date = new Date((long)t);
                result.append(timeZoneFormatter.format(date));
                result.append(')');
            }
        }
        return result.toString();
    }

    private static Object jsConstructor(Object[] args, boolean inNewExpr) {
        if (!inNewExpr) {
            return NativeDate.date_format(NativeDate.Now(), 0);
        }
        NativeDate obj = new NativeDate();
        if (args.length == 0) {
            obj.date = NativeDate.Now();
            return obj;
        }
        if (args.length == 1) {
            double date;
            if (args[0] instanceof Scriptable) {
                args[0] = ((Scriptable)args[0]).getDefaultValue(null);
            }
            if (!(args[0] instanceof String)) {
                date = ScriptRuntime.toNumber(args[0]);
            } else {
                String str = (String)args[0];
                date = NativeDate.date_parseString(str);
            }
            obj.date = NativeDate.TimeClip(date);
            return obj;
        }
        double[] array = new double[7];
        int loop = 0;
        while (loop < 7) {
            if (loop < args.length) {
                double d = ScriptRuntime.toNumber(args[loop]);
                if (d != d || Double.isInfinite(d)) {
                    obj.date = ScriptRuntime.NaN;
                    return obj;
                }
                array[loop] = ScriptRuntime.toInteger(args[loop]);
            } else {
                array[loop] = 0.0;
            }
            ++loop;
        }
        if (array[0] >= 0.0 && array[0] <= 99.0) {
            array[0] = array[0] + 1900.0;
        }
        if (array[2] < 1.0) {
            array[2] = 1.0;
        }
        double day = NativeDate.MakeDay(array[0], array[1], array[2]);
        double time = NativeDate.MakeTime(array[3], array[4], array[5], array[6]);
        time = NativeDate.MakeDate(day, time);
        time = NativeDate.internalUTC(time);
        obj.date = NativeDate.TimeClip(time);
        return obj;
    }

    private static String toLocale_helper(double t, DateFormat formatter) {
        if (t != t) {
            return js_NaN_date_str;
        }
        Date tempdate = new Date((long)t);
        return formatter.format(tempdate);
    }

    private static String js_toLocaleString(double date) {
        if (localeDateTimeFormatter == null) {
            localeDateTimeFormatter = DateFormat.getDateTimeInstance(1, 1);
        }
        return NativeDate.toLocale_helper(date, localeDateTimeFormatter);
    }

    private static String js_toLocaleTimeString(double date) {
        if (localeTimeFormatter == null) {
            localeTimeFormatter = DateFormat.getTimeInstance(1);
        }
        return NativeDate.toLocale_helper(date, localeTimeFormatter);
    }

    private static String js_toLocaleDateString(double date) {
        if (localeDateFormatter == null) {
            localeDateFormatter = DateFormat.getDateInstance(1);
        }
        return NativeDate.toLocale_helper(date, localeDateFormatter);
    }

    private static String js_toUTCString(double date) {
        StringBuffer result = new StringBuffer(60);
        String dateStr = Integer.toString(NativeDate.DateFromTime(date));
        String hourStr = Integer.toString(NativeDate.HourFromTime(date));
        String minStr = Integer.toString(NativeDate.MinFromTime(date));
        String secStr = Integer.toString(NativeDate.SecFromTime(date));
        int year = NativeDate.YearFromTime(date);
        String yearStr = Integer.toString(year > 0 ? year : -year);
        result.append(days[NativeDate.WeekDay(date)]);
        result.append(", ");
        if (dateStr.length() == 1) {
            result.append('0');
        }
        result.append(dateStr);
        result.append(' ');
        result.append(months[NativeDate.MonthFromTime(date)]);
        if (year < 0) {
            result.append(" -");
        } else {
            result.append(' ');
        }
        int i = yearStr.length();
        while (i < 4) {
            result.append('0');
            ++i;
        }
        result.append(yearStr);
        if (hourStr.length() == 1) {
            result.append(" 0");
        } else {
            result.append(' ');
        }
        result.append(hourStr);
        if (minStr.length() == 1) {
            result.append(":0");
        } else {
            result.append(':');
        }
        result.append(minStr);
        if (secStr.length() == 1) {
            result.append(":0");
        } else {
            result.append(':');
        }
        result.append(secStr);
        result.append(" GMT");
        return result.toString();
    }

    private static double js_getYear(Context cx, double date) {
        int result = NativeDate.YearFromTime(NativeDate.LocalTime(date));
        if (cx.hasFeature(1)) {
            if (result >= 1900 && result < 2000) {
                result -= 1900;
            }
        } else {
            result -= 1900;
        }
        return result;
    }

    private static double js_getTimezoneOffset(double date) {
        return (date - NativeDate.LocalTime(date)) / 60000.0;
    }

    private double js_setTime(double time) {
        this.date = NativeDate.TimeClip(time);
        return this.date;
    }

    private double makeTime(Object[] args, int maxargs, boolean local) {
        double[] conv = new double[4];
        double date = this.date;
        if (date != date) {
            return date;
        }
        if (args.length == 0) {
            args = ScriptRuntime.padArguments(args, 1);
        }
        int i = 0;
        while (i < args.length && i < maxargs) {
            conv[i] = ScriptRuntime.toNumber(args[i]);
            if (conv[i] != conv[i] || Double.isInfinite(conv[i])) {
                this.date = ScriptRuntime.NaN;
                return this.date;
            }
            conv[i] = ScriptRuntime.toInteger(conv[i]);
            ++i;
        }
        double lorutime = local ? NativeDate.LocalTime(date) : date;
        i = 0;
        int stop = args.length;
        double hour = maxargs >= 4 && i < stop ? conv[i++] : (double)NativeDate.HourFromTime(lorutime);
        double min = maxargs >= 3 && i < stop ? conv[i++] : (double)NativeDate.MinFromTime(lorutime);
        double sec = maxargs >= 2 && i < stop ? conv[i++] : (double)NativeDate.SecFromTime(lorutime);
        double msec = maxargs >= 1 && i < stop ? conv[i++] : (double)NativeDate.msFromTime(lorutime);
        double time = NativeDate.MakeTime(hour, min, sec, msec);
        double result = NativeDate.MakeDate(NativeDate.Day(lorutime), time);
        if (local) {
            result = NativeDate.internalUTC(result);
        }
        this.date = date = NativeDate.TimeClip(result);
        return date;
    }

    private double js_setHours(Object[] args) {
        return this.makeTime(args, 4, true);
    }

    private double js_setUTCHours(Object[] args) {
        return this.makeTime(args, 4, false);
    }

    private double makeDate(Object[] args, int maxargs, boolean local) {
        double lorutime;
        double[] conv = new double[3];
        double date = this.date;
        if (args.length == 0) {
            args = ScriptRuntime.padArguments(args, 1);
        }
        int i = 0;
        while (i < args.length && i < maxargs) {
            conv[i] = ScriptRuntime.toNumber(args[i]);
            if (conv[i] != conv[i] || Double.isInfinite(conv[i])) {
                this.date = ScriptRuntime.NaN;
                return this.date;
            }
            conv[i] = ScriptRuntime.toInteger(conv[i]);
            ++i;
        }
        if (date != date) {
            if (args.length < 3) {
                return ScriptRuntime.NaN;
            }
            lorutime = 0.0;
        } else {
            lorutime = local ? NativeDate.LocalTime(date) : date;
        }
        i = 0;
        int stop = args.length;
        double year = maxargs >= 3 && i < stop ? conv[i++] : (double)NativeDate.YearFromTime(lorutime);
        double month = maxargs >= 2 && i < stop ? conv[i++] : (double)NativeDate.MonthFromTime(lorutime);
        double day = maxargs >= 1 && i < stop ? conv[i++] : (double)NativeDate.DateFromTime(lorutime);
        day = NativeDate.MakeDay(year, month, day);
        double result = NativeDate.MakeDate(day, NativeDate.TimeWithinDay(lorutime));
        if (local) {
            result = NativeDate.internalUTC(result);
        }
        this.date = date = NativeDate.TimeClip(result);
        return date;
    }

    private double js_setYear(double year) {
        if (year != year || Double.isInfinite(year)) {
            this.date = ScriptRuntime.NaN;
            return this.date;
        }
        this.date = this.date != this.date ? 0.0 : NativeDate.LocalTime(this.date);
        if (year >= 0.0 && year <= 99.0) {
            year += 1900.0;
        }
        double day = NativeDate.MakeDay(year, NativeDate.MonthFromTime(this.date), NativeDate.DateFromTime(this.date));
        double result = NativeDate.MakeDate(day, NativeDate.TimeWithinDay(this.date));
        result = NativeDate.internalUTC(result);
        this.date = NativeDate.TimeClip(result);
        return this.date;
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            switch (id) {
                case -2: {
                    return "UTC";
                }
                case -1: {
                    return "parse";
                }
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toTimeString";
                }
                case 4: {
                    return "toDateString";
                }
                case 5: {
                    return "toLocaleString";
                }
                case 6: {
                    return "toLocaleTimeString";
                }
                case 7: {
                    return "toLocaleDateString";
                }
                case 8: {
                    return "toUTCString";
                }
                case 9: {
                    return "valueOf";
                }
                case 10: {
                    return "getTime";
                }
                case 11: {
                    return "getYear";
                }
                case 12: {
                    return "getFullYear";
                }
                case 13: {
                    return "getUTCFullYear";
                }
                case 14: {
                    return "getMonth";
                }
                case 15: {
                    return "getUTCMonth";
                }
                case 16: {
                    return "getDate";
                }
                case 17: {
                    return "getUTCDate";
                }
                case 18: {
                    return "getDay";
                }
                case 19: {
                    return "getUTCDay";
                }
                case 20: {
                    return "getHours";
                }
                case 21: {
                    return "getUTCHours";
                }
                case 22: {
                    return "getMinutes";
                }
                case 23: {
                    return "getUTCMinutes";
                }
                case 24: {
                    return "getSeconds";
                }
                case 25: {
                    return "getUTCSeconds";
                }
                case 26: {
                    return "getMilliseconds";
                }
                case 27: {
                    return "getUTCMilliseconds";
                }
                case 28: {
                    return "getTimezoneOffset";
                }
                case 29: {
                    return "setTime";
                }
                case 30: {
                    return "setMilliseconds";
                }
                case 31: {
                    return "setUTCMilliseconds";
                }
                case 32: {
                    return "setSeconds";
                }
                case 33: {
                    return "setUTCSeconds";
                }
                case 34: {
                    return "setMinutes";
                }
                case 35: {
                    return "setUTCMinutes";
                }
                case 36: {
                    return "setHours";
                }
                case 37: {
                    return "setUTCHours";
                }
                case 38: {
                    return "setDate";
                }
                case 39: {
                    return "setUTCDate";
                }
                case 40: {
                    return "setMonth";
                }
                case 41: {
                    return "setUTCMonth";
                }
                case 42: {
                    return "setFullYear";
                }
                case 43: {
                    return "setUTCFullYear";
                }
                case 44: {
                    return "setYear";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 6: {
                X = "getDay";
                id = 18;
                break;
            }
            case 7: {
                switch (s.charAt(3)) {
                    case 'D': {
                        char c = s.charAt(0);
                        if (c == 'g') {
                            X = "getDate";
                            id = 16;
                            break block0;
                        }
                        if (c != 's') break block0;
                        X = "setDate";
                        id = 38;
                        break block0;
                    }
                    case 'T': {
                        char c = s.charAt(0);
                        if (c == 'g') {
                            X = "getTime";
                            id = 10;
                            break block0;
                        }
                        if (c != 's') break block0;
                        X = "setTime";
                        id = 29;
                        break block0;
                    }
                    case 'Y': {
                        char c = s.charAt(0);
                        if (c == 'g') {
                            X = "getYear";
                            id = 11;
                            break block0;
                        }
                        if (c != 's') break block0;
                        X = "setYear";
                        id = 44;
                        break block0;
                    }
                    case 'u': {
                        X = "valueOf";
                        id = 9;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'g') {
                    c = s.charAt(7);
                    if (c == 'h') {
                        X = "getMonth";
                        id = 14;
                        break;
                    }
                    if (c != 's') break;
                    X = "getHours";
                    id = 20;
                    break;
                }
                if (c == 's') {
                    c = s.charAt(7);
                    if (c == 'h') {
                        X = "setMonth";
                        id = 40;
                        break;
                    }
                    if (c != 's') break;
                    X = "setHours";
                    id = 36;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 9: {
                X = "getUTCDay";
                id = 19;
                break;
            }
            case 10: {
                char c = s.charAt(3);
                if (c == 'M') {
                    c = s.charAt(0);
                    if (c == 'g') {
                        X = "getMinutes";
                        id = 22;
                        break;
                    }
                    if (c != 's') break;
                    X = "setMinutes";
                    id = 34;
                    break;
                }
                if (c == 'S') {
                    c = s.charAt(0);
                    if (c == 'g') {
                        X = "getSeconds";
                        id = 24;
                        break;
                    }
                    if (c != 's') break;
                    X = "setSeconds";
                    id = 32;
                    break;
                }
                if (c != 'U') break;
                c = s.charAt(0);
                if (c == 'g') {
                    X = "getUTCDate";
                    id = 17;
                    break;
                }
                if (c != 's') break;
                X = "setUTCDate";
                id = 39;
                break;
            }
            case 11: {
                switch (s.charAt(3)) {
                    case 'F': {
                        char c = s.charAt(0);
                        if (c == 'g') {
                            X = "getFullYear";
                            id = 12;
                            break block0;
                        }
                        if (c != 's') break block0;
                        X = "setFullYear";
                        id = 42;
                        break block0;
                    }
                    case 'M': {
                        X = "toGMTString";
                        id = 8;
                        break block0;
                    }
                    case 'T': {
                        X = "toUTCString";
                        id = 8;
                        break block0;
                    }
                    case 'U': {
                        char c = s.charAt(0);
                        if (c == 'g') {
                            c = s.charAt(9);
                            if (c == 'r') {
                                X = "getUTCHours";
                                id = 21;
                                break block0;
                            }
                            if (c != 't') break block0;
                            X = "getUTCMonth";
                            id = 15;
                            break block0;
                        }
                        if (c != 's') break block0;
                        c = s.charAt(9);
                        if (c == 'r') {
                            X = "setUTCHours";
                            id = 37;
                            break block0;
                        }
                        if (c != 't') break block0;
                        X = "setUTCMonth";
                        id = 41;
                        break block0;
                    }
                    case 's': {
                        X = "constructor";
                        id = 1;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = s.charAt(2);
                if (c == 'D') {
                    X = "toDateString";
                    id = 4;
                    break;
                }
                if (c != 'T') break;
                X = "toTimeString";
                id = 3;
                break;
            }
            case 13: {
                char c = s.charAt(0);
                if (c == 'g') {
                    c = s.charAt(6);
                    if (c == 'M') {
                        X = "getUTCMinutes";
                        id = 23;
                        break;
                    }
                    if (c != 'S') break;
                    X = "getUTCSeconds";
                    id = 25;
                    break;
                }
                if (c != 's') break;
                c = s.charAt(6);
                if (c == 'M') {
                    X = "setUTCMinutes";
                    id = 35;
                    break;
                }
                if (c != 'S') break;
                X = "setUTCSeconds";
                id = 33;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getUTCFullYear";
                    id = 13;
                    break;
                }
                if (c == 's') {
                    X = "setUTCFullYear";
                    id = 43;
                    break;
                }
                if (c != 't') break;
                X = "toLocaleString";
                id = 5;
                break;
            }
            case 15: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getMilliseconds";
                    id = 26;
                    break;
                }
                if (c != 's') break;
                X = "setMilliseconds";
                id = 30;
                break;
            }
            case 17: {
                X = "getTimezoneOffset";
                id = 28;
                break;
            }
            case 18: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getUTCMilliseconds";
                    id = 27;
                    break;
                }
                if (c == 's') {
                    X = "setUTCMilliseconds";
                    id = 31;
                    break;
                }
                if (c != 't') break;
                c = s.charAt(8);
                if (c == 'D') {
                    X = "toLocaleDateString";
                    id = 7;
                    break;
                }
                if (c != 'T') break;
                X = "toLocaleTimeString";
                id = 6;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

