/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptIRFactory;
import org.mozilla.javascript.optimizer.OptLocalVariable;
import org.mozilla.javascript.optimizer.OptRuntime;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    private final int JAVASCRIPTEXCEPTION = 0;
    private final int WRAPPEDEXCEPTION = 1;
    private static final String functionSuperClassName = "org.mozilla.javascript.NativeFunction";
    private static final String scriptSuperClassName = "org.mozilla.javascript.NativeScript";
    private String superClassName;
    private String superClassSlashName;
    private String name;
    private int ordinal;
    boolean inFunction;
    boolean inDirectCallFunction;
    private ClassFileWriter classFile;
    private short scriptRuntimeIndex;
    private int version;
    private String itsSourceFile;
    private int itsLineNumber;
    private int stackDepth;
    private int stackDepthMax;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private double[] itsConstantList;
    private int itsConstantListSize;
    private short variableObjectLocal;
    private short scriptResultLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short debug_pcLocal;
    private short debugStopSubRetLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private boolean itsUseDynamicScope;
    private boolean hasVarsInRegs;
    private boolean itsForcedObjectParameters;
    private boolean trivialInit;
    private short itsLocalAllocationBase;
    private VariableTable vars;
    private VariableTable debugVars;
    private int epilogueLabel;
    private int optLevel;
    static /* synthetic */ Class class$java$lang$Object;

    public IRFactory createIRFactory(TokenStream ts, ClassNameHelper nameHelper, Scriptable scope) {
        return new OptIRFactory(ts, nameHelper, scope);
    }

    public Node transform(Node tree, TokenStream ts, Scriptable scope) {
        OptTransformer opt = new OptTransformer(new Hashtable(11));
        return opt.transform(tree, null, ts, scope);
    }

    public Object compile(Context cx, Scriptable scope, Node tree, Object securityDomain, SecurityController securityController, ClassNameHelper cnh) {
        NativeScript script;
        String name;
        ObjArray classFiles = new ObjArray();
        ObjArray names = new ObjArray();
        String generatedName = null;
        OptClassNameHelper nameHelper = (OptClassNameHelper)cnh;
        RuntimeException e = null;
        Class result = null;
        ClassLoader parentLoader = cx.getApplicationClassLoader();
        GeneratedClassLoader loader = securityController == null ? cx.createClassLoader(parentLoader) : securityController.createClassLoader(parentLoader, securityDomain);
        nameHelper.reset();
        try {
            if (cx.getOptimizationLevel() > 0) {
                new Optimizer().optimize(tree, cx.getOptimizationLevel());
            }
            generatedName = this.generateCode(tree, names, classFiles, nameHelper);
            ClassRepository repository = nameHelper.getClassRepository();
            int i = 0;
            while (i < names.size()) {
                name = (String)names.get(i);
                byte[] classFile = (byte[])classFiles.get(i);
                boolean isTopLevel = name.equals(generatedName);
                try {
                    if (repository.storeClass(name, classFile, isTopLevel)) {
                        Class cl = loader.defineClass(name, classFile);
                        if (isTopLevel) {
                            result = cl;
                        }
                    }
                }
                catch (ClassFormatError ex) {
                    throw new RuntimeException(ex.toString());
                }
                catch (IOException iox) {
                    throw WrappedException.wrapException(iox);
                }
                ++i;
            }
            if (result != null) {
                loader.linkClass(result);
            }
        }
        catch (SecurityException x) {
            e = x;
        }
        catch (IllegalArgumentException x) {
            e = x;
        }
        if (e != null) {
            throw new RuntimeException("Malformed optimizer package " + e);
        }
        Class[] interfaces = nameHelper.getTargetImplements();
        Class superClass = nameHelper.getTargetExtends();
        if (interfaces != null || superClass != null) {
            name = nameHelper.getJavaScriptClassName(null, true);
            NativeObject obj = new NativeObject();
            Node cursor = tree.getFirstChild();
            while (cursor != null) {
                if (cursor.getType() == 110) {
                    OptFunctionNode fnNode = (OptFunctionNode)cursor.getProp(5);
                    ((ScriptableObject)obj).put(fnNode.getFunctionName(), (Scriptable)obj, (Object)fnNode);
                }
                cursor = cursor.getNext();
            }
            if (superClass == null) {
                superClass = class$java$lang$Object == null ? (class$java$lang$Object = Codegen.class$("java.lang.Object")) : class$java$lang$Object;
            }
            try {
                JavaAdapter.createAdapterClass(cx, obj, name, superClass, interfaces, generatedName, nameHelper);
            }
            catch (ClassNotFoundException exn) {
                throw new Error(exn.toString());
            }
        }
        if (result == null) {
            return null;
        }
        if (tree instanceof OptFunctionNode) {
            NativeFunction f;
            try {
                Constructor<?> ctor = result.getConstructors()[0];
                Object[] initArgs = new Object[]{scope, cx};
                f = (NativeFunction)ctor.newInstance(initArgs);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to instantiate compiled class:" + ex.toString());
            }
            OptFunctionNode fnNode = (OptFunctionNode)tree;
            OptRuntime.initFunction(f, fnNode.getFunctionType(), scope, cx);
            return f;
        }
        try {
            script = (NativeScript)result.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to instantiate compiled class:" + ex.toString());
        }
        if (scope != null) {
            script.setPrototype(ScriptableObject.getClassPrototype(scope, "Script"));
            script.setParentScope(scope);
        }
        return script;
    }

    void addByteCode(byte theOpcode) {
        this.classFile.add(theOpcode);
    }

    void addByteCode(byte theOpcode, int theOperand) {
        this.classFile.add(theOpcode, theOperand);
    }

    void addByteCode(byte theOpcode, String className) {
        this.classFile.add(theOpcode, className);
    }

    void addVirtualInvoke(String className, String methodName, String parameterSignature, String resultSignature) {
        this.classFile.add((byte)-74, className, methodName, parameterSignature, resultSignature);
    }

    void addStaticInvoke(String className, String methodName, String parameterSignature, String resultSignature) {
        this.classFile.add((byte)-72, className, methodName, parameterSignature, resultSignature);
    }

    void addScriptRuntimeInvoke(String methodName, String parameterSignature, String resultSignature) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", methodName, parameterSignature, resultSignature);
    }

    void addOptRuntimeInvoke(String methodName, String parameterSignature, String resultSignature) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", methodName, parameterSignature, resultSignature);
    }

    void addSpecialInvoke(String className, String methodName, String parameterSignature, String resultSignature) {
        this.classFile.add((byte)-73, className, methodName, parameterSignature, resultSignature);
    }

    void addDoubleConstructor() {
        this.classFile.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
    }

    private void markLabel(int label) {
        this.classFile.markLabel(label);
    }

    private void markLabel(int label, short stackheight) {
        this.classFile.markLabel(label, stackheight);
    }

    private int acquireLabel() {
        return this.classFile.acquireLabel();
    }

    public void emitDirectConstructor(OptFunctionNode fnNode) {
        short flags = 17;
        this.classFile.startMethod("constructDirect", fnNode.getDirectCallParameterSignature() + "Ljava/lang/Object;", flags);
        int argCount = fnNode.getVariableTable().getParameterCount();
        short firstLocal = (short)(4 + argCount * 3 + 1);
        this.addByteCode((byte)-69, "org/mozilla/javascript/NativeObject");
        this.addByteCode((byte)89);
        this.classFile.add((byte)-73, "org/mozilla/javascript/NativeObject", "<init>", "()", "V");
        this.astore(firstLocal);
        this.aload(firstLocal);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getClassPrototype", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload(firstLocal);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload((short)0);
        this.aload((short)1);
        this.aload((short)2);
        this.aload(firstLocal);
        int i = 0;
        while (i < argCount) {
            this.aload((short)(4 + i * 3));
            this.dload((short)(5 + i * 3));
            ++i;
        }
        this.aload((short)(4 + argCount * 3));
        this.addVirtualInvoke(this.name, "callDirect", fnNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
        this.astore((short)(firstLocal + 1));
        int exitLabel = this.acquireLabel();
        this.aload((short)(firstLocal + 1));
        this.addByteCode((byte)-58, exitLabel);
        this.aload((short)(firstLocal + 1));
        this.pushUndefined();
        this.addByteCode((byte)-91, exitLabel);
        this.aload((short)(firstLocal + 1));
        this.addByteCode((byte)-63, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-103, exitLabel);
        this.aload((short)(firstLocal + 1));
        this.addByteCode((byte)-64, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-80);
        this.markLabel(exitLabel);
        this.aload(firstLocal);
        this.addByteCode((byte)-80);
        this.classFile.stopMethod((short)(firstLocal + 2), null);
    }

    public String generateCode(Node tree, ObjArray names, ObjArray classFiles, OptClassNameHelper nameHelper) {
        Node codegenBase;
        ObjArray fns = (ObjArray)tree.getProp(5);
        if (fns != null) {
            int i = 0;
            while (i != fns.size()) {
                OptFunctionNode fn = (OptFunctionNode)fns.get(i);
                Codegen codegen = new Codegen();
                codegen.generateCode(fn, names, classFiles, nameHelper);
                ++i;
            }
        }
        Context cx = Context.getCurrentContext();
        this.itsUseDynamicScope = cx.hasCompileFunctionsWithDynamicScope();
        this.itsSourceFile = null;
        if (!cx.isGeneratingDebugChanged() || cx.isGeneratingDebug()) {
            this.itsSourceFile = (String)tree.getProp(16);
        }
        this.version = cx.getLanguageVersion();
        this.optLevel = cx.getOptimizationLevel();
        this.inFunction = tree.getType() == 110;
        this.superClassName = this.inFunction ? functionSuperClassName : scriptSuperClassName;
        this.superClassSlashName = this.superClassName.replace('.', '/');
        if (this.inFunction) {
            OptFunctionNode fnNode = (OptFunctionNode)tree;
            this.inDirectCallFunction = fnNode.isTargetOfDirectCall();
            this.vars = fnNode.getVariableTable();
            this.name = fnNode.getClassName();
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            Node args = tree.getFirstChild();
            String name = fnNode.getFunctionName();
            this.generateInit(cx, "<init>", tree, name, args);
            if (fnNode.isTargetOfDirectCall()) {
                this.classFile.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
                this.addByteCode((byte)42);
                this.addByteCode((byte)43);
                this.addByteCode((byte)44);
                this.addByteCode((byte)45);
                int i = 0;
                while (i < this.vars.getParameterCount()) {
                    this.push(i);
                    this.addByteCode((byte)25, 4);
                    this.addByteCode((byte)-66);
                    int undefArg = this.acquireLabel();
                    int beyond = this.acquireLabel();
                    this.addByteCode((byte)-94, undefArg);
                    this.addByteCode((byte)25, 4);
                    this.push(i);
                    this.addByteCode((byte)50);
                    this.push(0.0);
                    this.addByteCode((byte)-89, beyond);
                    this.markLabel(undefArg);
                    this.pushUndefined();
                    this.push(0.0);
                    this.markLabel(beyond);
                    ++i;
                }
                this.addByteCode((byte)25, 4);
                this.addVirtualInvoke(this.name, "callDirect", fnNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
                this.addByteCode((byte)-80);
                this.classFile.stopMethod((short)5, null);
                this.emitDirectConstructor(fnNode);
                this.startNewMethod("callDirect", fnNode.getDirectCallParameterSignature() + "Ljava/lang/Object;", 1, false, true);
                Codegen.assignParameterJRegs(this.vars);
                if (!fnNode.getParameterNumberContext()) {
                    this.itsForcedObjectParameters = true;
                    int i2 = 0;
                    while (i2 < this.vars.getParameterCount()) {
                        OptLocalVariable lVar = OptLocalVariable.get(this.vars, i2);
                        this.aload(lVar.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int isObjectLabel = this.acquireLabel();
                        this.addByteCode((byte)-90, isObjectLabel);
                        this.addByteCode((byte)-69, "java/lang/Double");
                        this.addByteCode((byte)89);
                        this.dload((short)(lVar.getJRegister() + 1));
                        this.addDoubleConstructor();
                        this.astore(lVar.getJRegister());
                        this.markLabel(isObjectLabel);
                        ++i2;
                    }
                }
                this.generatePrologue(cx, tree, true, this.vars.getParameterCount());
            } else {
                this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
                this.generatePrologue(cx, tree, true, -1);
            }
            codegenBase = tree.getLastChild();
        } else {
            if (tree.getType() != 146) {
                this.badTree();
            }
            this.vars = (VariableTable)tree.getProp(10);
            boolean isPrimary = nameHelper.getTargetExtends() == null && nameHelper.getTargetImplements() == null;
            this.name = nameHelper.getJavaScriptClassName(null, isPrimary);
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            this.classFile.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(cx, tree);
            this.generateMain(cx);
            this.generateInit(cx, "initScript", tree, "", null);
            this.generateExecute(cx);
            this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
            this.generatePrologue(cx, tree, false, -1);
            int linenum = tree.getIntProp(29, -1);
            if (linenum != -1) {
                this.classFile.addLineNumberEntry((short)linenum);
            }
            tree.addChildToBack(new Node(5));
            codegenBase = tree;
        }
        this.generateCodeFromNode(codegenBase, null, -1, -1);
        this.generateEpilogue();
        this.finishMethod(cx, this.debugVars);
        this.emitConstantDudeInitializers();
        byte[] bytes = this.classFile.toByteArray();
        names.add(this.name);
        classFiles.add(bytes);
        this.classFile = null;
        return this.name;
    }

    private static void assignParameterJRegs(VariableTable vars) {
        short jReg = 4;
        int parameterCount = vars.getParameterCount();
        int i = 0;
        while (i < parameterCount) {
            OptLocalVariable lVar = OptLocalVariable.get(vars, i);
            lVar.assignJRegister(jReg);
            jReg = (short)(jReg + 3);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateCodeFromNode(Node node, Node parent, int trueLabel, int falseLabel) {
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 124: 
            case 136: 
            case 138: {
                this.visitStatement(node);
                while (true) {
                    if (child == null) {
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
            }
            case 116: 
            case 117: 
            case 128: 
            case 132: 
            case 133: 
            case 146: {
                this.visitStatement(node);
                while (true) {
                    if (child == null) {
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
            }
            case 110: {
                OptFunctionNode fn;
                int t;
                if (!this.inFunction) {
                    if (parent.getType() == 146) return;
                }
                if ((t = (fn = (OptFunctionNode)node.getProp(5)).getFunctionType()) == 1) return;
                this.visitFunction(fn, t);
                return;
            }
            case 44: {
                this.visitName(node);
                return;
            }
            case 30: 
            case 43: {
                this.visitCall(node, type, child);
                return;
            }
            case 45: 
            case 46: {
                this.visitLiteral(node);
                return;
            }
            case 109: {
                this.visitPrimary(node);
                return;
            }
            case 56: {
                this.visitObject(node);
                return;
            }
            case 75: {
                this.visitTryCatchFinally(node, child);
                return;
            }
            case 62: {
                this.visitThrow(node, child);
                return;
            }
            case 5: {
                this.visitReturn(node, child);
                return;
            }
            case 115: {
                this.visitSwitch(node, child);
                return;
            }
            case 96: {
                Node next = child.getNext();
                while (true) {
                    if (next == null) {
                        this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                        return;
                    }
                    this.generateCodeFromNode(child, node, -1, -1);
                    this.addByteCode((byte)87);
                    child = next;
                    next = next.getNext();
                }
            }
            case 77: {
                this.addScriptRuntimeInvoke("newScope", "()", "Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 3: {
                this.visitEnterWith(node, child);
                return;
            }
            case 4: {
                this.visitLeaveWith(node, child);
                return;
            }
            case 79: {
                this.visitEnumInit(node, child);
                return;
            }
            case 80: {
                this.visitEnumNext(node, child);
                return;
            }
            case 139: {
                this.visitEnumDone(node, child);
                return;
            }
            case 57: {
                this.visitStatement(node);
                if (child.getType() == 73) {
                    this.visitSetVar(child, child.getFirstChild(), false);
                    return;
                }
                while (true) {
                    if (child == null) {
                        if (node.getIntProp(26, -1) == -1) break;
                        this.addByteCode((byte)88);
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
                this.addByteCode((byte)87);
                return;
            }
            case 2: {
                this.visitStatement(node);
                while (true) {
                    if (child == null) {
                        this.astore(this.scriptResultLocal);
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
            }
            case 137: {
                this.visitTarget(node);
                return;
            }
            case 6: 
            case 7: 
            case 8: 
            case 143: {
                this.visitGOTO(node, type, child);
                return;
            }
            case 105: {
                this.visitUnary(node, child, trueLabel, falseLabel);
                return;
            }
            case 32: {
                this.visitTypeof(node, child);
                return;
            }
            case 106: {
                this.visitIncDec(node, true);
                return;
            }
            case 107: {
                this.visitIncDec(node, false);
                return;
            }
            case 100: 
            case 101: {
                if (trueLabel == -1) {
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    this.addByteCode((byte)89);
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    int falseTarget = this.acquireLabel();
                    if (type == 101) {
                        this.addByteCode((byte)-103, falseTarget);
                    } else {
                        this.addByteCode((byte)-102, falseTarget);
                    }
                    this.addByteCode((byte)87);
                    this.generateCodeFromNode(child.getNext(), node, trueLabel, falseLabel);
                    this.markLabel(falseTarget);
                    return;
                }
                int interLabel = this.acquireLabel();
                if (type == 101) {
                    this.generateCodeFromNode(child, node, interLabel, falseLabel);
                    if (!Codegen.childIsBoolean(child)) {
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                        this.addByteCode((byte)-102, interLabel);
                        this.addByteCode((byte)-89, falseLabel);
                    }
                } else {
                    this.generateCodeFromNode(child, node, trueLabel, interLabel);
                    if (!Codegen.childIsBoolean(child)) {
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                        this.addByteCode((byte)-102, trueLabel);
                        this.addByteCode((byte)-89, interLabel);
                    }
                }
                this.markLabel(interLabel);
                child = child.getNext();
                this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                if (Codegen.childIsBoolean(child)) return;
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, trueLabel);
                this.addByteCode((byte)-89, falseLabel);
                return;
            }
            case 23: {
                this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                this.generateCodeFromNode(child.getNext(), node, trueLabel, falseLabel);
                switch (node.getIntProp(26, -1)) {
                    case 0: {
                        this.addByteCode((byte)99);
                        return;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)", "Ljava/lang/Object;");
                        return;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)", "Ljava/lang/Object;");
                        return;
                    }
                }
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
                return;
            }
            case 25: {
                this.visitArithmetic(node, (byte)107, child, parent);
                return;
            }
            case 24: {
                this.visitArithmetic(node, (byte)103, child, parent);
                return;
            }
            case 26: 
            case 27: {
                this.visitArithmetic(node, type == 26 ? (byte)111 : 115, child, parent);
                return;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                this.visitBitOp(node, type, child);
                return;
            }
            case 142: {
                Object toType = node.getProp(18);
                if (toType == ScriptRuntime.NumberClass) {
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addDoubleConstructor();
                    return;
                }
                if (toType == ScriptRuntime.DoubleClass) {
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    return;
                }
                if (toType != ScriptRuntime.ObjectClass) {
                    this.badTree();
                    return;
                }
                int prop = -1;
                if (child.getType() == 45) {
                    prop = child.getIntProp(26, -1);
                }
                if (prop != -1) {
                    child.removeProp(26);
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child.putIntProp(26, prop);
                    return;
                }
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                this.addDoubleConstructor();
                return;
            }
            case 103: {
                if (trueLabel == -1) {
                    this.visitRelOp(node, child, parent);
                    return;
                }
                this.visitGOTOingRelOp(node, child, parent, trueLabel, falseLabel);
                return;
            }
            case 102: {
                this.visitEqOp(node, child, parent, trueLabel, falseLabel);
                return;
            }
            case 39: {
                this.visitGetProp(node, child);
                return;
            }
            case 41: {
                while (true) {
                    if (child == null) {
                        this.aload(this.variableObjectLocal);
                        if (node.getIntProp(26, -1) == -1) break;
                        this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
                this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                return;
            }
            case 72: {
                OptLocalVariable lVar = (OptLocalVariable)node.getProp(24);
                this.visitGetVar(lVar, node.getIntProp(26, -1) != -1, node.getString());
                return;
            }
            case 73: {
                this.visitSetVar(node, child, true);
                return;
            }
            case 10: {
                this.visitSetName(node, child);
                return;
            }
            case 40: {
                this.visitSetProp(node, child);
                return;
            }
            case 42: {
                while (true) {
                    if (child == null) {
                        this.aload(this.variableObjectLocal);
                        if (node.getIntProp(26, -1) == -1) break;
                        this.addOptRuntimeInvoke("setElem", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
                this.addScriptRuntimeInvoke("setElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                return;
            }
            case 31: {
                while (true) {
                    if (child == null) {
                        this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                    child = child.getNext();
                }
            }
            case 61: 
            case 71: {
                this.visitBind(node, type, child);
                return;
            }
            case 68: {
                this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 141: {
                this.generateCodeFromNode(child, node, trueLabel, falseLabel);
                this.addScriptRuntimeInvoke("getParent", "(Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 69: {
                this.visitNewTemp(node, child);
                return;
            }
            case 70: {
                this.visitUseTemp(node, child);
                return;
            }
            case 144: {
                this.visitNewLocal(node, child);
                return;
            }
            case 145: {
                this.visitUseLocal(node, child);
                return;
            }
        }
        throw new RuntimeException("Unexpected node type " + TokenStream.tokenToName(type));
    }

    private void startNewMethod(String methodName, String methodDesc, int parmCount, boolean isStatic, boolean isFinal) {
        this.locals = new boolean[256];
        this.localsMax = (short)(parmCount + 1);
        this.firstFreeLocal = 0;
        this.contextLocal = (short)-1;
        this.variableObjectLocal = (short)-1;
        this.scriptResultLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.thisObjLocal = (short)-1;
        this.funObjLocal = (short)-1;
        this.debug_pcLocal = (short)-1;
        this.debugStopSubRetLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        short flags = 1;
        if (isStatic) {
            flags = (short)(flags | 8);
        }
        if (isFinal) {
            flags = (short)(flags | 0x10);
        }
        this.epilogueLabel = -1;
        this.classFile.startMethod(methodName, methodDesc, flags);
    }

    private void finishMethod(Context cx, VariableTable vars) {
        JavaVariable[] array = OptLocalVariable.toArray(vars);
        this.classFile.stopMethod((short)(this.localsMax + 1), array);
        this.contextLocal = (short)-1;
    }

    private void generateMain(Context cx) {
        this.startNewMethod("main", "([Ljava/lang/String;)V", 1, true, true);
        this.push(this.name);
        this.classFile.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
        this.addByteCode((byte)42);
        this.addScriptRuntimeInvoke("main", "(Ljava/lang/Class;[Ljava/lang/String;)", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(cx, null);
    }

    private void generateExecute(Context cx) {
        String signature = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        this.startNewMethod("exec", signature, 2, false, true);
        String slashName = this.name.replace('.', '/');
        if (!this.trivialInit) {
            this.addByteCode((byte)42);
            this.addByteCode((byte)44);
            this.addByteCode((byte)43);
            this.addVirtualInvoke(slashName, "initScript", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)42);
        this.addByteCode((byte)43);
        this.addByteCode((byte)44);
        this.addByteCode((byte)89);
        this.addByteCode((byte)1);
        this.addVirtualInvoke(slashName, "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        this.addByteCode((byte)-80);
        this.finishMethod(cx, null);
    }

    private void generateScriptCtor(Context cx, Node tree) {
        this.startNewMethod("<init>", "()V", 1, false, false);
        this.addByteCode((byte)42);
        this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(cx, null);
    }

    private void setNonTrivialInit(String methodName) {
        if (!this.trivialInit) {
            return;
        }
        this.trivialInit = false;
        this.startNewMethod(methodName, "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V", 1, false, false);
        this.reserveWordLocal(0);
        this.variableObjectLocal = this.reserveWordLocal(1);
        this.contextLocal = this.reserveWordLocal(2);
    }

    private void generateInit(Context cx, String methodName, Node tree, String name, Node args) {
        String source;
        OptFunctionNode fnNode;
        ObjArray regexps;
        int parmCount;
        int N;
        this.trivialInit = true;
        boolean inCtor = false;
        VariableTable vars = tree instanceof OptFunctionNode ? ((OptFunctionNode)tree).getVariableTable() : (VariableTable)tree.getProp(10);
        if (methodName.equals("<init>")) {
            inCtor = true;
            this.setNonTrivialInit(methodName);
            this.addByteCode((byte)42);
            this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
            this.addByteCode((byte)42);
            this.addByteCode((byte)43);
            this.classFile.add((byte)-75, "org/mozilla/javascript/ScriptableObject", "parent", "Lorg/mozilla/javascript/Scriptable;");
        }
        if (name.length() != 0) {
            this.setNonTrivialInit(methodName);
            this.addByteCode((byte)42);
            this.classFile.addLoadConstant(name);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "functionName", "Ljava/lang/String;");
        }
        if (vars != null && (N = vars.size()) != 0) {
            this.setNonTrivialInit(methodName);
            this.push(N);
            this.addByteCode((byte)-67, "java/lang/String");
            int i = 0;
            while (i != N) {
                this.addByteCode((byte)89);
                this.push(i);
                this.push(OptLocalVariable.get(vars, i).getName());
                this.addByteCode((byte)83);
                ++i;
            }
            this.addByteCode((byte)42);
            this.addByteCode((byte)95);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argNames", "[Ljava/lang/String;");
        }
        int n = parmCount = vars == null ? 0 : vars.getParameterCount();
        if (parmCount != 0) {
            this.setNonTrivialInit(methodName);
            this.addByteCode((byte)42);
            this.push(parmCount);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argCount", "S");
        }
        if (cx.getLanguageVersion() != 0) {
            this.setNonTrivialInit(methodName);
            this.addByteCode((byte)42);
            this.push(cx.getLanguageVersion());
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "version", "S");
        }
        if ((regexps = (ObjArray)tree.getProp(12)) != null) {
            this.setNonTrivialInit(methodName);
            this.generateRegExpLiterals(regexps, inCtor);
        }
        if (tree instanceof OptFunctionNode && (fnNode = (OptFunctionNode)tree).isTargetOfDirectCall()) {
            this.setNonTrivialInit(methodName);
            String className = fnNode.getClassName();
            String fieldName = className.replace('.', '_');
            String fieldType = 'L' + ClassFileWriter.fullyQualifiedForm(className) + ';';
            this.classFile.addField(fieldName, fieldType, (short)9);
            this.addByteCode((byte)42);
            this.classFile.add((byte)-77, className, fieldName, fieldType);
        }
        if (!this.trivialInit) {
            this.addByteCode((byte)-79);
            this.finishMethod(cx, null);
        }
        if (cx.isGeneratingSource() && (source = (String)tree.getProp(17)) != null && source.length() < 65536) {
            short flags = 9;
            String getSourceMethodStr = "getSourcesTreeImpl";
            this.classFile.startMethod(getSourceMethodStr, "()Ljava/lang/Object;", flags);
            ObjArray fns = (ObjArray)tree.getProp(5);
            if (fns == null) {
                this.push(source);
            } else {
                this.push(1 + fns.size());
                this.addByteCode((byte)-67, "java/lang/Object");
                this.addByteCode((byte)89);
                this.push(0);
                this.push(source);
                this.addByteCode((byte)83);
                int i = 0;
                while (i != fns.size()) {
                    this.addByteCode((byte)89);
                    this.push(1 + i);
                    OptFunctionNode fn = (OptFunctionNode)fns.get(i);
                    this.classFile.add((byte)-72, fn.getClassName(), getSourceMethodStr, "()", "Ljava/lang/Object;");
                    this.addByteCode((byte)83);
                    ++i;
                }
            }
            this.addByteCode((byte)-80);
            this.classFile.stopMethod((short)0, null);
        }
    }

    private void generateRegExpLiterals(ObjArray regexps, boolean inCtor) {
        int i = 0;
        while (i < regexps.size()) {
            Node regexp = (Node)regexps.get(i);
            StringBuffer sb = new StringBuffer("_re");
            sb.append(i);
            String fieldName = sb.toString();
            short flags = 2;
            if (inCtor) {
                flags = (short)(flags | 0x10);
            }
            this.classFile.addField(fieldName, "Lorg/mozilla/javascript/regexp/NativeRegExp;", flags);
            this.addByteCode((byte)42);
            this.addByteCode((byte)-69, "org/mozilla/javascript/regexp/NativeRegExp");
            this.addByteCode((byte)89);
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            Node left = regexp.getFirstChild();
            this.push(left.getString());
            Node right = regexp.getLastChild();
            if (left == right) {
                this.addByteCode((byte)1);
            } else {
                this.push(right.getString());
            }
            this.push(0);
            this.addSpecialInvoke("org/mozilla/javascript/regexp/NativeRegExp", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Ljava/lang/String;Z)", "V");
            regexp.putProp(12, fieldName);
            this.classFile.add((byte)-75, ClassFileWriter.fullyQualifiedForm(this.name), fieldName, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
            ++i;
        }
    }

    private void generatePrologue(Context cx, Node tree, boolean inFunction, int directParameterCount) {
        String debugVariableName;
        int i;
        this.funObjLocal = this.reserveWordLocal(0);
        this.contextLocal = this.reserveWordLocal(1);
        this.variableObjectLocal = this.reserveWordLocal(2);
        this.thisObjLocal = this.reserveWordLocal(3);
        if (inFunction && !this.itsUseDynamicScope && directParameterCount == -1) {
            this.aload(this.funObjLocal);
            this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.variableObjectLocal);
        }
        if (directParameterCount > 0) {
            int i2 = 0;
            while (i2 < 3 * directParameterCount) {
                this.reserveWordLocal(i2 + 4);
                ++i2;
            }
        }
        this.argsLocal = this.reserveWordLocal(directParameterCount <= 0 ? 4 : 3 * directParameterCount + 4);
        int localCount = tree.getIntProp(22, 0);
        if (localCount != 0) {
            this.itsLocalAllocationBase = (short)(this.argsLocal + 1);
            i = 0;
            while (i < localCount) {
                this.reserveWordLocal(this.itsLocalAllocationBase + i);
                ++i;
            }
        }
        if (inFunction && ((OptFunctionNode)tree).getCheckThis()) {
            this.aload(this.thisObjLocal);
            this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.thisObjLocal);
        }
        boolean bl = this.hasVarsInRegs = inFunction && !((OptFunctionNode)tree).requiresActivation();
        if (this.hasVarsInRegs) {
            int parmCount = this.vars.getParameterCount();
            if (inFunction && parmCount > 0 && directParameterCount < 0) {
                this.aload(this.argsLocal);
                this.addByteCode((byte)-66);
                this.push(parmCount);
                int label = this.acquireLabel();
                this.addByteCode((byte)-94, label);
                this.aload(this.argsLocal);
                this.push(parmCount);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
                this.astore(this.argsLocal);
                this.markLabel(label);
            }
            short firstUndefVar = -1;
            int i3 = 0;
            while (i3 < this.vars.size()) {
                OptLocalVariable lVar = OptLocalVariable.get(this.vars, i3);
                if (lVar.isNumber()) {
                    lVar.assignJRegister(this.getNewWordPairLocal());
                    this.push(0.0);
                    this.dstore(lVar.getJRegister());
                } else if (lVar.isParameter()) {
                    if (directParameterCount < 0) {
                        lVar.assignJRegister(this.getNewWordLocal());
                        this.aload(this.argsLocal);
                        this.push(i3);
                        this.addByteCode((byte)50);
                        this.astore(lVar.getJRegister());
                    }
                } else {
                    lVar.assignJRegister(this.getNewWordLocal());
                    if (firstUndefVar == -1) {
                        this.pushUndefined();
                        firstUndefVar = lVar.getJRegister();
                    } else {
                        this.aload(firstUndefVar);
                    }
                    this.astore(lVar.getJRegister());
                }
                lVar.setStartPC(this.classFile.getCurrentCodeOffset());
                ++i3;
            }
            this.debugVars = this.vars;
            return;
        }
        if (directParameterCount > 0) {
            this.aload(this.argsLocal);
            this.push(directParameterCount);
            this.addOptRuntimeInvoke("padStart", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
            this.astore(this.argsLocal);
            i = 0;
            while (i < directParameterCount) {
                this.aload(this.argsLocal);
                this.push(i);
                this.aload((short)(3 * i + 4));
                this.addByteCode((byte)83);
                ++i;
            }
        }
        if (inFunction) {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.aload(this.argsLocal);
            this.addScriptRuntimeInvoke("initVarObj", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
            debugVariableName = "activation";
        } else {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.push(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Z)", "Lorg/mozilla/javascript/Scriptable;");
            debugVariableName = "global";
        }
        this.astore(this.variableObjectLocal);
        ObjArray fns = (ObjArray)tree.getProp(5);
        if (fns != null) {
            int i4 = 0;
            while (i4 < fns.size()) {
                OptFunctionNode fn = (OptFunctionNode)fns.get(i4);
                if (fn.getFunctionType() == 1) {
                    this.visitFunction(fn, 1);
                    this.addByteCode((byte)87);
                }
                ++i4;
            }
        }
        if (!cx.isGeneratingDebugChanged() || cx.isGeneratingDebug()) {
            OptLocalVariable lv = new OptLocalVariable(debugVariableName, false);
            lv.assignJRegister(this.variableObjectLocal);
            lv.setStartPC(this.classFile.getCurrentCodeOffset());
            this.debugVars = new VariableTable();
            this.debugVars.addLocal(debugVariableName, lv);
        }
        if (!inFunction) {
            this.scriptResultLocal = this.getNewWordLocal();
            this.pushUndefined();
            this.astore(this.scriptResultLocal);
        }
        if (inFunction && ((OptFunctionNode)tree).containsCalls(-1)) {
            if (((OptFunctionNode)tree).containsCalls(0)) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.classFile.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.astore(this.itsZeroArgArray);
            }
            if (((OptFunctionNode)tree).containsCalls(1)) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.push(1);
                this.addByteCode((byte)-67, "java/lang/Object");
                this.astore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.epilogueLabel != -1) {
            this.classFile.markLabel(this.epilogueLabel);
        }
        if (!this.hasVarsInRegs || !this.inFunction) {
            this.aload(this.contextLocal);
            this.addScriptRuntimeInvoke("popActivation", "(Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)-80);
    }

    private void visitFunction(OptFunctionNode fn, int functionType) {
        String fnClassName = fn.getClassName();
        this.addByteCode((byte)-69, fnClassName);
        this.addByteCode((byte)89);
        this.aload(this.variableObjectLocal);
        this.aload(this.contextLocal);
        this.addSpecialInvoke(fnClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
        this.addByteCode((byte)89);
        this.push(functionType);
        this.aload(this.variableObjectLocal);
        this.aload(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
    }

    private void visitTarget(Node node) {
        int label = node.getIntProp(20, -1);
        if (label == -1) {
            label = this.acquireLabel();
            node.putIntProp(20, label);
        }
        this.markLabel(label);
    }

    /*
     * Unable to fully structure code
     */
    private void visitGOTO(Node node, int type, Node child) {
        block14: {
            block13: {
                target = (Node)node.getProp(1);
                targetLabel = target.getIntProp(20, -1);
                if (targetLabel == -1) {
                    targetLabel = this.acquireLabel();
                    target.putIntProp(20, targetLabel);
                }
                fallThruLabel = this.acquireLabel();
                if (type != 7 && type != 8) ** GOTO lbl29
                if (child != null) break block13;
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                if (type == 7) {
                    this.addByteCode((byte)-102, targetLabel);
                } else {
                    this.addByteCode((byte)-103, targetLabel);
                }
                break block14;
            }
            if (type == 7) {
                this.generateCodeFromNode(child, node, targetLabel, fallThruLabel);
            } else {
                this.generateCodeFromNode(child, node, fallThruLabel, targetLabel);
            }
            if (Codegen.childIsBoolean(child)) break block14;
            this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
            if (type == 7) {
                this.addByteCode((byte)-102, targetLabel);
            } else {
                this.addByteCode((byte)-103, targetLabel);
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                this.generateCodeFromNode(child, node, -1, -1);
                child = child.getNext();
lbl29:
                // 2 sources

                ** while (child != null)
            }
lbl30:
            // 1 sources

            if (type == 143) {
                this.addByteCode((byte)-88, targetLabel);
            } else {
                this.addByteCode((byte)-89, targetLabel);
            }
        }
        this.markLabel(fallThruLabel);
    }

    private void visitEnumInit(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("initEnum", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        short x = this.getNewWordLocal();
        this.astore(x);
        node.putIntProp(7, x);
    }

    private void visitEnumNext(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        Node init = (Node)node.getProp(4);
        int local = init.getExistingIntProp(7);
        this.aload((short)local);
        this.addScriptRuntimeInvoke("nextEnum", "(Ljava/lang/Object;)", "Ljava/lang/Object;");
    }

    private void visitEnumDone(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        Node init = (Node)node.getProp(4);
        int local = init.getExistingIntProp(7);
        this.releaseWordLocal((short)local);
    }

    private void visitEnterWith(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void visitLeaveWith(Node node, Node child) {
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void resetTargets(Node node) {
        if (node.getType() == 137) {
            node.removeProp(20);
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.resetTargets(child);
            child = child.getNext();
        }
    }

    private void visitCall(Node node, int type, Node child) {
        Node chelsea = child;
        OptFunctionNode target = (OptFunctionNode)node.getProp(27);
        if (target != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            int regularCall = this.acquireLabel();
            String className = ClassFileWriter.fullyQualifiedForm(target.getClassName());
            String fieldName = className.replace('/', '_');
            this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(className), fieldName, "L" + className + ";");
            short stackHeight = this.classFile.getStackTop();
            this.addByteCode((byte)92);
            this.addByteCode((byte)-90, regularCall);
            this.addByteCode((byte)95);
            this.addByteCode((byte)87);
            if (!this.itsUseDynamicScope) {
                this.addByteCode((byte)89);
                this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            } else {
                this.aload(this.variableObjectLocal);
            }
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
            if (type == 30) {
                this.addByteCode((byte)1);
            } else {
                child = child.getNext();
                this.generateCodeFromNode(child, node, -1, -1);
            }
            child = child.getNext();
            while (child != null) {
                OptLocalVariable lVar;
                boolean handled = false;
                if (child.getType() == 72 && this.inDirectCallFunction && (lVar = (OptLocalVariable)child.getProp(24)) != null && lVar.isParameter()) {
                    handled = true;
                    this.aload(lVar.getJRegister());
                    this.dload((short)(lVar.getJRegister() + 1));
                }
                if (!handled) {
                    int childNumberFlag = child.getIntProp(26, -1);
                    if (childNumberFlag == 0) {
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.generateCodeFromNode(child, node, -1, -1);
                    } else {
                        this.generateCodeFromNode(child, node, -1, -1);
                        this.push(0.0);
                    }
                }
                this.resetTargets(child);
                child = child.getNext();
            }
            this.classFile.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            if (type == 30) {
                this.addVirtualInvoke(target.getClassName(), "constructDirect", target.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            } else {
                this.addVirtualInvoke(target.getClassName(), "callDirect", target.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            }
            int beyond = this.acquireLabel();
            this.addByteCode((byte)-89, beyond);
            this.markLabel(regularCall, stackHeight);
            this.addByteCode((byte)87);
            this.visitRegularCall(node, type, chelsea, true);
            this.markLabel(beyond);
        } else {
            this.visitRegularCall(node, type, chelsea, false);
        }
    }

    private String getSimpleCallName(Node callNode) {
        Node callBaseChild;
        Node callBase = callNode.getFirstChild();
        if (callBase.getType() == 39 && (callBaseChild = callBase.getFirstChild()).getType() == 69) {
            Node callBaseID = callBaseChild.getNext();
            Node tempChild = callBaseChild.getFirstChild();
            if (tempChild.getType() == 71) {
                Node temp;
                Node useChild;
                Node thisChild;
                String functionName = tempChild.getString();
                if (callBaseID != null && callBaseID.getType() == 46 && functionName.equals(callBaseID.getString()) && (thisChild = callBase.getNext()).getType() == 68 && (useChild = thisChild.getFirstChild()).getType() == 70 && (temp = (Node)useChild.getProp(6)) == callBaseChild) {
                    return functionName;
                }
            }
        }
        return null;
    }

    private void constructArgArray(int argCount) {
        if (argCount == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.aload(this.itsZeroArgArray);
            } else {
                this.push(0);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else if (argCount == 1) {
            if (this.itsOneArgArray >= 0) {
                this.aload(this.itsOneArgArray);
            } else {
                this.push(1);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else {
            this.push(argCount);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
    }

    private void visitRegularCall(Node node, int type, Node child, boolean firstArgDone) {
        String callSignature;
        String methodNameCall;
        String methodNameNewObj;
        String className;
        OptFunctionNode target = (OptFunctionNode)node.getProp(27);
        Node chelsea = child;
        int childCount = 0;
        int argSkipCount = type == 30 ? 1 : 2;
        while (child != null) {
            ++childCount;
            child = child.getNext();
        }
        child = chelsea;
        int argIndex = -argSkipCount;
        if (firstArgDone && child != null) {
            child = child.getNext();
            ++argIndex;
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
        } else {
            this.aload(this.contextLocal);
        }
        if (firstArgDone && type == 30) {
            this.constructArgArray(childCount - argSkipCount);
        }
        boolean isSpecialCall = node.getProp(30) != null;
        boolean isSimpleCall = false;
        String simpleCallName = null;
        if (type != 30 && (simpleCallName = this.getSimpleCallName(node)) != null && !isSpecialCall) {
            isSimpleCall = true;
            this.push(simpleCallName);
            this.aload(this.variableObjectLocal);
            child = child.getNext().getNext();
            argIndex = 0;
            this.push(childCount - argSkipCount);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
        while (child != null) {
            if (argIndex < 0) {
                this.generateCodeFromNode(child, node, -1, -1);
            } else {
                this.addByteCode((byte)89);
                this.push(argIndex);
                if (target != null) {
                    OptLocalVariable lVar;
                    boolean handled = false;
                    if (child.getType() == 72 && this.inDirectCallFunction && (lVar = (OptLocalVariable)child.getProp(24)) != null && lVar.isParameter()) {
                        child.removeProp(26);
                        this.generateCodeFromNode(child, node, -1, -1);
                        handled = true;
                    }
                    if (!handled) {
                        int childNumberFlag = child.getIntProp(26, -1);
                        if (childNumberFlag == 0) {
                            this.addByteCode((byte)-69, "java/lang/Double");
                            this.addByteCode((byte)89);
                            this.generateCodeFromNode(child, node, -1, -1);
                            this.addDoubleConstructor();
                        } else {
                            this.generateCodeFromNode(child, node, -1, -1);
                        }
                    }
                } else {
                    this.generateCodeFromNode(child, node, -1, -1);
                }
                this.addByteCode((byte)83);
            }
            if (++argIndex == 0) {
                this.constructArgArray(childCount - argSkipCount);
            }
            child = child.getNext();
        }
        if (isSpecialCall) {
            className = "org/mozilla/javascript/ScriptRuntime";
            methodNameNewObj = "newObjectSpecial";
            methodNameCall = "callSpecial";
            if (type != 30) {
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;I)";
                this.aload(this.thisObjLocal);
                this.aload(this.variableObjectLocal);
                this.push(this.itsSourceFile == null ? "" : this.itsSourceFile);
                this.push(this.itsLineNumber);
            } else {
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                this.aload(this.variableObjectLocal);
            }
        } else {
            methodNameNewObj = "newObject";
            if (isSimpleCall) {
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)";
                methodNameCall = "callSimple";
                className = "org/mozilla/javascript/optimizer/OptRuntime";
            } else {
                this.aload(this.variableObjectLocal);
                callSignature = type == 30 ? "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)" : "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                methodNameCall = "call";
                className = "org/mozilla/javascript/ScriptRuntime";
            }
        }
        if (type == 30) {
            this.addStaticInvoke(className, methodNameNewObj, callSignature, "Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.addStaticInvoke(className, methodNameCall, callSignature, "Ljava/lang/Object;");
        }
    }

    private void visitStatement(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.classFile.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node node, Node child) {
        short savedVariableObject = this.getNewWordLocal();
        this.aload(this.variableObjectLocal);
        this.astore(savedVariableObject);
        int startLabel = this.acquireLabel();
        this.markLabel(startLabel, (short)1);
        this.visitStatement(node);
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        Node catchTarget = (Node)node.getProp(1);
        Node finallyTarget = (Node)node.getProp(21);
        int realEnd = this.acquireLabel();
        this.addByteCode((byte)-89, realEnd);
        if (catchTarget != null) {
            int catchLabel = catchTarget.getExistingIntProp(20);
            this.generateCatchBlock(0, savedVariableObject, catchLabel, startLabel);
            this.generateCatchBlock(1, savedVariableObject, catchLabel, startLabel);
            int jsHandler = this.acquireLabel();
            this.classFile.markHandler(jsHandler);
            short exceptionObject = this.getNewWordLocal();
            this.astore(exceptionObject);
            this.aload(savedVariableObject);
            this.astore(this.variableObjectLocal);
            this.aload(exceptionObject);
            this.addVirtualInvoke("org/mozilla/javascript/EcmaError", "getErrorObject", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.releaseWordLocal(exceptionObject);
            this.addByteCode((byte)-89, catchLabel);
            this.classFile.addExceptionHandler(startLabel, catchLabel, jsHandler, "org/mozilla/javascript/EcmaError");
        }
        if (finallyTarget != null) {
            int finallyHandler = this.acquireLabel();
            this.classFile.markHandler(finallyHandler);
            this.aload(savedVariableObject);
            this.astore(this.variableObjectLocal);
            short s = this.itsLocalAllocationBase;
            this.itsLocalAllocationBase = (short)(s + 1);
            short exnLocal = s;
            this.astore(exnLocal);
            int finallyLabel = finallyTarget.getExistingIntProp(20);
            this.addByteCode((byte)-88, finallyLabel);
            this.aload(exnLocal);
            this.addByteCode((byte)-65);
            this.classFile.addExceptionHandler(startLabel, finallyLabel, finallyHandler, null);
        }
        this.releaseWordLocal(savedVariableObject);
        this.markLabel(realEnd);
    }

    private void generateCatchBlock(int exceptionType, short savedVariableObject, int catchLabel, int startLabel) {
        int handler = this.acquireLabel();
        this.classFile.markHandler(handler);
        short exceptionObject = this.getNewWordLocal();
        this.astore(exceptionObject);
        this.aload(savedVariableObject);
        this.astore(this.variableObjectLocal);
        this.aload(exceptionObject);
        this.releaseWordLocal(exceptionObject);
        if (exceptionType == 0) {
            this.addScriptRuntimeInvoke("unwrapJavaScriptException", "(Lorg/mozilla/javascript/JavaScriptException;)", "Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("unwrapWrappedException", "(Lorg/mozilla/javascript/WrappedException;)", "Ljava/lang/Object;");
        }
        String exceptionName = exceptionType == 0 ? "org/mozilla/javascript/JavaScriptException" : "org/mozilla/javascript/WrappedException";
        this.classFile.addExceptionHandler(startLabel, catchLabel, handler, exceptionName);
        this.addByteCode((byte)-89, catchLabel);
    }

    private void visitThrow(Node node, Node child) {
        this.visitStatement(node);
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        this.addByteCode((byte)-69, "org/mozilla/javascript/JavaScriptException");
        this.addByteCode((byte)90);
        this.addByteCode((byte)95);
        this.addSpecialInvoke("org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;)", "V");
        this.addByteCode((byte)-65);
    }

    private void visitReturn(Node node, Node child) {
        this.visitStatement(node);
        if (child != null) {
            do {
                this.generateCodeFromNode(child, node, -1, -1);
            } while ((child = child.getNext()) != null);
        } else if (this.inFunction) {
            this.pushUndefined();
        } else {
            this.aload(this.scriptResultLocal);
        }
        if (this.epilogueLabel == -1) {
            this.epilogueLabel = this.classFile.acquireLabel();
        }
        this.addByteCode((byte)-89, this.epilogueLabel);
    }

    private void visitSwitch(Node node, Node child) {
        this.visitStatement(node);
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        short selector = this.getNewWordLocal();
        this.astore(selector);
        ObjArray cases = (ObjArray)node.getProp(13);
        int i = 0;
        while (i < cases.size()) {
            Node thisCase = (Node)cases.get(i);
            Node first = thisCase.getFirstChild();
            this.generateCodeFromNode(first, thisCase, -1, -1);
            this.aload(selector);
            this.addScriptRuntimeInvoke("seqB", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            Node target = new Node(137);
            thisCase.replaceChild(first, target);
            this.generateGOTO(7, target);
            ++i;
        }
        Node defaultNode = (Node)node.getProp(14);
        if (defaultNode != null) {
            Node defaultTarget = new Node(137);
            defaultNode.getFirstChild().addChildToFront(defaultTarget);
            this.generateGOTO(6, defaultTarget);
        }
        Node breakTarget = (Node)node.getProp(2);
        this.generateGOTO(6, breakTarget);
    }

    private void generateGOTO(int type, Node target) {
        Node GOTO = new Node(type);
        GOTO.putProp(1, target);
        this.visitGOTO(GOTO, type, null);
    }

    private void visitUnary(Node node, Node child, int trueGOTO, int falseGOTO) {
        int op = node.getOperation();
        switch (op) {
            case 129: {
                if (trueGOTO != -1) {
                    this.generateCodeFromNode(child, node, falseGOTO, trueGOTO);
                    if (Codegen.childIsBoolean(child)) break;
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-102, falseGOTO);
                    this.addByteCode((byte)-89, trueGOTO);
                    break;
                }
                int trueTarget = this.acquireLabel();
                int falseTarget = this.acquireLabel();
                int beyond = this.acquireLabel();
                this.generateCodeFromNode(child, node, trueTarget, falseTarget);
                if (!Codegen.childIsBoolean(child)) {
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-103, falseTarget);
                    this.addByteCode((byte)-89, trueTarget);
                }
                this.markLabel(trueTarget);
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.addByteCode((byte)-89, beyond);
                this.markLabel(falseTarget);
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.markLabel(beyond);
                this.classFile.adjustStackTop(-1);
                break;
            }
            case 32: {
                this.visitTypeof(node, child);
                break;
            }
            case 132: {
                this.generateCodeFromNode(child, node, -1, -1);
                this.addByteCode((byte)87);
                this.pushUndefined();
                break;
            }
            case 28: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(child, node, -1, -1);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
                this.push(-1);
                this.addByteCode((byte)-126);
                this.addByteCode((byte)-121);
                this.addDoubleConstructor();
                break;
            }
            case 23: 
            case 24: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(child, node, -1, -1);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                if (op == 24) {
                    this.addByteCode((byte)119);
                }
                this.addDoubleConstructor();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private static boolean childIsBoolean(Node child) {
        switch (child.getType()) {
            case 105: {
                return child.getOperation() == 129;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return true;
            }
        }
        return false;
    }

    private void visitTypeof(Node node, Node child) {
        OptLocalVariable lVar;
        if (node.getType() == 105) {
            this.generateCodeFromNode(child, node, -1, -1);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        String name = node.getString();
        if (this.hasVarsInRegs && (lVar = OptLocalVariable.get(this.vars, name)) != null) {
            if (lVar.isNumber()) {
                this.push("number");
                return;
            }
            this.visitGetVar(lVar, false, name);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(name);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/String;");
    }

    private void visitIncDec(Node node, boolean isInc) {
        Node child = node.getFirstChild();
        if (node.getIntProp(26, -1) != -1) {
            OptLocalVariable lVar = (OptLocalVariable)child.getProp(24);
            if (lVar.getJRegister() == -1) {
                lVar.assignJRegister(this.getNewWordPairLocal());
            }
            this.dload(lVar.getJRegister());
            this.addByteCode((byte)92);
            this.push(1.0);
            this.addByteCode(isInc ? (byte)99 : 103);
            this.dstore(lVar.getJRegister());
        } else {
            String routine;
            OptLocalVariable lVar = (OptLocalVariable)child.getProp(24);
            String string = routine = isInc ? "postIncrement" : "postDecrement";
            if (this.hasVarsInRegs && child.getType() == 72) {
                if (lVar == null) {
                    lVar = OptLocalVariable.get(this.vars, child.getString());
                }
                if (lVar.getJRegister() == -1) {
                    lVar.assignJRegister(this.getNewWordLocal());
                }
                this.aload(lVar.getJRegister());
                this.addByteCode((byte)89);
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;)", "Ljava/lang/Object;");
                this.astore(lVar.getJRegister());
            } else if (child.getType() == 39) {
                Node getPropChild = child.getFirstChild();
                this.generateCodeFromNode(getPropChild, node, -1, -1);
                this.generateCodeFromNode(getPropChild.getNext(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else if (child.getType() == 41) {
                routine = routine + "Elem";
                Node getPropChild = child.getFirstChild();
                this.generateCodeFromNode(getPropChild, node, -1, -1);
                this.generateCodeFromNode(getPropChild.getNext(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.push(child.getString());
                this.addScriptRuntimeInvoke(routine, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
            }
        }
    }

    private boolean isArithmeticNode(Node node) {
        int type = node.getType();
        return type == 24 || type == 27 || type == 26 || type == 25;
    }

    private void visitArithmetic(Node node, byte opCode, Node child, Node parent) {
        int childNumberFlag = node.getIntProp(26, -1);
        if (childNumberFlag != -1) {
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.addByteCode(opCode);
        } else {
            boolean childOfArithmetic = this.isArithmeticNode(parent);
            if (!childOfArithmetic) {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
            }
            this.generateCodeFromNode(child, node, -1, -1);
            if (!this.isArithmeticNode(child)) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            if (!this.isArithmeticNode(child.getNext())) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.addByteCode(opCode);
            if (!childOfArithmetic) {
                this.addDoubleConstructor();
            }
        }
    }

    private void visitBitOp(Node node, int type, Node child) {
        int childNumberFlag = node.getIntProp(26, -1);
        if (childNumberFlag == -1) {
            this.addByteCode((byte)-69, "java/lang/Double");
            this.addByteCode((byte)89);
        }
        this.generateCodeFromNode(child, node, -1, -1);
        if (type == 22) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)", "J");
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.push(31);
            this.addByteCode((byte)126);
            this.addByteCode((byte)125);
            this.addByteCode((byte)-118);
            this.addDoubleConstructor();
            return;
        }
        if (childNumberFlag == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
        }
        switch (type) {
            case 11: {
                this.addByteCode((byte)-128);
                break;
            }
            case 12: {
                this.addByteCode((byte)-126);
                break;
            }
            case 13: {
                this.addByteCode((byte)126);
                break;
            }
            case 21: {
                this.addByteCode((byte)122);
                break;
            }
            case 20: {
                this.addByteCode((byte)120);
                break;
            }
            default: {
                this.badTree();
            }
        }
        this.addByteCode((byte)-121);
        if (childNumberFlag == -1) {
            this.addDoubleConstructor();
        }
    }

    private boolean nodeIsDirectCallParameter(Node node) {
        OptLocalVariable lVar;
        return node.getType() == 72 && (lVar = (OptLocalVariable)node.getProp(24)) != null && lVar.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int op, int trueGOTO, int falseGOTO) {
        switch (op) {
            case 17: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-98, trueGOTO);
                break;
            }
            case 19: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-100, trueGOTO);
                break;
            }
            case 16: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-101, trueGOTO);
                break;
            }
            case 18: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-99, trueGOTO);
            }
        }
        if (falseGOTO != -1) {
            this.addByteCode((byte)-89, falseGOTO);
        }
    }

    private void visitGOTOingRelOp(Node node, Node child, Node parent, int trueGOTO, int falseGOTO) {
        int op = node.getOperation();
        int childNumberFlag = node.getIntProp(26, -1);
        if (childNumberFlag == 0) {
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.genSimpleCompare(op, trueGOTO, falseGOTO);
        } else if (op == 64) {
            this.aload(this.variableObjectLocal);
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
            this.addByteCode((byte)-102, trueGOTO);
            this.addByteCode((byte)-89, falseGOTO);
        } else if (op == 63) {
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
            this.addByteCode((byte)-102, trueGOTO);
            this.addByteCode((byte)-89, falseGOTO);
        } else {
            Node rChild = child.getNext();
            boolean leftIsDCP = this.nodeIsDirectCallParameter(child);
            boolean rightIsDCP = this.nodeIsDirectCallParameter(rChild);
            if (leftIsDCP || rightIsDCP) {
                int notNumbersLabel;
                if (leftIsDCP) {
                    OptLocalVariable lVar1;
                    if (rightIsDCP) {
                        lVar1 = (OptLocalVariable)child.getProp(24);
                        this.aload(lVar1.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        notNumbersLabel = this.acquireLabel();
                        this.addByteCode((byte)-90, notNumbersLabel);
                        OptLocalVariable lVar2 = (OptLocalVariable)rChild.getProp(24);
                        this.aload(lVar2.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.addByteCode((byte)-90, notNumbersLabel);
                        this.dload((short)(lVar1.getJRegister() + 1));
                        this.dload((short)(lVar2.getJRegister() + 1));
                        this.genSimpleCompare(op, trueGOTO, falseGOTO);
                        this.markLabel(notNumbersLabel);
                    } else if (childNumberFlag == 2) {
                        lVar1 = (OptLocalVariable)child.getProp(24);
                        this.aload(lVar1.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        notNumbersLabel = this.acquireLabel();
                        this.addByteCode((byte)-90, notNumbersLabel);
                        this.dload((short)(lVar1.getJRegister() + 1));
                        this.generateCodeFromNode(rChild, node, -1, -1);
                        this.genSimpleCompare(op, trueGOTO, falseGOTO);
                        this.markLabel(notNumbersLabel);
                    }
                } else if (childNumberFlag == 1) {
                    OptLocalVariable lVar2 = (OptLocalVariable)rChild.getProp(24);
                    this.aload(lVar2.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    notNumbersLabel = this.acquireLabel();
                    this.addByteCode((byte)-90, notNumbersLabel);
                    this.generateCodeFromNode(child, node, -1, -1);
                    this.dload((short)(lVar2.getJRegister() + 1));
                    this.genSimpleCompare(op, trueGOTO, falseGOTO);
                    this.markLabel(notNumbersLabel);
                }
            }
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(rChild, node, -1, -1);
            if (childNumberFlag == -1) {
                if (op == 19 || op == 18) {
                    this.addByteCode((byte)95);
                }
                String routine = op == 16 || op == 18 ? "cmp_LT" : "cmp_LE";
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;)", "I");
            } else {
                String routine;
                boolean doubleThenObject;
                boolean bl = doubleThenObject = childNumberFlag == 1;
                if (op == 19 || op == 18) {
                    if (doubleThenObject) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        doubleThenObject = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        doubleThenObject = true;
                    }
                }
                String string = routine = op == 16 || op == 18 ? "cmp_LT" : "cmp_LE";
                if (doubleThenObject) {
                    this.addOptRuntimeInvoke(routine, "(DLjava/lang/Object;)", "I");
                } else {
                    this.addOptRuntimeInvoke(routine, "(Ljava/lang/Object;D)", "I");
                }
            }
            this.addByteCode((byte)-102, trueGOTO);
            this.addByteCode((byte)-89, falseGOTO);
        }
    }

    private void visitRelOp(Node node, Node child, Node parent) {
        int op = node.getOperation();
        int childNumberFlag = node.getIntProp(26, -1);
        if (childNumberFlag == 0 || op == 64 || op == 63) {
            if (op == 64) {
                this.aload(this.variableObjectLocal);
            }
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            int trueGOTO = this.acquireLabel();
            int skip = this.acquireLabel();
            if (op == 64) {
                this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, trueGOTO);
            } else if (op == 63) {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
                this.addByteCode((byte)-102, trueGOTO);
            } else {
                this.genSimpleCompare(op, trueGOTO, -1);
            }
            this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.addByteCode((byte)-89, skip);
            this.markLabel(trueGOTO);
            this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.markLabel(skip);
            this.classFile.adjustStackTop(-1);
        } else {
            String routine = op == 16 || op == 18 ? "cmp_LTB" : "cmp_LEB";
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            if (childNumberFlag == -1) {
                if (op == 19 || op == 18) {
                    this.addByteCode((byte)95);
                }
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            } else {
                boolean doubleThenObject;
                boolean bl = doubleThenObject = childNumberFlag == 1;
                if (op == 19 || op == 18) {
                    if (doubleThenObject) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        doubleThenObject = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        doubleThenObject = true;
                    }
                }
                if (doubleThenObject) {
                    this.addOptRuntimeInvoke(routine, "(DLjava/lang/Object;)", "Ljava/lang/Boolean;");
                } else {
                    this.addOptRuntimeInvoke(routine, "(Ljava/lang/Object;D)", "Ljava/lang/Boolean;");
                }
            }
        }
    }

    private Node getConvertToObjectOfNumberNode(Node node) {
        Node convertChild;
        Object toType;
        if (node.getType() == 142 && (toType = node.getProp(18)) == ScriptRuntime.ObjectClass && (convertChild = node.getFirstChild()).getType() == 45) {
            return convertChild;
        }
        return null;
    }

    private void visitEqOp(Node node, Node child, Node parent, int trueGOTO, int falseGOTO) {
        boolean isStrict;
        int op = node.getOperation();
        Node rightChild = child.getNext();
        boolean bl = isStrict = op == 53 || op == 54;
        if (trueGOTO == -1) {
            String name;
            if (rightChild.getType() == 109 && rightChild.getOperation() == 49) {
                this.generateCodeFromNode(child, node, -1, -1);
                if (isStrict) {
                    this.addByteCode((byte)-58, 9);
                } else {
                    this.addByteCode((byte)89);
                    this.addByteCode((byte)-58, 15);
                    this.pushUndefined();
                    this.addByteCode((byte)-91, 10);
                }
                if (op == 14 || op == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                }
                if (isStrict) {
                    this.addByteCode((byte)-89, 6);
                } else {
                    this.addByteCode((byte)-89, 7);
                    this.addByteCode((byte)87);
                }
                if (op == 14 || op == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                }
                return;
            }
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            switch (op) {
                case 14: {
                    name = this.version == 120 ? "seqB" : "eqB";
                    break;
                }
                case 15: {
                    name = this.version == 120 ? "sneB" : "neB";
                    break;
                }
                case 53: {
                    name = "seqB";
                    break;
                }
                case 54: {
                    name = "sneB";
                    break;
                }
                default: {
                    name = null;
                    this.badTree();
                }
            }
            this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
        } else {
            Node convertChild;
            if (rightChild.getType() == 109 && rightChild.getOperation() == 49) {
                boolean simpleChild;
                if (op != 14 && op != 53) {
                    int temp = trueGOTO;
                    trueGOTO = falseGOTO;
                    falseGOTO = temp;
                }
                this.generateCodeFromNode(child, node, -1, -1);
                if (isStrict) {
                    this.addByteCode((byte)-58, trueGOTO);
                    this.addByteCode((byte)-89, falseGOTO);
                    return;
                }
                boolean bl2 = simpleChild = child.getType() == 72;
                if (!simpleChild) {
                    this.addByteCode((byte)89);
                }
                int popGOTO = this.acquireLabel();
                this.addByteCode((byte)-58, simpleChild ? trueGOTO : popGOTO);
                short popStack = this.classFile.getStackTop();
                if (simpleChild) {
                    this.generateCodeFromNode(child, node, -1, -1);
                }
                this.pushUndefined();
                this.addByteCode((byte)-91, trueGOTO);
                this.addByteCode((byte)-89, falseGOTO);
                if (!simpleChild) {
                    this.markLabel(popGOTO, popStack);
                    this.addByteCode((byte)87);
                    this.addByteCode((byte)-89, trueGOTO);
                }
                return;
            }
            Node rChild = child.getNext();
            if (this.nodeIsDirectCallParameter(child) && (convertChild = this.getConvertToObjectOfNumberNode(rChild)) != null) {
                OptLocalVariable lVar1 = (OptLocalVariable)child.getProp(24);
                this.aload(lVar1.getJRegister());
                this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int notNumbersLabel = this.acquireLabel();
                this.addByteCode((byte)-90, notNumbersLabel);
                this.dload((short)(lVar1.getJRegister() + 1));
                this.push(convertChild.getDouble());
                this.addByteCode((byte)-105);
                if (op == 14) {
                    this.addByteCode((byte)-103, trueGOTO);
                } else {
                    this.addByteCode((byte)-102, trueGOTO);
                }
                this.addByteCode((byte)-89, falseGOTO);
                this.markLabel(notNumbersLabel);
            }
            this.generateCodeFromNode(child, node, -1, -1);
            this.generateCodeFromNode(rChild, node, -1, -1);
            switch (op) {
                case 14: {
                    String name = this.version == 120 ? "shallowEq" : "eq";
                    this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 15: {
                    String name = this.version == 120 ? "shallowNeq" : "neq";
                    this.addOptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 53: {
                    String name = "shallowEq";
                    this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 54: {
                    String name = "shallowNeq";
                    this.addOptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                default: {
                    String name = null;
                    this.badTree();
                }
            }
            this.addByteCode((byte)-102, trueGOTO);
            this.addByteCode((byte)-89, falseGOTO);
        }
    }

    private void visitLiteral(Node node) {
        if (node.getType() == 46) {
            this.push(node.getString());
        } else {
            double num = node.getDouble();
            if (node.getIntProp(26, -1) != -1) {
                this.push(num);
            } else if (this.itsConstantListSize >= 2000) {
                this.pushAsWrapperObject(num);
            } else {
                String constantName = "jsK_" + this.addNumberConstant(num);
                String constantType = this.getStaticConstantWrapperType(num);
                this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(this.name), constantName, constantType);
            }
        }
    }

    private String getStaticConstantWrapperType(double num) {
        int inum = (int)num;
        String constantType = (double)inum == num ? ((byte)inum == inum ? "Ljava/lang/Byte;" : ((short)inum == inum ? "Ljava/lang/Short;" : "Ljava/lang/Integer;")) : "Ljava/lang/Double;";
        return constantType;
    }

    private int addNumberConstant(double num) {
        int N = this.itsConstantListSize;
        if (N == 0) {
            this.itsConstantList = new double[128];
        } else {
            double[] array = this.itsConstantList;
            int i = 0;
            while (i != N) {
                if (array[i] == num) {
                    return i;
                }
                ++i;
            }
            if (N == array.length) {
                array = new double[N * 2];
                System.arraycopy(this.itsConstantList, 0, array, 0, N);
                this.itsConstantList = array;
            }
        }
        this.itsConstantList[N] = num;
        this.itsConstantListSize = N + 1;
        return N;
    }

    private void emitConstantDudeInitializers() {
        int N = this.itsConstantListSize;
        if (N == 0) {
            return;
        }
        this.classFile.startMethod("<clinit>", "()V", (short)24);
        double[] array = this.itsConstantList;
        int i = 0;
        while (i != N) {
            double num = array[i];
            String constantName = "jsK_" + this.addNumberConstant(num);
            String constantType = this.getStaticConstantWrapperType(num);
            this.classFile.addField(constantName, constantType, (short)8);
            this.pushAsWrapperObject(num);
            this.classFile.add((byte)-77, ClassFileWriter.fullyQualifiedForm(this.name), constantName, constantType);
            ++i;
        }
        this.addByteCode((byte)-79);
        this.classFile.stopMethod((short)0, null);
    }

    private void visitPrimary(Node node) {
        int op = node.getOperation();
        switch (op) {
            case 50: {
                this.aload(this.thisObjLocal);
                break;
            }
            case 87: {
                this.classFile.add((byte)42);
                break;
            }
            case 49: {
                this.addByteCode((byte)1);
                break;
            }
            case 52: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 51: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 74: {
                this.pushUndefined();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private void visitObject(Node node) {
        Node regexp = (Node)node.getProp(12);
        String fieldName = (String)regexp.getProp(12);
        this.aload(this.funObjLocal);
        this.classFile.add((byte)-76, ClassFileWriter.fullyQualifiedForm(this.name), fieldName, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
    }

    private void visitName(Node node) {
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.push(name);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitGetVar(OptLocalVariable lVar, boolean isNumber, String name) {
        if (this.hasVarsInRegs && lVar == null) {
            lVar = OptLocalVariable.get(this.vars, name);
        }
        if (lVar != null) {
            if (lVar.getJRegister() == -1) {
                if (lVar.isNumber()) {
                    lVar.assignJRegister(this.getNewWordPairLocal());
                } else {
                    lVar.assignJRegister(this.getNewWordLocal());
                }
            }
            if (lVar.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (isNumber) {
                    this.aload(lVar.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isNumberLabel = this.acquireLabel();
                    int beyond = this.acquireLabel();
                    this.addByteCode((byte)-91, isNumberLabel);
                    this.aload(lVar.getJRegister());
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addByteCode((byte)-89, beyond);
                    this.markLabel(isNumberLabel);
                    this.dload((short)(lVar.getJRegister() + 1));
                    this.markLabel(beyond);
                } else {
                    this.aload(lVar.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isNumberLabel = this.acquireLabel();
                    int beyond = this.acquireLabel();
                    this.addByteCode((byte)-91, isNumberLabel);
                    this.aload(lVar.getJRegister());
                    this.addByteCode((byte)-89, beyond);
                    this.markLabel(isNumberLabel);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.dload((short)(lVar.getJRegister() + 1));
                    this.addDoubleConstructor();
                    this.markLabel(beyond);
                }
            } else if (lVar.isNumber()) {
                this.dload(lVar.getJRegister());
            } else {
                this.aload(lVar.getJRegister());
            }
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(name);
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node child, boolean needValue) {
        OptLocalVariable lVar = (OptLocalVariable)node.getProp(24);
        if (this.hasVarsInRegs && lVar == null) {
            lVar = OptLocalVariable.get(this.vars, child.getString());
        }
        if (lVar != null) {
            this.generateCodeFromNode(child.getNext(), node, -1, -1);
            if (lVar.getJRegister() == -1) {
                if (lVar.isNumber()) {
                    lVar.assignJRegister(this.getNewWordPairLocal());
                } else {
                    lVar.assignJRegister(this.getNewWordLocal());
                }
            }
            if (lVar.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (node.getIntProp(26, -1) != -1) {
                    if (needValue) {
                        this.addByteCode((byte)92);
                    }
                    this.aload(lVar.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isNumberLabel = this.acquireLabel();
                    int beyond = this.acquireLabel();
                    this.addByteCode((byte)-91, isNumberLabel);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.addByteCode((byte)94);
                    this.addByteCode((byte)88);
                    this.addDoubleConstructor();
                    this.astore(lVar.getJRegister());
                    this.addByteCode((byte)-89, beyond);
                    this.markLabel(isNumberLabel);
                    this.dstore((short)(lVar.getJRegister() + 1));
                    this.markLabel(beyond);
                } else {
                    if (needValue) {
                        this.addByteCode((byte)89);
                    }
                    this.astore(lVar.getJRegister());
                }
            } else if (node.getIntProp(26, -1) != -1) {
                this.dstore(lVar.getJRegister());
                if (needValue) {
                    this.dload(lVar.getJRegister());
                }
            } else {
                this.astore(lVar.getJRegister());
                if (needValue) {
                    this.aload(lVar.getJRegister());
                }
            }
            return;
        }
        child.setType(61);
        node.setType(10);
        this.visitSetName(node, child);
        if (!needValue) {
            this.addByteCode((byte)87);
        }
    }

    private void visitGetProp(Node node, Node child) {
        String s = (String)node.getProp(19);
        if (s != null) {
            while (child != null) {
                this.generateCodeFromNode(child, node, -1, -1);
                child = child.getNext();
            }
            this.aload(this.variableObjectLocal);
            String runtimeMethod = null;
            if (s.equals("__proto__")) {
                runtimeMethod = "getProto";
            } else if (s.equals("__parent__")) {
                runtimeMethod = "getParent";
            } else {
                this.badTree();
            }
            this.addScriptRuntimeInvoke(runtimeMethod, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        Node nameChild = child.getNext();
        this.generateCodeFromNode(child, node, -1, -1);
        this.generateCodeFromNode(nameChild, node, -1, -1);
        if (nameChild.getType() == 46) {
            if (child.getType() == 109 && child.getOperation() == 50 || child.getType() == 69 && child.getFirstChild().getType() == 109 && child.getFirstChild().getOperation() == 50) {
                this.aload(this.variableObjectLocal);
                this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            }
        } else {
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void visitSetProp(Node node, Node child) {
        s = (String)node.getProp(19);
        if (s == null) ** GOTO lbl20
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        this.aload(this.variableObjectLocal);
        runtimeMethod = null;
        if (s.equals("__proto__")) {
            runtimeMethod = "setProto";
        } else if (s.equals("__parent__")) {
            runtimeMethod = "setParent";
        } else {
            this.badTree();
        }
        this.addScriptRuntimeInvoke(runtimeMethod, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        return;
lbl-1000:
        // 1 sources

        {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
lbl20:
            // 2 sources

            ** while (child != null)
        }
lbl21:
        // 1 sources

        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitBind(Node node, int type, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke(type == 61 ? "bind" : "getBase", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Lorg/mozilla/javascript/Scriptable;");
    }

    private short getLocalFromNode(Node node) {
        int local = node.getIntProp(7, -1);
        if (local == -1) {
            short s;
            if (node.getType() == 144 || node.getType() == 145) {
                short s2 = this.itsLocalAllocationBase;
                s = s2;
                this.itsLocalAllocationBase = (short)(s2 + 1);
            } else {
                s = this.getNewWordLocal();
            }
            local = s;
            node.putIntProp(7, local);
        }
        return (short)local;
    }

    private void visitNewTemp(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        short local = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(local);
        if (node.getIntProp(11, 0) == 0) {
            this.releaseWordLocal(local);
        }
    }

    private void visitUseTemp(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        Node temp = (Node)node.getProp(6);
        short local = this.getLocalFromNode(temp);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, local);
        } else {
            this.aload(local);
        }
        int n = temp.getIntProp(11, 0);
        if (n <= 1) {
            this.releaseWordLocal(local);
        }
        if (n != 0 && n != Integer.MAX_VALUE) {
            temp.putIntProp(11, n - 1);
        }
    }

    private void visitNewLocal(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        short local = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(local);
    }

    private void visitUseLocal(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node, -1, -1);
            child = child.getNext();
        }
        Node temp = (Node)node.getProp(7);
        short local = this.getLocalFromNode(temp);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, local);
        } else {
            this.aload(local);
        }
    }

    private void dstore(short local) {
        this.xop((byte)71, (byte)57, local);
    }

    private void istore(short local) {
        this.xop((byte)59, (byte)54, local);
    }

    private void astore(short local) {
        this.xop((byte)75, (byte)58, local);
    }

    private void xop(byte shortOp, byte op, short local) {
        switch (local) {
            case 0: {
                this.addByteCode(shortOp);
                break;
            }
            case 1: {
                this.addByteCode((byte)(shortOp + 1));
                break;
            }
            case 2: {
                this.addByteCode((byte)(shortOp + 2));
                break;
            }
            case 3: {
                this.addByteCode((byte)(shortOp + 3));
                break;
            }
            default: {
                if (local < 0 || local >= Short.MAX_VALUE) {
                    throw new RuntimeException("bad local");
                }
                if (local < 127) {
                    this.addByteCode(op, (byte)local);
                    break;
                }
                this.addByteCode((byte)-60);
                this.addByteCode(op);
                this.addByteCode((byte)(local >> 8));
                this.addByteCode((byte)(local & 0xFF));
            }
        }
    }

    private void dload(short local) {
        this.xop((byte)38, (byte)24, local);
    }

    private void iload(short local) {
        this.xop((byte)26, (byte)21, local);
    }

    private void aload(short local) {
        this.xop((byte)42, (byte)25, local);
    }

    private short getNewWordPairLocal() {
        short result;
        for (result = this.firstFreeLocal; result < 255 && (this.locals[result] || this.locals[result + 1]); result = (short)(result + 1)) {
        }
        if (result < 255) {
            this.locals[result] = true;
            this.locals[result + 1] = true;
            if (result == this.firstFreeLocal) {
                int i = this.firstFreeLocal + 2;
                while (i < 256) {
                    if (!this.locals[i]) {
                        this.firstFreeLocal = (short)i;
                        if (this.localsMax < this.firstFreeLocal) {
                            this.localsMax = this.firstFreeLocal;
                        }
                        return result;
                    }
                    ++i;
                }
            } else {
                return result;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short reserveWordLocal(int local) {
        if (this.getNewWordLocal() != local) {
            throw new RuntimeException("Local allocation error");
        }
        return (short)local;
    }

    private short getNewWordLocal() {
        short result = this.firstFreeLocal;
        this.locals[result] = true;
        int i = this.firstFreeLocal + 1;
        while (i < 256) {
            if (!this.locals[i]) {
                this.firstFreeLocal = (short)i;
                if (this.localsMax < this.firstFreeLocal) {
                    this.localsMax = this.firstFreeLocal;
                }
                return result;
            }
            ++i;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void releaseWordpairLocal(short local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = false;
        this.locals[local + 1] = false;
    }

    private void releaseWordLocal(short local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = false;
    }

    private void push(int i) {
        if ((byte)i == i) {
            if (i == -1) {
                this.addByteCode((byte)2);
            } else if (0 <= i && i <= 5) {
                this.addByteCode((byte)(3 + i));
            } else {
                this.addByteCode((byte)16, (byte)i);
            }
        } else if ((short)i == i) {
            this.addByteCode((byte)17, (short)i);
        } else {
            this.classFile.addLoadConstant(i);
        }
    }

    private void push(double d) {
        if (d == 0.0) {
            this.addByteCode((byte)14);
        } else if (d == 1.0) {
            this.addByteCode((byte)15);
        } else {
            this.classFile.addLoadConstant(d);
        }
    }

    private void pushAsWrapperObject(double num) {
        String signature;
        String wrapperType;
        boolean isInteger;
        int inum = (int)num;
        if ((double)inum == num) {
            isInteger = true;
            if ((byte)inum == inum) {
                wrapperType = "java/lang/Byte";
                signature = "(B)";
            } else if ((short)inum == inum) {
                wrapperType = "java/lang/Short";
                signature = "(S)";
            } else {
                wrapperType = "java/lang/Integer";
                signature = "(I)";
            }
        } else {
            isInteger = false;
            wrapperType = "java/lang/Double";
            signature = "(D)";
        }
        this.addByteCode((byte)-69, wrapperType);
        this.addByteCode((byte)89);
        if (isInteger) {
            this.push(inum);
        } else {
            this.push(num);
        }
        this.addSpecialInvoke(wrapperType, "<init>", signature, "V");
    }

    private void push(String s) {
        this.classFile.addLoadConstant(s);
    }

    private void pushUndefined() {
        this.classFile.add((byte)-78, "org/mozilla/javascript/Undefined", "instance", "Lorg/mozilla/javascript/Scriptable;");
    }

    private void badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

