/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;

public class GenericsInfo {
    public static final String SHIFT_MARKER = "  ";
    private static final TypeWriter DEFAULT_WRITER = new DefaultTypeWriter();
    private static final String EXTENDS_MARKER = "extends ";
    private static final String IMPLEMENTS_MARKER = "implements ";
    private final Class<?> root;
    private final Map<Class<?>, LinkedHashMap<String, Type>> types;
    private final Class[] ignoredTypes;

    public GenericsInfo(Class<?> root, Map<Class<?>, LinkedHashMap<String, Type>> types, Class ... ignoredTypes) {
        this.root = root;
        this.types = types;
        this.ignoredTypes = ignoredTypes;
    }

    public Class<?> getRootClass() {
        return this.root;
    }

    public Map<String, Type> getTypeGenerics(Class<?> type) {
        if (!this.types.containsKey(type)) {
            throw new IllegalArgumentException(String.format("Type %s is not assignable from %s", type.getName(), this.root.getName()));
        }
        return new LinkedHashMap<String, Type>((Map)this.types.get(type));
    }

    public Set<Class<?>> getComposingTypes() {
        return new HashSet(this.types.keySet());
    }

    public Class[] getIgnoredTypes() {
        return Arrays.copyOf(this.ignoredTypes, this.ignoredTypes.length);
    }

    public Map<Class<?>, LinkedHashMap<String, Type>> getTypesMap() {
        return new HashMap(this.types);
    }

    public Class<?> findContextByDeclarationType(Class<?> declarationType) {
        Class<?> res = null;
        Set<Class<?>> composingTypes = this.types.keySet();
        if (composingTypes.contains(declarationType)) {
            res = declarationType;
        } else {
            for (Class<?> type : composingTypes) {
                Class outer = (Class)TypeUtils.getOuter(type);
                if (!declarationType.equals(outer)) continue;
                res = type;
                break;
            }
        }
        return res;
    }

    public String toString() {
        return this.toStringHierarchy(DEFAULT_WRITER);
    }

    public String toStringHierarchy(TypeWriter typeWriter) {
        StringBuilder res = new StringBuilder(this.types.size() * 50);
        this.toStringHierarchy(this.root, "", "", res, typeWriter);
        return res.toString();
    }

    private void toStringHierarchy(Class<?> type, String shift, String prefix, StringBuilder res, TypeWriter typeWriter) {
        LinkedHashMap<String, Type> generics = this.types.get(type);
        Map<String, Type> ownerGenerics = GenericsUtils.extractOwnerGenerics(type, generics);
        Map<String, Type> typeGenerics = GenericsUtils.extractTypeGenerics(type, generics);
        Class outer = (Class)TypeUtils.getOuter(type);
        Object[] objectArray = new Object[3];
        objectArray[0] = shift;
        objectArray[1] = prefix.isEmpty() ? (type.isInterface() ? "interface " : "class ") : prefix;
        objectArray[2] = typeWriter.write(type, typeGenerics, outer, ownerGenerics, shift);
        res.append(String.format("%s%s%s%n", objectArray));
        Class<?> superclass = type.getSuperclass();
        if (this.types.containsKey(superclass)) {
            this.toStringHierarchy(superclass, shift + SHIFT_MARKER, EXTENDS_MARKER, res, typeWriter);
        }
        for (Class<?> iface : type.getInterfaces()) {
            if (!this.types.containsKey(iface)) continue;
            this.toStringHierarchy(iface, shift + SHIFT_MARKER, type.isInterface() ? EXTENDS_MARKER : IMPLEMENTS_MARKER, res, typeWriter);
        }
    }

    public static class DefaultTypeWriter
    implements TypeWriter {
        @Override
        public String write(Class<?> type, Map<String, Type> generics, Class<?> owner, Map<String, Type> ownerGenerics, String shift) {
            String inner = owner != null ? String.format("%s.", TypeToStringUtils.toStringWithGenerics(owner, ownerGenerics)) : "";
            return String.format("%s%s", inner, TypeToStringUtils.toStringWithGenerics(type, generics));
        }
    }

    public static interface TypeWriter {
        public String write(Class<?> var1, Map<String, Type> var2, Class<?> var3, Map<String, Type> var4, String var5);
    }
}

