/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.error;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.vyarus.java.generics.resolver.error.GenericsException;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class GenericsResolutionException
extends GenericsException {
    private final Class<?> type;
    private final LinkedHashMap<String, Type> rootGenerics;
    private final Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics;

    public GenericsResolutionException(Class<?> type, LinkedHashMap<String, Type> rootGenerics, Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics, Exception ex) {
        super(String.format("Failed to analyze hierarchy for %s%s", TypeToStringUtils.toStringWithGenerics(type, rootGenerics), GenericsResolutionException.formatKnownGenerics(type, knownGenerics)), ex);
        this.type = type;
        this.rootGenerics = rootGenerics;
        this.knownGenerics = knownGenerics;
    }

    public Class<?> getType() {
        return this.type;
    }

    public LinkedHashMap<String, Type> getRootGenerics() {
        return this.rootGenerics;
    }

    public Map<Class<?>, LinkedHashMap<String, Type>> getKnownGenerics() {
        return this.knownGenerics;
    }

    private static String formatKnownGenerics(Class<?> type, Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics) {
        if (knownGenerics.isEmpty()) {
            return "";
        }
        StringBuilder known = new StringBuilder(50);
        boolean first = true;
        for (Map.Entry<Class<?>, LinkedHashMap<String, Type>> entry : knownGenerics.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            known.append(first ? "" : ", ").append(TypeToStringUtils.toStringWithGenerics(entry.getKey(), (Map<String, Type>)entry.getValue()));
            first = false;
        }
        return known.length() > 0 ? " (with known generics: " + known.toString() + ')' : "";
    }
}

