/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.element;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;

public class Table
extends TypifiedElement {
    public Table(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public List<WebElement> getHeadings() {
        return this.getWrappedElement().findElements(By.xpath((String)".//th"));
    }

    public List<String> getHeadingsAsString() {
        return Lambda.convert(this.getHeadings(), WebElementToTextConverter.toTextValues());
    }

    public List<List<WebElement>> getRows() {
        ArrayList<List<WebElement>> rows = new ArrayList<List<WebElement>>();
        List rowElements = this.getWrappedElement().findElements(By.xpath((String)".//tr"));
        for (WebElement rowElement : rowElements) {
            rows.add(rowElement.findElements(By.xpath((String)".//td")));
        }
        return rows;
    }

    public List<List<String>> getRowsAsString() {
        return Lambda.convert(this.getRows(), ListConverter.toListsConvertingEachItem(WebElementToTextConverter.toTextValues()));
    }

    public List<List<WebElement>> getColumns() {
        ArrayList<List<WebElement>> columns = new ArrayList<List<WebElement>>();
        List<List<WebElement>> rows = this.getRows();
        if (rows.isEmpty()) {
            return columns;
        }
        int columnsNumber = rows.get(0).size();
        for (int i = 0; i < columnsNumber; ++i) {
            ArrayList<WebElement> column = new ArrayList<WebElement>();
            for (List<WebElement> row : rows) {
                column.add(row.get(i));
            }
            columns.add(column);
        }
        return columns;
    }

    public List<List<String>> getColumnsAsString() {
        return Lambda.convert(this.getColumns(), ListConverter.toListsConvertingEachItem(WebElementToTextConverter.toTextValues()));
    }

    public WebElement getCellAt(int i, int j) {
        return this.getRows().get(i).get(j);
    }

    public List<Map<String, WebElement>> getRowsMappedToHeadings() {
        return this.getRowsMappedToHeadings(this.getHeadingsAsString());
    }

    public List<Map<String, WebElement>> getRowsMappedToHeadings(List<String> headings) {
        ArrayList<Map<String, WebElement>> rowsMappedToHeadings = new ArrayList<Map<String, WebElement>>();
        List<List<WebElement>> rows = this.getRows();
        if (rows.isEmpty()) {
            return rowsMappedToHeadings;
        }
        for (List<WebElement> row : rows) {
            if (row.size() != headings.size()) {
                throw new HtmlElementsException("Headings count is not equal to number of cells in row");
            }
            HashMap<String, WebElement> rowToHeadingsMap = new HashMap<String, WebElement>();
            int cellNumber = 0;
            for (String heading : headings) {
                rowToHeadingsMap.put(heading, row.get(cellNumber));
                ++cellNumber;
            }
            rowsMappedToHeadings.add(rowToHeadingsMap);
        }
        return rowsMappedToHeadings;
    }

    public List<Map<String, String>> getRowsAsStringMappedToHeadings() {
        return this.getRowsAsStringMappedToHeadings(this.getHeadingsAsString());
    }

    public List<Map<String, String>> getRowsAsStringMappedToHeadings(List<String> headings) {
        return Lambda.convert(this.getRowsMappedToHeadings(headings), MapConverter.toMapsConvertingEachValue(WebElementToTextConverter.toText()));
    }

    static final class MapConverter<K, F, T>
    implements Converter<Map<K, F>, Map<K, T>> {
        private final Converter<F, T> valueConverter;

        public static <F, T> Converter<Map<String, F>, Map<String, T>> toMapsConvertingEachValue(Converter<F, T> valueConverter) {
            return new MapConverter(valueConverter);
        }

        private MapConverter(Converter<F, T> valueConverter) {
            this.valueConverter = valueConverter;
        }

        public Map<K, T> convert(Map<K, F> map) {
            return Lambda.convertMap(map, this.valueConverter);
        }
    }

    static final class ListConverter<F, T>
    implements Converter<List<F>, List<T>> {
        private final Converter<F, T> itemsConverter;

        public static <F, T> Converter<List<F>, List<T>> toListsConvertingEachItem(Converter<F, T> itemsConverter) {
            return new ListConverter<F, T>(itemsConverter);
        }

        private ListConverter(Converter<F, T> itemsConverter) {
            this.itemsConverter = itemsConverter;
        }

        public List<T> convert(List<F> list) {
            return Lambda.convert(list, this.itemsConverter);
        }
    }

    static final class WebElementToTextConverter
    implements Converter<WebElement, String> {
        public static Converter<WebElement, String> toText() {
            return new WebElementToTextConverter();
        }

        public static Converter<WebElement, String> toTextValues() {
            return new WebElementToTextConverter();
        }

        private WebElementToTextConverter() {
        }

        public String convert(WebElement element) {
            return element.getText();
        }
    }
}

