/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.AnalysisFailureException;
import se.kth.depclean.core.analysis.DefaultProjectDependencyAnalyzer;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;
import se.kth.depclean.core.model.ClassName;
import se.kth.depclean.core.model.Dependency;
import se.kth.depclean.core.model.ProjectContext;
import se.kth.depclean.core.model.Scope;
import se.kth.depclean.core.util.JarUtils;
import se.kth.depclean.core.wrapper.DependencyManagerWrapper;
import se.kth.depclean.core.wrapper.LogWrapper;

public class DepCleanManager {
    private static final Logger log = LoggerFactory.getLogger(DepCleanManager.class);
    private static final String SEPARATOR = "-------------------------------------------------------";
    private static final String DIRECTORY_TO_EXTRACT_DEPENDENCIES = "dependency";
    private final DependencyManagerWrapper dependencyManager;
    private final boolean skipDepClean;
    private final boolean ignoreTests;
    private final Set<String> ignoreScopes;
    private final Set<String> ignoreDependencies;
    private final boolean failIfUnusedDirect;
    private final boolean failIfUnusedTransitive;
    private final boolean failIfUnusedInheritedDirect;
    private final boolean failIfUnusedInheritedTransitive;
    private final boolean createPomDebloated;
    private final boolean createResultJson;
    private final boolean createCallGraphCsv;

    public ProjectDependencyAnalysis execute() throws AnalysisFailureException {
        long startTime = System.currentTimeMillis();
        if (this.skipDepClean) {
            this.getLog().info("Skipping DepClean plugin execution");
            return null;
        }
        this.printString(SEPARATOR);
        this.getLog().info("Starting DepClean dependency analysis");
        if (this.dependencyManager.isMaven() && this.dependencyManager.isPackagingPom()) {
            this.getLog().info("Skipping because packaging type is pom");
            return null;
        }
        this.extractClassesFromDependencies();
        DefaultProjectDependencyAnalyzer projectDependencyAnalyzer = new DefaultProjectDependencyAnalyzer();
        ProjectDependencyAnalysis analysis = projectDependencyAnalyzer.analyze(this.buildProjectContext());
        analysis.print();
        if (this.failIfUnusedDirect && analysis.hasUnusedDirectDependencies()) {
            throw new AnalysisFailureException("Build failed due to unused direct dependencies in the dependency tree of the project.");
        }
        if (this.failIfUnusedTransitive && analysis.hasUnusedTransitiveDependencies()) {
            throw new AnalysisFailureException("Build failed due to unused transitive dependencies in the dependency tree of the project.");
        }
        if (this.failIfUnusedInheritedDirect && analysis.hasUnusedInheritedDirectDependencies()) {
            throw new AnalysisFailureException("Build failed due to unused inherited direct dependencies in the dependency tree of the project.");
        }
        if (this.failIfUnusedInheritedTransitive && analysis.hasUnusedInheritedTransitiveDependencies()) {
            throw new AnalysisFailureException("Build failed due to unused inherited transitive dependencies in the dependency tree of the project.");
        }
        if (this.createPomDebloated) {
            this.dependencyManager.getDebloater(analysis).write();
        }
        if (this.createResultJson) {
            this.createResultJson(analysis);
        }
        long stopTime = System.currentTimeMillis();
        this.getLog().info("Analysis done in " + this.getTime(stopTime - startTime));
        return analysis;
    }

    private void extractClassesFromDependencies() {
        File dependencyDirectory = this.dependencyManager.getBuildDirectory().resolve(DIRECTORY_TO_EXTRACT_DEPENDENCIES).toFile();
        FileUtils.deleteDirectory((File)dependencyDirectory);
        this.dependencyManager.dependencyGraph().allDependencies().forEach(jarFile -> this.copyDependencies((Dependency)jarFile, dependencyDirectory));
        if (this.dependencyManager.getBuildDirectory().resolve("libs").toFile().exists()) {
            try {
                FileUtils.copyDirectory((File)this.dependencyManager.getBuildDirectory().resolve("libs").toFile(), (File)dependencyDirectory);
            }
            catch (IOException | NullPointerException e) {
                this.getLog().error("Error copying directory libs to" + dependencyDirectory.getAbsolutePath());
            }
        }
        if (dependencyDirectory.exists()) {
            JarUtils.decompress(dependencyDirectory.getAbsolutePath());
        }
    }

    private void copyDependencies(Dependency dependency, File destFolder) {
        this.copyDependencies(dependency.getFile(), destFolder);
    }

    private void copyDependencies(File jarFile, File destFolder) {
        FileUtils.copyFileToDirectory((File)jarFile, (File)destFolder);
    }

    private void createResultJson(ProjectDependencyAnalysis analysis) {
        this.printString("Creating depclean-results.json, please wait...");
        File jsonFile = new File(this.dependencyManager.getBuildDirectory() + File.separator + "depclean-results.json");
        File treeFile = new File(this.dependencyManager.getBuildDirectory() + File.separator + "tree.txt");
        File csvFile = new File(this.dependencyManager.getBuildDirectory() + File.separator + "depclean-callgraph.csv");
        try {
            this.dependencyManager.generateDependencyTree(treeFile);
        }
        catch (IOException | InterruptedException e) {
            this.getLog().error("Unable to generate dependency tree.");
            Thread.currentThread().interrupt();
            return;
        }
        if (this.createCallGraphCsv) {
            this.printString("Creating " + csvFile.getName() + ", please wait...");
            try {
                FileUtils.write((File)csvFile, (CharSequence)"OriginClass,TargetClass,OriginDependency,TargetDependency\n", (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                this.getLog().error("Error writing the CSV header.");
            }
        }
        String treeAsJson = this.dependencyManager.getTreeAsJson(treeFile, analysis, csvFile, this.createCallGraphCsv);
        try {
            FileUtils.write((File)jsonFile, (CharSequence)treeAsJson, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.getLog().error("Unable to generate " + jsonFile.getName() + " file.");
        }
        if (jsonFile.exists()) {
            this.getLog().info(jsonFile.getName() + " file created in: " + jsonFile.getAbsolutePath());
        }
        if (csvFile.exists()) {
            this.getLog().info(csvFile.getName() + " file created in: " + csvFile.getAbsolutePath());
        }
    }

    private ProjectContext buildProjectContext() {
        if (this.ignoreTests) {
            this.ignoreScopes.add("test");
        }
        HashSet<ClassName> allUsedClasses = new HashSet<ClassName>();
        Set usedClassesFromProcessors = this.dependencyManager.collectUsedClassesFromProcessors().stream().map(ClassName::new).collect(Collectors.toSet());
        Set usedClassesFromSource = this.dependencyManager.collectUsedClassesFromSource(this.dependencyManager.getSourceDirectory(), this.dependencyManager.getTestDirectory()).stream().map(ClassName::new).collect(Collectors.toSet());
        allUsedClasses.addAll(usedClassesFromProcessors);
        allUsedClasses.addAll(usedClassesFromSource);
        return new ProjectContext(this.dependencyManager.dependencyGraph(), this.dependencyManager.getOutputDirectories(), this.dependencyManager.getTestOutputDirectories(), this.dependencyManager.getSourceDirectory(), this.dependencyManager.getTestDirectory(), this.dependencyManager.getDependenciesDirectory(), this.ignoreScopes.stream().map(Scope::new).collect(Collectors.toSet()), this.toDependency(this.dependencyManager.dependencyGraph().allDependencies(), this.ignoreDependencies), allUsedClasses);
    }

    private Set<Dependency> toDependency(Set<Dependency> allDependencies, Set<String> ignoreDependencies) {
        return ignoreDependencies.stream().map(dependencyToIgnore -> this.findDependency(allDependencies, (String)dependencyToIgnore)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Dependency findDependency(Set<Dependency> allDependencies, String dependency) {
        Pattern pattern = Pattern.compile(dependency, 2);
        return allDependencies.stream().filter(dep -> pattern.matcher(dep.toString()).lookingAt()).findFirst().orElse(null);
    }

    private String getTime(long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        return String.format("%smin %ss", minutes, seconds);
    }

    private void printString(String string) {
        System.out.println(string);
    }

    private LogWrapper getLog() {
        return this.dependencyManager.getLog();
    }

    public DepCleanManager(DependencyManagerWrapper dependencyManager, boolean skipDepClean, boolean ignoreTests, Set<String> ignoreScopes, Set<String> ignoreDependencies, boolean failIfUnusedDirect, boolean failIfUnusedTransitive, boolean failIfUnusedInheritedDirect, boolean failIfUnusedInheritedTransitive, boolean createPomDebloated, boolean createResultJson, boolean createCallGraphCsv) {
        this.dependencyManager = dependencyManager;
        this.skipDepClean = skipDepClean;
        this.ignoreTests = ignoreTests;
        this.ignoreScopes = ignoreScopes;
        this.ignoreDependencies = ignoreDependencies;
        this.failIfUnusedDirect = failIfUnusedDirect;
        this.failIfUnusedTransitive = failIfUnusedTransitive;
        this.failIfUnusedInheritedDirect = failIfUnusedInheritedDirect;
        this.failIfUnusedInheritedTransitive = failIfUnusedInheritedTransitive;
        this.createPomDebloated = createPomDebloated;
        this.createResultJson = createResultJson;
        this.createCallGraphCsv = createCallGraphCsv;
    }
}

