/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.ActualUsedClasses;
import se.kth.depclean.core.analysis.DependencyAnalyzer;
import se.kth.depclean.core.analysis.ProjectDependencyAnalysisBuilder;
import se.kth.depclean.core.analysis.asm.ASMDependencyAnalyzer;
import se.kth.depclean.core.analysis.graph.DefaultCallGraph;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;
import se.kth.depclean.core.model.ClassName;
import se.kth.depclean.core.model.ProjectContext;

public class DefaultProjectDependencyAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectDependencyAnalyzer.class);
    private final DependencyAnalyzer dependencyAnalyzer = new ASMDependencyAnalyzer();

    public ProjectDependencyAnalysis analyze(ProjectContext projectContext) {
        ActualUsedClasses actualUsedClasses = new ActualUsedClasses(projectContext);
        projectContext.getOutputFolders().forEach(folder -> actualUsedClasses.registerClasses(this.getProjectDependencyClasses((Path)folder)));
        if (!projectContext.ignoreTests()) {
            projectContext.getTestOutputFolders().forEach(folder -> actualUsedClasses.registerClasses(this.getProjectTestDependencyClasses((Path)folder)));
        }
        HashSet<String> projectClasses = new HashSet<String>(DefaultCallGraph.getProjectVertices());
        log.debug("Project classes: {}", projectClasses);
        actualUsedClasses.registerClasses(this.getProjectDependencyClasses(projectContext.getDependenciesFolder()));
        actualUsedClasses.registerClasses(projectContext.getExtraClasses());
        actualUsedClasses.registerClasses(this.getReferencedClassMembers(projectClasses));
        return new ProjectDependencyAnalysisBuilder(projectContext, actualUsedClasses).analyse();
    }

    private Iterable<ClassName> getProjectDependencyClasses(Path outputFolder) {
        return this.collectDependencyClasses(outputFolder);
    }

    private Iterable<ClassName> getProjectTestDependencyClasses(Path testOutputFolder) {
        log.trace("# getProjectTestDependencyClasses()");
        return this.collectDependencyClasses(testOutputFolder);
    }

    private Iterable<ClassName> collectDependencyClasses(Path path) throws IOException {
        return this.dependencyAnalyzer.analyze(path.toUri().toURL()).stream().map(ClassName::new).collect(Collectors.toSet());
    }

    private Iterable<ClassName> getReferencedClassMembers(Set<String> projectClasses) {
        return DefaultCallGraph.referencedClassMembers(projectClasses).stream().map(ClassName::new).collect(Collectors.toSet());
    }
}

