/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.ActualUsedClasses;
import se.kth.depclean.core.analysis.DependencyTypes;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;
import se.kth.depclean.core.model.ClassName;
import se.kth.depclean.core.model.Dependency;
import se.kth.depclean.core.model.ProjectContext;
import se.kth.depclean.core.model.Scope;

public class ProjectDependencyAnalysisBuilder {
    private static final Logger log = LoggerFactory.getLogger(ProjectDependencyAnalysisBuilder.class);
    private final ProjectContext context;
    private final ActualUsedClasses actualUsedClasses;
    private final Set<Dependency> usedDependencies;

    ProjectDependencyAnalysisBuilder(ProjectContext context, ActualUsedClasses actualUsedClasses) {
        this.context = context;
        this.actualUsedClasses = actualUsedClasses;
        this.usedDependencies = actualUsedClasses.getRegisteredClasses().stream().flatMap(clazz -> context.getDependenciesForClass((ClassName)clazz).stream()).collect(Collectors.toSet());
        log.debug("Actual used classes: " + actualUsedClasses.getRegisteredClasses());
        log.debug("Used dependencies" + this.usedDependencies);
    }

    public ProjectDependencyAnalysis analyse() {
        Set<Dependency> usedDirectDependencies = this.getUsedDirectDependencies();
        Set<Dependency> usedTransitiveDependencies = this.getUsedTransitiveDependencies();
        Set<Dependency> usedInheritedDirectDependencies = this.getUsedInheritedDirectDependencies();
        Set<Dependency> usedInheritedTransitiveDependencies = this.getUsedInheritedTransitiveDependencies();
        Set<Dependency> unusedDirectDependencies = this.getUnusedDirectDependencies(usedDirectDependencies);
        Set<Dependency> unusedTransitiveDependencies = this.getUnusedTransitiveDependencies(usedTransitiveDependencies);
        Set<Dependency> unusedInheritedDirectDependencies = this.getUnusedInheritedDirectDependencies(usedInheritedDirectDependencies);
        Set<Dependency> unusedInheritedTransitiveDependencies = this.getUnusedInheritedTransitiveDependencies(usedInheritedTransitiveDependencies);
        Map<Dependency, DependencyTypes> dependencyClassesMap = this.buildDependencyClassesMap();
        this.context.getIgnoredDependencies().forEach(dependencyToIgnore -> {
            this.ignoreDependency(usedDirectDependencies, unusedDirectDependencies, (Dependency)dependencyToIgnore);
            this.ignoreDependency(usedTransitiveDependencies, unusedTransitiveDependencies, (Dependency)dependencyToIgnore);
            this.ignoreDependency(usedInheritedDirectDependencies, unusedInheritedDirectDependencies, (Dependency)dependencyToIgnore);
            this.ignoreDependency(usedInheritedTransitiveDependencies, unusedInheritedTransitiveDependencies, (Dependency)dependencyToIgnore);
        });
        this.ignoreDependencyWithIgnoredScope(usedDirectDependencies, unusedDirectDependencies, this.context.getIgnoredScopes());
        this.ignoreDependencyWithIgnoredScope(usedTransitiveDependencies, unusedTransitiveDependencies, this.context.getIgnoredScopes());
        this.ignoreDependencyWithIgnoredScope(usedInheritedDirectDependencies, unusedInheritedDirectDependencies, this.context.getIgnoredScopes());
        this.ignoreDependencyWithIgnoredScope(usedInheritedTransitiveDependencies, unusedInheritedTransitiveDependencies, this.context.getIgnoredScopes());
        return new ProjectDependencyAnalysis(usedDirectDependencies, usedTransitiveDependencies, usedInheritedDirectDependencies, usedInheritedTransitiveDependencies, unusedDirectDependencies, unusedTransitiveDependencies, unusedInheritedDirectDependencies, unusedInheritedTransitiveDependencies, this.context.getIgnoredDependencies(), dependencyClassesMap, this.context.getDependencyGraph());
    }

    private Map<Dependency, DependencyTypes> buildDependencyClassesMap() {
        HashMap<Dependency, DependencyTypes> output = new HashMap<Dependency, DependencyTypes>();
        HashSet allDependencies = Sets.newHashSet(this.context.getAllDependencies());
        for (Dependency dependency : allDependencies) {
            Set<ClassName> allClasses = this.context.getClassesForDependency(dependency);
            HashSet usedClasses = Sets.newHashSet(allClasses);
            usedClasses.retainAll(this.actualUsedClasses.getRegisteredClasses());
            output.put(dependency, new DependencyTypes(allClasses, usedClasses));
        }
        return output;
    }

    private Set<Dependency> getUsedInheritedDirectDependencies() {
        return this.usedDependencies.stream().filter(a -> this.context.getDependencyGraph().inheritedDirectDependencies().contains(a)).peek(dependency -> log.trace("## Used Inherited Direct dependency {}", dependency)).collect(Collectors.toSet());
    }

    private Set<Dependency> getUsedDirectDependencies() {
        return this.usedDependencies.stream().filter(a -> this.context.getDependencyGraph().directDependencies().contains(a)).peek(dependency -> log.trace("## Used Direct dependency {}", dependency)).collect(Collectors.toSet());
    }

    private Set<Dependency> getUsedTransitiveDependencies() {
        return this.usedDependencies.stream().filter(a -> this.context.getDependencyGraph().transitiveDependencies().contains(a)).peek(dependency -> log.trace("## Used Transitive dependency {}", dependency)).collect(Collectors.toSet());
    }

    private Set<Dependency> getUsedInheritedTransitiveDependencies() {
        return this.usedDependencies.stream().filter(a -> this.context.getDependencyGraph().inheritedTransitiveDependencies().contains(a)).peek(dependency -> log.trace("## Used Transitive dependency {}", dependency)).collect(Collectors.toSet());
    }

    private Set<Dependency> getUnusedDirectDependencies(Set<Dependency> usedDirectDependencies) {
        return this.getUnusedDependencies(this.context.getDependencyGraph().directDependencies(), usedDirectDependencies);
    }

    private Set<Dependency> getUnusedTransitiveDependencies(Set<Dependency> usedTransitiveDependencies) {
        return this.getUnusedDependencies(this.context.getDependencyGraph().transitiveDependencies(), usedTransitiveDependencies);
    }

    private Set<Dependency> getUnusedInheritedDirectDependencies(Set<Dependency> usedInheritedDependencies) {
        return this.getUnusedDependencies(this.context.getDependencyGraph().inheritedDirectDependencies(), usedInheritedDependencies);
    }

    private Set<Dependency> getUnusedInheritedTransitiveDependencies(Set<Dependency> usedInheritedDependencies) {
        return this.getUnusedDependencies(this.context.getDependencyGraph().inheritedTransitiveDependencies(), usedInheritedDependencies);
    }

    private Set<Dependency> getUnusedDependencies(Set<Dependency> baseDependencies, Set<Dependency> usedDependencies) {
        HashSet unusedInheritedDependencies = Sets.newHashSet(baseDependencies);
        unusedInheritedDependencies.removeAll(usedDependencies);
        return unusedInheritedDependencies;
    }

    private void ignoreDependency(Set<Dependency> usedDependencies, Set<Dependency> unusedDependencies, Dependency dependencyToIgnore) {
        Iterator<Dependency> i = unusedDependencies.iterator();
        while (i.hasNext()) {
            Dependency unusedDependency = i.next();
            if (!dependencyToIgnore.equals(unusedDependency)) continue;
            usedDependencies.add(unusedDependency);
            i.remove();
            break;
        }
    }

    private void ignoreDependencyWithIgnoredScope(Set<Dependency> usedDependencies, Set<Dependency> unusedDependencies, Set<Scope> ignoredScopes) {
        Iterator<Dependency> i = unusedDependencies.iterator();
        while (i.hasNext()) {
            Dependency unusedDependency = i.next();
            List scopesToIgnore = ignoredScopes.stream().map(Scope::getValue).collect(Collectors.toList());
            log.debug("Scopes to ignore: {}", scopesToIgnore);
            log.debug("Unused dependency scope: {}", (Object)unusedDependency.getScope());
            if (!scopesToIgnore.contains(unusedDependency.getScope())) continue;
            log.debug("Ignoring dependency {} with scope {}", (Object)unusedDependency, (Object)unusedDependency.getScope());
            usedDependencies.add(unusedDependency);
            i.remove();
        }
    }
}

