/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis.asm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ConstantPoolParser {
    public static final int HEAD = -889275714;
    public static final byte CONSTANT_UTF8 = 1;
    public static final byte CONSTANT_INTEGER = 3;
    public static final byte CONSTANT_FLOAT = 4;
    public static final byte CONSTANT_LONG = 5;
    public static final byte CONSTANT_DOUBLE = 6;
    public static final byte CONSTANT_CLASS = 7;
    public static final byte CONSTANT_STRING = 8;
    public static final byte CONSTANT_FIELDREF = 9;
    public static final byte CONSTANT_METHODREF = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF = 11;
    public static final byte CONSTANT_NAME_AND_TYPE = 12;
    public static final byte CONSTANT_METHODHANDLE = 15;
    public static final byte CONSTANT_METHOD_TYPE = 16;
    public static final byte CONSTANT_INVOKE_DYNAMIC = 18;
    public static final byte CONSTANT_MODULE = 19;
    public static final byte CONSTANT_PACKAGE = 20;
    private static final int OXF0 = 240;
    private static final int OXE0 = 224;
    private static final int OX3F = 63;

    private ConstantPoolParser() {
        throw new IllegalStateException("Utility class");
    }

    static Set<String> getConstantPoolClassReferences(byte[] b) {
        return ConstantPoolParser.parseConstantPoolClassReferences(ByteBuffer.wrap(b));
    }

    static Set<String> parseConstantPoolClassReferences(ByteBuffer buf) {
        if (buf.order(ByteOrder.BIG_ENDIAN).getInt() != -889275714) {
            return Collections.emptySet();
        }
        buf.getChar();
        buf.getChar();
        HashSet<Integer> classes = new HashSet<Integer>();
        HashMap<Integer, String> stringConstants = new HashMap<Integer, String>();
        int num = buf.getChar();
        block13: for (int ix = 1; ix < num; ++ix) {
            byte tag = buf.get();
            switch (tag) {
                case 1: {
                    stringConstants.put(ix, ConstantPoolParser.decodeString(buf));
                    continue block13;
                }
                case 7: 
                case 8: 
                case 16: {
                    classes.add(Integer.valueOf(buf.getChar()));
                    continue block13;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    buf.getChar();
                    buf.getChar();
                    continue block13;
                }
                case 3: {
                    buf.getInt();
                    continue block13;
                }
                case 4: {
                    buf.getFloat();
                    continue block13;
                }
                case 6: {
                    buf.getDouble();
                    ++ix;
                    continue block13;
                }
                case 5: {
                    buf.getLong();
                    ++ix;
                    continue block13;
                }
                case 15: {
                    buf.get();
                    buf.getChar();
                    continue block13;
                }
                case 18: {
                    buf.getChar();
                    buf.getChar();
                    continue block13;
                }
                case 19: {
                    buf.getChar();
                    continue block13;
                }
                case 20: {
                    buf.getChar();
                    continue block13;
                }
                default: {
                    throw new RuntimeException("Unknown constant pool type '" + tag + "'");
                }
            }
        }
        HashSet<String> result = new HashSet<String>();
        for (Integer clazz : classes) {
            result.add((String)stringConstants.get(clazz));
        }
        return result;
    }

    @NotNull
    private static String decodeString(ByteBuffer buf) {
        char size = buf.getChar();
        int oldLimit = buf.limit();
        buf.limit(buf.position() + size);
        StringBuilder sb = new StringBuilder(size + (size >> 1) + 16);
        while (buf.hasRemaining()) {
            byte b = buf.get();
            if (b > 0) {
                sb.append((char)b);
                continue;
            }
            byte b2 = buf.get();
            if ((b & 0xF0) != 224) {
                sb.append((char)((b & 0x1F) << 6 | b2 & 0x3F));
                continue;
            }
            byte b3 = buf.get();
            sb.append((char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
        }
        buf.limit(oldLimit);
        return sb.toString();
    }
}

