/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final SimpleDateFormat DATE_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat YEAR_FORMATTER = new SimpleDateFormat("yyyy");

    public static boolean isValidDate(DateFormat sdf, String date) {
        try {
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static Date getDate(DateFormat sdf, String date) {
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static long daysBetween(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        return DateUtils.daysBetween(start, end);
    }

    public static long daysBetween(Calendar startDate, Calendar endDate) {
        startDate = (Calendar)startDate.clone();
        long daysBetween = 0L;
        while (startDate.get(1) < endDate.get(1)) {
            if (startDate.get(6) != 1) {
                int diff = startDate.getMaximum(6) - startDate.get(6);
                startDate.add(6, ++diff);
                daysBetween += (long)diff;
                continue;
            }
            daysBetween += (long)startDate.getMaximum(6);
            startDate.add(1, 1);
        }
        return daysBetween += (long)(endDate.get(6) - startDate.get(6));
    }
}

