/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.sql.ResultSet;
import java.sql.SQLException;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.validation.StringFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerPopulator
extends BaseStringPopulator<Integer>
implements BeanResultSetPopulator<Integer> {
    private static final IntegerPopulator POPULATOR = new IntegerPopulator();
    private int columnIndex = 1;

    public static IntegerPopulator getPopulator() {
        return POPULATOR;
    }

    public IntegerPopulator() {
    }

    public IntegerPopulator(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public IntegerPopulator(String populatorID, StringFormatValidator formatValidator) {
        super(populatorID, formatValidator);
    }

    public IntegerPopulator(String populatorID) {
        super(populatorID);
    }

    @Override
    public Integer populate(ResultSet rs) throws SQLException {
        return rs.getInt(this.columnIndex);
    }

    @Override
    public Integer getValue(String value) {
        return Integer.valueOf(value);
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        return NumberUtils.isInt(value);
    }

    @Override
    public Class<? extends Integer> getType() {
        return Integer.class;
    }
}

