/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import se.unlogic.standardutils.threads.ThreadPoolListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedThreadPoolExecutor
extends ThreadPoolExecutor {
    private boolean isPaused;
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();
    private final ConcurrentLinkedQueue<ThreadPoolListener> listeners = new ConcurrentLinkedQueue();

    public ExtendedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ExtendedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public ExtendedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public ExtendedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        block7: {
            super.beforeExecute(t, r);
            this.pauseLock.lock();
            try {
                try {
                    while (this.isPaused) {
                        this.unpaused.await();
                    }
                }
                catch (InterruptedException ie) {
                    t.interrupt();
                    this.pauseLock.unlock();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.pauseLock.unlock();
                throw throwable;
            }
            this.pauseLock.unlock();
        }
        for (ThreadPoolListener listerner : this.listeners) {
            listerner.beforeExecute(t, r);
        }
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        for (ThreadPoolListener listerner : this.listeners) {
            listerner.afterExecute(t, r);
        }
    }

    public boolean addListener(ThreadPoolListener listener) {
        return this.listeners.add(listener);
    }

    public boolean remove(ThreadPoolListener listener) {
        return this.listeners.remove(listener);
    }
}

