/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.validation;

import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.StringNumberValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFloatValidator
extends StringNumberValidator<Float> {
    public StringFloatValidator() {
        super(null, null);
    }

    public StringFloatValidator(Float minValue, Float maxValue) {
        super(minValue, maxValue);
    }

    @Override
    public boolean validateFormat(String value) {
        Float numberValue = NumberUtils.toFloat(value);
        if (numberValue == null) {
            return false;
        }
        if (this.maxValue != null && this.minValue != null) {
            return numberValue.floatValue() <= ((Float)this.maxValue).floatValue() && numberValue.floatValue() > ((Float)this.minValue).floatValue();
        }
        if (this.maxValue != null) {
            return numberValue.floatValue() <= ((Float)this.maxValue).floatValue();
        }
        if (this.minValue != null) {
            return numberValue.floatValue() >= ((Float)this.minValue).floatValue();
        }
        return true;
    }
}

