/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xml;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.annotations.NoAnnotatedFieldsFoundException;
import se.unlogic.standardutils.arrays.ArrayUtils;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.DummyStringyfier;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.Stringyfier;
import se.unlogic.standardutils.xml.ClassXMLInfo;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.FieldType;
import se.unlogic.standardutils.xml.FieldXMLInfo;
import se.unlogic.standardutils.xml.MissingXMLAnnotationException;
import se.unlogic.standardutils.xml.XMLAttribute;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLUtils;

public class XMLGenerator {
    private static ConcurrentHashMap<Class<?>, ClassXMLInfo> FIELD_MAP = new ConcurrentHashMap();

    public static Element toXML(Object bean, Document doc) {
        int n;
        Object[] objectArray;
        ClassXMLInfo classInfo = FIELD_MAP.get(bean.getClass());
        if (classInfo == null) {
            Class<?> clazz = bean.getClass();
            XMLElement xmlElement = clazz.getAnnotation(XMLElement.class);
            if (xmlElement == null) {
                throw new MissingXMLAnnotationException(clazz);
            }
            String elementName = xmlElement.name();
            if (StringUtils.isEmpty(elementName)) {
                elementName = clazz.getSimpleName();
            }
            ArrayList<FieldXMLInfo> annotatedFields = new ArrayList<FieldXMLInfo>();
            Class<?> currentClazz = clazz;
            while (currentClazz != Object.class) {
                Field[] fields = currentClazz.getDeclaredFields();
                objectArray = fields;
                n = fields.length;
                int n3 = 0;
                while (n3 < n) {
                    XMLAttribute attributeAnnotation;
                    Field field = objectArray[n3];
                    XMLElement elementAnnotation = field.getAnnotation(XMLElement.class);
                    if (elementAnnotation != null) {
                        String childName;
                        String name = elementAnnotation.name();
                        if (StringUtils.isEmpty(name)) {
                            name = field.getName();
                        }
                        Stringyfier valueFormatter = null;
                        if (elementAnnotation.valueFormatter() != DummyStringyfier.class) {
                            try {
                                valueFormatter = elementAnnotation.valueFormatter().newInstance();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (Collection.class.isAssignableFrom(field.getType())) {
                            boolean elementable = false;
                            if (ReflectionUtils.isGenericlyTyped(field) && Elementable.class.isAssignableFrom((Class)ReflectionUtils.getGenericType(field))) {
                                elementable = true;
                            }
                            if (StringUtils.isEmpty(childName = elementAnnotation.childName())) {
                                childName = "value";
                            }
                            annotatedFields.add(new FieldXMLInfo(name, field, FieldType.Element, elementAnnotation.cdata(), elementable, true, false, childName, elementAnnotation.skipChildParentElement(), valueFormatter));
                        } else if (field.getType().isArray()) {
                            boolean elementable = false;
                            if (Elementable.class.isAssignableFrom(field.getType())) {
                                elementable = true;
                            }
                            if (StringUtils.isEmpty(childName = elementAnnotation.childName())) {
                                childName = "value";
                            }
                            annotatedFields.add(new FieldXMLInfo(name, field, FieldType.Element, elementAnnotation.cdata(), elementable, false, true, childName, elementAnnotation.skipChildParentElement(), valueFormatter));
                        } else {
                            String childName2 = null;
                            if (!StringUtils.isEmpty(elementAnnotation.childName())) {
                                childName2 = elementAnnotation.childName();
                            }
                            annotatedFields.add(new FieldXMLInfo(name, field, FieldType.Element, elementAnnotation.cdata(), Elementable.class.isAssignableFrom(field.getType()), false, false, childName2, false, valueFormatter));
                        }
                        ReflectionUtils.fixFieldAccess(field);
                    }
                    if ((attributeAnnotation = field.getAnnotation(XMLAttribute.class)) != null) {
                        String name = attributeAnnotation.name();
                        if (StringUtils.isEmpty(name)) {
                            name = field.getName();
                        }
                        Stringyfier valueFormatter = null;
                        if (attributeAnnotation.valueFormatter() != DummyStringyfier.class) {
                            try {
                                valueFormatter = attributeAnnotation.valueFormatter().newInstance();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        annotatedFields.add(new FieldXMLInfo(name, field, FieldType.Attribute, false, false, false, false, null, false, valueFormatter));
                        ReflectionUtils.fixFieldAccess(field);
                    }
                    ++n3;
                }
                currentClazz = currentClazz.getSuperclass();
            }
            if (annotatedFields.isEmpty()) {
                throw new NoAnnotatedFieldsFoundException(clazz, XMLElement.class, XMLAttribute.class);
            }
            classInfo = new ClassXMLInfo(elementName, annotatedFields);
            FIELD_MAP.put(clazz, classInfo);
        }
        Element classElement = doc.createElement(classInfo.getElementName());
        for (FieldXMLInfo fieldInfo : classInfo.getFields()) {
            Element subElement;
            Object[] fieldValues;
            Object fieldValue;
            try {
                fieldValue = fieldInfo.getField().get(bean);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (fieldValue == null) continue;
            if (!fieldInfo.isList() && fieldInfo.getValueFormatter() != null) {
                fieldValue = fieldInfo.getValueFormatter().format(fieldValue);
            } else if (fieldValue instanceof Date) {
                fieldValue = DateUtils.DATE_TIME_FORMATTER.format(fieldValue);
            }
            if (fieldInfo.getFieldType() == FieldType.Attribute) {
                classElement.setAttribute(fieldInfo.getName(), fieldValue.toString());
                continue;
            }
            if (fieldInfo.isList()) {
                fieldValues = (Object[])fieldValue;
                if (fieldValues.isEmpty()) continue;
                subElement = fieldInfo.skipSubElement() ? classElement : doc.createElement(fieldInfo.getName());
                for (Object e : fieldValues) {
                    if (e == null) continue;
                    XMLGenerator.parseValue(fieldInfo, e, subElement, doc);
                }
                if (fieldInfo.skipSubElement() || !subElement.hasChildNodes()) continue;
                classElement.appendChild(subElement);
                continue;
            }
            if (fieldInfo.isArray()) {
                fieldValues = (Object[])fieldValue;
                if (ArrayUtils.isEmpty(fieldValues)) continue;
                subElement = fieldInfo.skipSubElement() ? classElement : doc.createElement(fieldInfo.getName());
                objectArray = fieldValues;
                n = fieldValues.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object != null) {
                        XMLGenerator.parseValue(fieldInfo, object, subElement, doc);
                    }
                    ++n2;
                }
                if (fieldInfo.skipSubElement() || !subElement.hasChildNodes()) continue;
                classElement.appendChild(subElement);
                continue;
            }
            if (fieldInfo.isElementable()) {
                Element subElement2 = ((Elementable)fieldValue).toXML(doc);
                if (subElement2 == null) continue;
                if (fieldInfo.getChildName() != null) {
                    Element middleElement = doc.createElement(fieldInfo.getChildName());
                    classElement.appendChild(middleElement);
                    middleElement.appendChild(subElement2);
                    continue;
                }
                classElement.appendChild(subElement2);
                continue;
            }
            if (fieldInfo.isCDATA()) {
                classElement.appendChild(XMLUtils.createCDATAElement(fieldInfo.getName(), fieldValue.toString(), doc));
                continue;
            }
            classElement.appendChild(XMLUtils.createElement(fieldInfo.getName(), fieldValue.toString(), doc));
        }
        return classElement;
    }

    private static void parseValue(FieldXMLInfo fieldInfo, Object value, Element subElement, Document doc) {
        if (fieldInfo.getValueFormatter() != null) {
            value = fieldInfo.getValueFormatter().format(value);
        } else if (value instanceof Date) {
            value = DateUtils.DATE_TIME_FORMATTER.format(value);
        }
        if (fieldInfo.isElementable()) {
            Element subSubElement = ((Elementable)value).toXML(doc);
            if (subSubElement != null) {
                subElement.appendChild(subSubElement);
            }
        } else if (fieldInfo.isCDATA()) {
            subElement.appendChild(XMLUtils.createCDATAElement(fieldInfo.getChildName(), value, doc));
        } else {
            subElement.appendChild(XMLUtils.createElement(fieldInfo.getChildName(), value, doc));
        }
    }
}

