/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ApiCachingBehavior {
    FULL_REQUEST_CACHING("FULL_REQUEST_CACHING"),
    PER_RESOLVER_CACHING("PER_RESOLVER_CACHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ApiCachingBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiCachingBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ApiCachingBehavior.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiCachingBehavior> knownValues() {
        return Stream.of(ApiCachingBehavior.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

