/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCode {
    BAD_REQUEST("BadRequest"),
    CONFLICT("Conflict"),
    FORBIDDEN("Forbidden"),
    NOT_FOUND("NotFound"),
    PRECONDITION_FAILED("PreconditionFailed"),
    RESOURCE_LIMIT_EXCEEDED("ResourceLimitExceeded"),
    SERVICE_FAILURE("ServiceFailure"),
    ACCESS_DENIED("AccessDenied"),
    SERVICE_UNAVAILABLE("ServiceUnavailable"),
    THROTTLED("Throttled"),
    UNAUTHORIZED("Unauthorized"),
    UNPROCESSABLE("Unprocessable"),
    VOICE_CONNECTOR_GROUP_ASSOCIATIONS_EXIST("VoiceConnectorGroupAssociationsExist"),
    PHONE_NUMBER_ASSOCIATIONS_EXIST("PhoneNumberAssociationsExist"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        return Stream.of(ErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

