/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type used for enabling software token MFA at the user level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwareTokenMfaSettingsType implements SdkPojo, Serializable,
        ToCopyableBuilder<SoftwareTokenMfaSettingsType.Builder, SoftwareTokenMfaSettingsType> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(SoftwareTokenMfaSettingsType::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> PREFERRED_MFA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PreferredMfa").getter(getter(SoftwareTokenMfaSettingsType::preferredMfa))
            .setter(setter(Builder::preferredMfa))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfa").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            PREFERRED_MFA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean preferredMfa;

    private SoftwareTokenMfaSettingsType(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.preferredMfa = builder.preferredMfa;
    }

    /**
     * <p>
     * Specifies whether software token MFA is enabled.
     * </p>
     * 
     * @return Specifies whether software token MFA is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies whether software token MFA is the preferred MFA method.
     * </p>
     * 
     * @return Specifies whether software token MFA is the preferred MFA method.
     */
    public Boolean preferredMfa() {
        return preferredMfa;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMfa());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareTokenMfaSettingsType)) {
            return false;
        }
        SoftwareTokenMfaSettingsType other = (SoftwareTokenMfaSettingsType) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(preferredMfa(), other.preferredMfa());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SoftwareTokenMfaSettingsType").add("Enabled", enabled()).add("PreferredMfa", preferredMfa())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "PreferredMfa":
            return Optional.ofNullable(clazz.cast(preferredMfa()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwareTokenMfaSettingsType, T> g) {
        return obj -> g.apply((SoftwareTokenMfaSettingsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwareTokenMfaSettingsType> {
        /**
         * <p>
         * Specifies whether software token MFA is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether software token MFA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies whether software token MFA is the preferred MFA method.
         * </p>
         * 
         * @param preferredMfa
         *        Specifies whether software token MFA is the preferred MFA method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMfa(Boolean preferredMfa);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean preferredMfa;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareTokenMfaSettingsType model) {
            enabled(model.enabled);
            preferredMfa(model.preferredMfa);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getPreferredMfa() {
            return preferredMfa;
        }

        @Override
        public final Builder preferredMfa(Boolean preferredMfa) {
            this.preferredMfa = preferredMfa;
            return this;
        }

        public final void setPreferredMfa(Boolean preferredMfa) {
            this.preferredMfa = preferredMfa;
        }

        @Override
        public SoftwareTokenMfaSettingsType build() {
            return new SoftwareTokenMfaSettingsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
