/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policy associated with a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolPolicyType implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolPolicyType.Builder, UserPoolPolicyType> {
    private static final SdkField<PasswordPolicyType> PASSWORD_POLICY_FIELD = SdkField
            .<PasswordPolicyType> builder(MarshallingType.SDK_POJO).memberName("PasswordPolicy")
            .getter(getter(UserPoolPolicyType::passwordPolicy)).setter(setter(Builder::passwordPolicy))
            .constructor(PasswordPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final PasswordPolicyType passwordPolicy;

    private UserPoolPolicyType(BuilderImpl builder) {
        this.passwordPolicy = builder.passwordPolicy;
    }

    /**
     * <p>
     * The password policy.
     * </p>
     * 
     * @return The password policy.
     */
    public PasswordPolicyType passwordPolicy() {
        return passwordPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolPolicyType)) {
            return false;
        }
        UserPoolPolicyType other = (UserPoolPolicyType) obj;
        return Objects.equals(passwordPolicy(), other.passwordPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserPoolPolicyType").add("PasswordPolicy", passwordPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordPolicy":
            return Optional.ofNullable(clazz.cast(passwordPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolPolicyType, T> g) {
        return obj -> g.apply((UserPoolPolicyType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolPolicyType> {
        /**
         * <p>
         * The password policy.
         * </p>
         * 
         * @param passwordPolicy
         *        The password policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordPolicy(PasswordPolicyType passwordPolicy);

        /**
         * <p>
         * The password policy.
         * </p>
         * This is a convenience that creates an instance of the {@link PasswordPolicyType.Builder} avoiding the need to
         * create one manually via {@link PasswordPolicyType#builder()}.
         *
         * When the {@link Consumer} completes, {@link PasswordPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #passwordPolicy(PasswordPolicyType)}.
         * 
         * @param passwordPolicy
         *        a consumer that will call methods on {@link PasswordPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordPolicy(PasswordPolicyType)
         */
        default Builder passwordPolicy(Consumer<PasswordPolicyType.Builder> passwordPolicy) {
            return passwordPolicy(PasswordPolicyType.builder().applyMutation(passwordPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PasswordPolicyType passwordPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolPolicyType model) {
            passwordPolicy(model.passwordPolicy);
        }

        public final PasswordPolicyType.Builder getPasswordPolicy() {
            return passwordPolicy != null ? passwordPolicy.toBuilder() : null;
        }

        @Override
        public final Builder passwordPolicy(PasswordPolicyType passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public final void setPasswordPolicy(PasswordPolicyType.BuilderImpl passwordPolicy) {
            this.passwordPolicy = passwordPolicy != null ? passwordPolicy.build() : null;
        }

        @Override
        public UserPoolPolicyType build() {
            return new UserPoolPolicyType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
