/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FeedbackValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventFeedbackType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventFeedbackType> {
    private static final SdkField<String> FEEDBACK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackValue").getter(EventFeedbackType.getter(EventFeedbackType::feedbackValueAsString)).setter(EventFeedbackType.setter(Builder::feedbackValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackValue").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(EventFeedbackType.getter(EventFeedbackType::provider)).setter(EventFeedbackType.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<Instant> FEEDBACK_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FeedbackDate").getter(EventFeedbackType.getter(EventFeedbackType::feedbackDate)).setter(EventFeedbackType.setter(Builder::feedbackDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEEDBACK_VALUE_FIELD, PROVIDER_FIELD, FEEDBACK_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String feedbackValue;
    private final String provider;
    private final Instant feedbackDate;

    private EventFeedbackType(BuilderImpl builder) {
        this.feedbackValue = builder.feedbackValue;
        this.provider = builder.provider;
        this.feedbackDate = builder.feedbackDate;
    }

    public FeedbackValueType feedbackValue() {
        return FeedbackValueType.fromValue(this.feedbackValue);
    }

    public String feedbackValueAsString() {
        return this.feedbackValue;
    }

    public String provider() {
        return this.provider;
    }

    public Instant feedbackDate() {
        return this.feedbackDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFeedbackType)) {
            return false;
        }
        EventFeedbackType other = (EventFeedbackType)obj;
        return Objects.equals(this.feedbackValueAsString(), other.feedbackValueAsString()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.feedbackDate(), other.feedbackDate());
    }

    public String toString() {
        return ToString.builder((String)"EventFeedbackType").add("FeedbackValue", (Object)this.feedbackValueAsString()).add("Provider", (Object)this.provider()).add("FeedbackDate", (Object)this.feedbackDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeedbackValue": {
                return Optional.ofNullable(clazz.cast(this.feedbackValueAsString()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "FeedbackDate": {
                return Optional.ofNullable(clazz.cast(this.feedbackDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventFeedbackType, T> g) {
        return obj -> g.apply((EventFeedbackType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String feedbackValue;
        private String provider;
        private Instant feedbackDate;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFeedbackType model) {
            this.feedbackValue(model.feedbackValue);
            this.provider(model.provider);
            this.feedbackDate(model.feedbackDate);
        }

        public final String getFeedbackValue() {
            return this.feedbackValue;
        }

        @Override
        public final Builder feedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
            return this;
        }

        @Override
        public final Builder feedbackValue(FeedbackValueType feedbackValue) {
            this.feedbackValue(feedbackValue == null ? null : feedbackValue.toString());
            return this;
        }

        public final void setFeedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final Instant getFeedbackDate() {
            return this.feedbackDate;
        }

        @Override
        public final Builder feedbackDate(Instant feedbackDate) {
            this.feedbackDate = feedbackDate;
            return this;
        }

        public final void setFeedbackDate(Instant feedbackDate) {
            this.feedbackDate = feedbackDate;
        }

        public EventFeedbackType build() {
            return new EventFeedbackType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventFeedbackType> {
        public Builder feedbackValue(String var1);

        public Builder feedbackValue(FeedbackValueType var1);

        public Builder provider(String var1);

        public Builder feedbackDate(Instant var1);
    }
}

