/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserPoolClientsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListUserPoolClientsResponse> {
    private static final SdkField<List<UserPoolClientDescription>> USER_POOL_CLIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserPoolClients").getter(ListUserPoolClientsResponse.getter(ListUserPoolClientsResponse::userPoolClients)).setter(ListUserPoolClientsResponse.setter(Builder::userPoolClients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolClients").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserPoolClientDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUserPoolClientsResponse.getter(ListUserPoolClientsResponse::nextToken)).setter(ListUserPoolClientsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_CLIENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<UserPoolClientDescription> userPoolClients;
    private final String nextToken;

    private ListUserPoolClientsResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolClients = builder.userPoolClients;
        this.nextToken = builder.nextToken;
    }

    public boolean hasUserPoolClients() {
        return this.userPoolClients != null && !(this.userPoolClients instanceof SdkAutoConstructList);
    }

    public List<UserPoolClientDescription> userPoolClients() {
        return this.userPoolClients;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolClients());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserPoolClientsResponse)) {
            return false;
        }
        ListUserPoolClientsResponse other = (ListUserPoolClientsResponse)((Object)obj);
        return Objects.equals(this.userPoolClients(), other.userPoolClients()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListUserPoolClientsResponse").add("UserPoolClients", this.userPoolClients()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolClients": {
                return Optional.ofNullable(clazz.cast(this.userPoolClients()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserPoolClientsResponse, T> g) {
        return obj -> g.apply((ListUserPoolClientsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<UserPoolClientDescription> userPoolClients = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserPoolClientsResponse model) {
            super(model);
            this.userPoolClients(model.userPoolClients);
            this.nextToken(model.nextToken);
        }

        public final Collection<UserPoolClientDescription.Builder> getUserPoolClients() {
            return this.userPoolClients != null ? (Collection)this.userPoolClients.stream().map(UserPoolClientDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userPoolClients(Collection<UserPoolClientDescription> userPoolClients) {
            this.userPoolClients = UserPoolClientListTypeCopier.copy(userPoolClients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPoolClients(UserPoolClientDescription ... userPoolClients) {
            this.userPoolClients(Arrays.asList(userPoolClients));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPoolClients(Consumer<UserPoolClientDescription.Builder> ... userPoolClients) {
            this.userPoolClients(Stream.of(userPoolClients).map(c -> (UserPoolClientDescription)((UserPoolClientDescription.Builder)UserPoolClientDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserPoolClients(Collection<UserPoolClientDescription.BuilderImpl> userPoolClients) {
            this.userPoolClients = UserPoolClientListTypeCopier.copyFromBuilder(userPoolClients);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserPoolClientsResponse build() {
            return new ListUserPoolClientsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserPoolClientsResponse> {
        public Builder userPoolClients(Collection<UserPoolClientDescription> var1);

        public Builder userPoolClients(UserPoolClientDescription ... var1);

        public Builder userPoolClients(Consumer<UserPoolClientDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

