/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CustomAttributesListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddCustomAttributesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AddCustomAttributesRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AddCustomAttributesRequest.getter(AddCustomAttributesRequest::userPoolId)).setter(AddCustomAttributesRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<List<SchemaAttributeType>> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomAttributes").getter(AddCustomAttributesRequest.getter(AddCustomAttributesRequest::customAttributes)).setter(AddCustomAttributesRequest.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaAttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CUSTOM_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddCustomAttributesRequest.memberNameToFieldInitializer();
    private final String userPoolId;
    private final List<SchemaAttributeType> customAttributes;

    private AddCustomAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.customAttributes = builder.customAttributes;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final boolean hasCustomAttributes() {
        return this.customAttributes != null && !(this.customAttributes instanceof SdkAutoConstructList);
    }

    public final List<SchemaAttributeType> customAttributes() {
        return this.customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAttributes() ? this.customAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCustomAttributesRequest)) {
            return false;
        }
        AddCustomAttributesRequest other = (AddCustomAttributesRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && this.hasCustomAttributes() == other.hasCustomAttributes() && Objects.equals(this.customAttributes(), other.customAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AddCustomAttributesRequest").add("UserPoolId", (Object)this.userPoolId()).add("CustomAttributes", this.hasCustomAttributes() ? this.customAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("CustomAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddCustomAttributesRequest, T> g) {
        return obj -> g.apply((AddCustomAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<SchemaAttributeType> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddCustomAttributesRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.customAttributes(model.customAttributes);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final List<SchemaAttributeType.Builder> getCustomAttributes() {
            List<SchemaAttributeType.Builder> result = CustomAttributesListTypeCopier.copyToBuilder(this.customAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAttributes(Collection<SchemaAttributeType.BuilderImpl> customAttributes) {
            this.customAttributes = CustomAttributesListTypeCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public final Builder customAttributes(Collection<SchemaAttributeType> customAttributes) {
            this.customAttributes = CustomAttributesListTypeCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(SchemaAttributeType ... customAttributes) {
            this.customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<SchemaAttributeType.Builder> ... customAttributes) {
            this.customAttributes(Stream.of(customAttributes).map(c -> (SchemaAttributeType)((SchemaAttributeType.Builder)SchemaAttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddCustomAttributesRequest build() {
            return new AddCustomAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddCustomAttributesRequest> {
        public Builder userPoolId(String var1);

        public Builder customAttributes(Collection<SchemaAttributeType> var1);

        public Builder customAttributes(SchemaAttributeType ... var1);

        public Builder customAttributes(Consumer<SchemaAttributeType.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

