/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsEnforcementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TermsDescriptionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TermsDescriptionType> {
    private static final SdkField<String> TERMS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsId").getter(TermsDescriptionType.getter(TermsDescriptionType::termsId)).setter(TermsDescriptionType.setter(Builder::termsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsId").build()}).build();
    private static final SdkField<String> TERMS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsName").getter(TermsDescriptionType.getter(TermsDescriptionType::termsName)).setter(TermsDescriptionType.setter(Builder::termsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsName").build()}).build();
    private static final SdkField<String> ENFORCEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enforcement").getter(TermsDescriptionType.getter(TermsDescriptionType::enforcementAsString)).setter(TermsDescriptionType.setter(Builder::enforcement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforcement").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(TermsDescriptionType.getter(TermsDescriptionType::creationDate)).setter(TermsDescriptionType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(TermsDescriptionType.getter(TermsDescriptionType::lastModifiedDate)).setter(TermsDescriptionType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_ID_FIELD, TERMS_NAME_FIELD, ENFORCEMENT_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TermsDescriptionType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String termsId;
    private final String termsName;
    private final String enforcement;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private TermsDescriptionType(BuilderImpl builder) {
        this.termsId = builder.termsId;
        this.termsName = builder.termsName;
        this.enforcement = builder.enforcement;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String termsId() {
        return this.termsId;
    }

    public final String termsName() {
        return this.termsName;
    }

    public final TermsEnforcementType enforcement() {
        return TermsEnforcementType.fromValue(this.enforcement);
    }

    public final String enforcementAsString() {
        return this.enforcement;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.termsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforcementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermsDescriptionType)) {
            return false;
        }
        TermsDescriptionType other = (TermsDescriptionType)obj;
        return Objects.equals(this.termsId(), other.termsId()) && Objects.equals(this.termsName(), other.termsName()) && Objects.equals(this.enforcementAsString(), other.enforcementAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"TermsDescriptionType").add("TermsId", (Object)this.termsId()).add("TermsName", (Object)this.termsName()).add("Enforcement", (Object)this.enforcementAsString()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TermsId": {
                return Optional.ofNullable(clazz.cast(this.termsId()));
            }
            case "TermsName": {
                return Optional.ofNullable(clazz.cast(this.termsName()));
            }
            case "Enforcement": {
                return Optional.ofNullable(clazz.cast(this.enforcementAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TermsId", TERMS_ID_FIELD);
        map.put("TermsName", TERMS_NAME_FIELD);
        map.put("Enforcement", ENFORCEMENT_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermsDescriptionType, T> g) {
        return obj -> g.apply((TermsDescriptionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String termsId;
        private String termsName;
        private String enforcement;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TermsDescriptionType model) {
            this.termsId(model.termsId);
            this.termsName(model.termsName);
            this.enforcement(model.enforcement);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getTermsId() {
            return this.termsId;
        }

        public final void setTermsId(String termsId) {
            this.termsId = termsId;
        }

        @Override
        public final Builder termsId(String termsId) {
            this.termsId = termsId;
            return this;
        }

        public final String getTermsName() {
            return this.termsName;
        }

        public final void setTermsName(String termsName) {
            this.termsName = termsName;
        }

        @Override
        public final Builder termsName(String termsName) {
            this.termsName = termsName;
            return this;
        }

        public final String getEnforcement() {
            return this.enforcement;
        }

        public final void setEnforcement(String enforcement) {
            this.enforcement = enforcement;
        }

        @Override
        public final Builder enforcement(String enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        @Override
        public final Builder enforcement(TermsEnforcementType enforcement) {
            this.enforcement(enforcement == null ? null : enforcement.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public TermsDescriptionType build() {
            return new TermsDescriptionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TermsDescriptionType> {
        public Builder termsId(String var1);

        public Builder termsName(String var1);

        public Builder enforcement(String var1);

        public Builder enforcement(TermsEnforcementType var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

